/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.compat;

import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface DirectionBlockProperty
extends BlockProperty<ForgeDirection> {
    default public DirectionBlockProperty setName(String name) {
        return this;
    }

    @Override
    default public ForgeDirection parse(String text) throws Exception {
        return ForgeDirection.valueOf((String)text.toUpperCase());
    }

    @Override
    default public String stringify(ForgeDirection value) {
        return value.name().toLowerCase();
    }

    public static DirectionBlockProperty facing() {
        return new AbstractDirectionBlockProperty("facing"){

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                ForgeDirection dir = MMUtils.getIndexSafe(ForgeDirection.VALID_DIRECTIONS, world.func_72805_g(x, y, z));
                return dir == null ? ForgeDirection.UNKNOWN : dir;
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                if (value == ForgeDirection.UNKNOWN) {
                    return;
                }
                world.func_72921_c(x, y, z, value.ordinal(), 2);
            }
        };
    }

    public static DirectionBlockProperty facingVanilla(int mask) {
        return DirectionBlockProperty.facing(mask, dir -> {
            int n;
            switch (dir) {
                case NORTH: {
                    n = 3;
                    break;
                }
                case SOUTH: {
                    n = 4;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case UP: {
                    n = 0;
                    break;
                }
                case DOWN: {
                    n = 5;
                    break;
                }
                default: {
                    n = 3;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 0: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 5: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        });
    }

    public static DirectionBlockProperty facing(final int mask, final D2M toMeta, final M2D toDir) {
        return new AbstractDirectionBlockProperty("facing"){

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                return toDir.getDir(world.func_72805_g(x, y, z) & mask);
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                int meta = 0;
                if (mask != -1) {
                    meta = world.func_72805_g(x, y, z) & ~mask;
                }
                world.func_72921_c(x, y, z, toMeta.getMeta(value) | meta, 2);
            }
        };
    }

    public static DirectionBlockProperty facing(final D2M2 toMeta, final M2D toDir) {
        return new AbstractDirectionBlockProperty("facing"){

            @Override
            public ForgeDirection getValue(World world, int x, int y, int z) {
                return toDir.getDir(world.func_72805_g(x, y, z));
            }

            @Override
            public void setValue(World world, int x, int y, int z, ForgeDirection value) {
                int meta = world.func_72805_g(x, y, z);
                world.func_72921_c(x, y, z, toMeta.getMeta(value, meta), 2);
            }
        };
    }

    public static DirectionBlockProperty facing(int mask, int north, int south, int west, int east, int up, int down) {
        return DirectionBlockProperty.facing(mask, dir -> {
            int n;
            switch (dir) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NORTH: {
                    if (north == -1) {
                        n = 0;
                        break;
                    }
                    n = north;
                    break;
                }
                case SOUTH: {
                    if (south == -1) {
                        n = 0;
                        break;
                    }
                    n = south;
                    break;
                }
                case WEST: {
                    if (west == -1) {
                        n = 0;
                        break;
                    }
                    n = west;
                    break;
                }
                case EAST: {
                    if (east == -1) {
                        n = 0;
                        break;
                    }
                    n = east;
                    break;
                }
                case UP: {
                    if (up == -1) {
                        n = 0;
                        break;
                    }
                    n = up;
                    break;
                }
                case DOWN: {
                    if (down == -1) {
                        n = 0;
                        break;
                    }
                    n = down;
                    break;
                }
                case UNKNOWN: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            if (meta == north) {
                return ForgeDirection.NORTH;
            }
            if (meta == south) {
                return ForgeDirection.SOUTH;
            }
            if (meta == west) {
                return ForgeDirection.WEST;
            }
            if (meta == east) {
                return ForgeDirection.EAST;
            }
            if (meta == up) {
                return ForgeDirection.UP;
            }
            if (meta == down) {
                return ForgeDirection.DOWN;
            }
            return ForgeDirection.UNKNOWN;
        });
    }

    public static interface D2M {
        public int getMeta(ForgeDirection var1);
    }

    public static interface M2D {
        public ForgeDirection getDir(int var1);
    }

    public static interface D2M2 {
        public int getMeta(ForgeDirection var1, int var2);
    }

    public static abstract class AbstractDirectionBlockProperty
    implements DirectionBlockProperty {
        private String name;

        public AbstractDirectionBlockProperty(String name) {
            this.name = name;
        }

        @Override
        public DirectionBlockProperty setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

