/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemId;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BigItemStack {
    public Item item;
    public long stackSize;
    public int meta;
    public NBTTagCompound tag;
    public transient ItemId id;

    public BigItemStack() {
    }

    private BigItemStack(ItemStack stack) {
        this.item = stack.func_77973_b();
        this.stackSize = stack.field_77994_a;
        this.meta = Items.field_151008_G.getDamage(stack);
        this.tag = stack.func_77978_p();
    }

    private BigItemStack(ItemId id, long amount) {
        this(id.getItemStack());
        this.setStackSize(amount);
    }

    public ItemId getId() {
        if (this.id == null) {
            this.id = ItemId.create(this.item, this.meta, this.tag);
        }
        return this.id;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack(this.item, this.stackSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.stackSize, this.meta);
        stack.func_77982_d(this.tag == null ? null : (NBTTagCompound)this.tag.func_74737_b());
        return stack;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEItemStack getAEItemStack() {
        return (IAEItemStack)Objects.requireNonNull(AEItemStack.create((ItemStack)this.getItemStack())).setStackSize(this.stackSize);
    }

    public static BigItemStack create(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return new BigItemStack(stack);
    }

    public static BigItemStack create(ItemId id, long amount) {
        if (id == null) {
            return null;
        }
        return new BigItemStack(id, amount);
    }

    @Optional.Method(modid="appliedenergistics2")
    public static BigItemStack create(IAEItemStack stack) {
        if (stack == null) {
            return null;
        }
        return BigItemStack.create(stack.getItemStack()).setStackSize(stack.getStackSize());
    }

    public ItemStack remove(int stackSize) {
        if (this.stackSize < (long)stackSize) {
            ItemStack stack = new ItemStack(this.item, (int)this.stackSize, this.meta);
            stack.func_77982_d(this.tag == null ? null : (NBTTagCompound)this.tag.func_74737_b());
            this.stackSize = 0L;
            return stack;
        }
        ItemStack stack = new ItemStack(this.item, stackSize, this.meta);
        stack.func_77982_d(this.tag == null ? null : (NBTTagCompound)this.tag.func_74737_b());
        this.stackSize -= (long)stackSize;
        return stack;
    }

    public BigItemStack removeBig(int stackSize) {
        long toRemove = Math.min(this.stackSize, (long)stackSize);
        BigItemStack stack = this.copy().setStackSize(toRemove);
        this.stackSize -= toRemove;
        return stack;
    }

    public BigItemStack incStackSize(long stackSize) {
        this.stackSize += stackSize;
        return this;
    }

    public BigItemStack decStackSize(long stackSize) {
        this.stackSize -= stackSize;
        return this;
    }

    public List<ItemStack> toStacks() {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        while (this.stackSize > 0L) {
            stack.add(this.remove(Integer.MAX_VALUE));
        }
        return stack;
    }

    public List<ItemStack> toStacks(int stackSize) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        while (this.stackSize > 0L) {
            stack.add(this.remove(stackSize));
        }
        return stack;
    }

    public BigItemStack copy() {
        BigItemStack out = new BigItemStack();
        out.item = this.item;
        out.stackSize = this.stackSize;
        out.meta = this.meta;
        out.tag = this.tag == null ? null : (NBTTagCompound)this.tag.func_74737_b();
        return out;
    }

    public BigItemStack setStackSize(long stackSize) {
        this.stackSize = stackSize;
        return this;
    }

    public long getStackSize() {
        return this.stackSize;
    }

    public Item getItem() {
        return this.item;
    }

    public int getItemDamage() {
        return this.meta;
    }

    public boolean hasSubtypes() {
        return this.item.func_77614_k();
    }

    public boolean isSameType(ItemStack other) {
        if (other == null) {
            return false;
        }
        return this.item == other.func_77973_b() && this.meta == Items.field_151008_G.getDamage(other) && Objects.equals(this.tag, other.func_77978_p());
    }

    public boolean isSameType(BigItemStack other) {
        if (other == null) {
            return false;
        }
        return this.item == other.getItem() && this.meta == other.meta && Objects.equals(this.tag, other.tag);
    }
}

