/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedList;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.component.control.UISlimScrollbar;
import net.malisis.core.client.gui.event.component.ContentUpdateEvent;
import net.malisis.core.client.gui.event.component.SpaceChangeEvent;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.util.bbcode.BBString;
import net.malisis.core.util.bbcode.render.BBCodeRenderer;
import net.malisis.core.util.bbcode.render.IBBCodeRenderer;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.StringUtils;

public class UILabel
extends UIComponent<UILabel>
implements IScrollable,
IGuiText<UILabel>,
IBBCodeRenderer<UILabel> {
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontRenderOptions fro = new FontRenderOptions();
    protected String text;
    protected BBString bbText;
    protected BBCodeRenderer bbRenderer;
    protected List<String> lines = new LinkedList<String>();
    protected boolean multiLine = false;
    protected int lineOffset = 0;
    protected int lineSpacing = 1;
    protected UISlimScrollbar scrollBar;
    protected int textWidth;
    protected int textHeight;

    public UILabel(MalisisGui gui, String text, boolean multiLine) {
        super(gui);
        this.setText(text);
        this.multiLine = multiLine;
        this.fro.color = 0x444444;
    }

    public UILabel(MalisisGui gui, BBString text) {
        this(gui);
        this.setText(text);
        this.multiLine = true;
        this.fro.color = 0x444444;
    }

    public UILabel(MalisisGui gui, String text) {
        this(gui, text, false);
    }

    public UILabel(MalisisGui gui, boolean multiLine) {
        this(gui, null, multiLine);
    }

    public UILabel(MalisisGui gui) {
        this(gui, null, false);
    }

    public String getText() {
        return this.text;
    }

    public UILabel setText(String text) {
        if (text == this.text || text != null && text.equals(this.text)) {
            return this;
        }
        this.text = text;
        this.bbText = null;
        if (this.multiLine) {
            this.buildLines();
        } else {
            this.calculateSize();
        }
        return this;
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UILabel setFont(MalisisFont font) {
        this.font = font;
        this.calculateSize();
        return this;
    }

    @Override
    public FontRenderOptions getFontRenderOptions() {
        return this.fro;
    }

    @Override
    public UILabel setFontRenderOptions(FontRenderOptions fro) {
        this.fro = fro;
        this.calculateSize();
        return this;
    }

    @Override
    public float getFontScale() {
        return this.fro.fontScale;
    }

    @Override
    public int getContentWidth() {
        return this.getWidth();
    }

    @Override
    public int getContentHeight() {
        return this.lines.size() * this.getLineHeight();
    }

    @Override
    public float getOffsetX() {
        return 0.0f;
    }

    @Override
    public void setOffsetX(float offsetX, int delta) {
    }

    @Override
    public float getOffsetY() {
        return (float)this.lineOffset / (float)(this.lines.size() - this.getVisibleLines());
    }

    @Override
    public void setOffsetY(float offsetY, int delta) {
        this.lineOffset = Math.round(offsetY / this.getScrollStep());
        this.lineOffset = Math.max(0, Math.min(this.lines.size(), this.lineOffset));
    }

    @Override
    public float getScrollStep() {
        float step = 1.0f / (float)(this.lines.size() - this.getVisibleLines());
        return GuiScreen.func_146271_m() ? 5.0f * step : step;
    }

    @Override
    public int getVerticalPadding() {
        return 0;
    }

    @Override
    public int getHorizontalPadding() {
        return 0;
    }

    @Override
    public BBString getBBText() {
        return this.bbText;
    }

    @Override
    public UILabel setText(BBString str) {
        if (!this.multiLine) {
            throw new IllegalArgumentException("Can only set BBString for multi line labels.");
        }
        this.setText(str.getRawText());
        this.bbText = str;
        this.bbText.buildRenderLines(this.lines);
        return this;
    }

    @Override
    public int getStartLine() {
        return this.lineOffset;
    }

    @Override
    public int getVisibleLines() {
        return this.getHeight() / this.getLineHeight();
    }

    @Override
    public int getLineHeight() {
        return (int)(this.font.getStringHeight(this.fro) + (float)this.lineSpacing);
    }

    @Override
    public UIComponent getComponentAt(int x, int y) {
        return this.multiLine ? super.getComponentAt(x, y) : null;
    }

    protected void buildLines() {
        this.lines.clear();
        if (!StringUtils.isEmpty((CharSequence)this.text)) {
            this.lines = this.font.wrapText(this.text, this.getWidth(), this.fro);
        }
        this.fireEvent(new ContentUpdateEvent<UILabel>(this));
    }

    protected void calculateSize() {
        if (this.multiLine) {
            return;
        }
        this.textWidth = (int)this.font.getStringWidth(this.text, this.fro);
        this.textHeight = (int)this.font.getStringHeight(this.fro);
        this.setSize(this.textWidth, this.textHeight);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.bbText != null) {
            this.bbText.render(renderer, this.screenX(), this.screenY(), this.getZIndex(), this);
            return;
        }
        if (this.multiLine) {
            this.fro.resetStyles();
            for (int i = this.lineOffset; i < this.lineOffset + this.getVisibleLines() && i < this.lines.size(); ++i) {
                this.fro.setLineFro(this.fro);
                int h = (i - this.lineOffset) * this.getLineHeight();
                renderer.drawText(this.font, this.lines.get(i), 0.0f, h, 0.0f, this.fro);
            }
        } else {
            renderer.drawText(this.font, this.text, this.fro);
        }
    }

    @Subscribe
    public void onSizeChange(SpaceChangeEvent.SizeChangeEvent<UILabel> event) {
        this.buildLines();
    }

    @Override
    public String getPropertyString() {
        return "text=" + this.text + " | " + super.getPropertyString();
    }
}

