/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.cartography.ColorManager;
import journeymap.client.data.DataCache;
import journeymap.client.data.WaypointsData;
import journeymap.client.data.WorldData;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.io.migrate.Migration;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.log.LogFormatter;
import journeymap.client.log.StatTimer;
import journeymap.client.model.RegionImageCache;
import journeymap.client.network.WorldInfoHandler;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.properties.MiniMapProperties2;
import journeymap.client.properties.PropertiesBase;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.properties.WebMapProperties;
import journeymap.client.render.map.TileDrawStepCache;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.main.MainTaskController;
import journeymap.client.task.main.MappingMonitorTask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.client.task.multi.TaskController;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.WaypointStore;
import journeymap.client.webmap.WebMap;
import journeymap.common.CommonProxy;
import journeymap.common.Journeymap;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class JourneymapClient
implements CommonProxy {
    public static final String FULL_VERSION = "10.13.4.1614-" + Journeymap.JM_VERSION;
    public static final String EDITION = JourneymapClient.getEdition();
    public static final String MOD_NAME = "JourneyMap " + EDITION;
    private static JourneymapClient instance;
    private volatile CoreProperties coreProperties;
    private volatile FullMapProperties fullMapProperties;
    private volatile MiniMapProperties miniMapProperties1;
    private volatile MiniMapProperties2 miniMapProperties2;
    private volatile WebMapProperties webMapProperties;
    private volatile WaypointProperties waypointProperties;
    private volatile Boolean initialized = false;
    private volatile String currentWorldId = null;
    private volatile Minecraft mc;
    private Logger logger;
    private boolean threadLogging = false;
    private TaskController multithreadTaskController;
    private ChunkRenderController chunkRenderController;
    private volatile MainTaskController mainThreadTaskController;

    public JourneymapClient() {
        if (instance != null) {
            throw new IllegalArgumentException("Use instance() after initialization is complete");
        }
        instance = this;
    }

    public static JourneymapClient getInstance() {
        return instance;
    }

    private static String getEdition() {
        String ed = null;
        try {
            ed = Journeymap.JM_VERSION + " " + FeatureManager.getPolicySetName();
        }
        catch (Throwable t) {
            ed = Journeymap.JM_VERSION + " ?";
            t.printStackTrace(System.err);
        }
        return ed;
    }

    public static CoreProperties getCoreProperties() {
        return JourneymapClient.instance.coreProperties;
    }

    public static FullMapProperties getFullMapProperties() {
        return JourneymapClient.instance.fullMapProperties;
    }

    public static void disable() {
        JourneymapClient.instance.initialized = false;
        EventHandlerManager.unregisterAll();
        instance.stopMapping();
        DataCache.instance().purge();
    }

    public static MiniMapProperties getMiniMapProperties(int which) {
        switch (which) {
            case 2: {
                JourneymapClient.instance.miniMapProperties2.setActive(true);
                JourneymapClient.instance.miniMapProperties1.setActive(false);
                return JourneymapClient.getMiniMapProperties2();
            }
        }
        JourneymapClient.instance.miniMapProperties1.setActive(true);
        JourneymapClient.instance.miniMapProperties2.setActive(false);
        return JourneymapClient.getMiniMapProperties1();
    }

    public static int getActiveMinimapId() {
        if (JourneymapClient.instance.miniMapProperties1.isActive()) {
            return 1;
        }
        return 2;
    }

    public static MiniMapProperties getMiniMapProperties1() {
        return JourneymapClient.instance.miniMapProperties1;
    }

    public static MiniMapProperties getMiniMapProperties2() {
        return JourneymapClient.instance.miniMapProperties2;
    }

    public static WebMapProperties getWebMapProperties() {
        return JourneymapClient.instance.webMapProperties;
    }

    public static WaypointProperties getWaypointProperties() {
        return JourneymapClient.instance.waypointProperties;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialize(FMLInitializationEvent event) throws Throwable {
        StatTimer timer = null;
        try {
            timer = StatTimer.getDisposable("elapsed").start();
            boolean migrationOk = new Migration().performTasks();
            this.logger = JMLogger.init();
            this.logger.info("initialize ENTER");
            if (this.initialized.booleanValue()) {
                this.logger.warn("Already initialized, aborting");
                return;
            }
            EntityRegistry.instance();
            this.loadConfigProperties();
            JMLogger.logProperties();
            this.threadLogging = false;
            this.logger.info("initialize EXIT, " + (timer == null ? "" : timer.getLogReportString()));
        }
        catch (Throwable t) {
            if (this.logger == null) {
                this.logger = LogManager.getLogger((String)"journeymap");
            }
            this.logger.error(LogFormatter.toString(t));
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitialize(FMLPostInitializationEvent event) {
        StatTimer timer = null;
        try {
            this.logger.info("postInitialize ENTER");
            timer = StatTimer.getDisposable("elapsed").start();
            this.mc = ForgeHelper.INSTANCE.getClient();
            this.mainThreadTaskController = new MainTaskController(this.mc, this);
            this.mainThreadTaskController.addTask(new MappingMonitorTask());
            EventHandlerManager.registerGeneralHandlers();
            EventHandlerManager.registerGuiHandlers();
            WaypointsData.enableRecheck();
            IconSetFileHandler.initialize();
            ThemeFileHandler.initialize();
            if (this.webMapProperties.enabled.get()) {
                WebMap.getInstance().start();
            }
            this.initialized = true;
            VersionCheck.getVersionAvailable();
            this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
        }
        catch (Throwable t) {
            try {
                if (this.logger == null) {
                    this.logger = LogManager.getLogger((String)"journeymap");
                }
                this.logger.error(LogFormatter.toString(t));
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
            }
            catch (Throwable throwable) {
                this.logger.info("postInitialize EXIT, " + (timer == null ? "" : timer.stopAndReport()));
                throw throwable;
            }
        }
        JMLogger.setLevelFromProperties();
    }

    @Override
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    @Override
    public boolean isUpdateCheckEnabled() {
        return JourneymapClient.getCoreProperties().checkUpdates.get();
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public Boolean isMapping() {
        return this.initialized != false && this.multithreadTaskController != null && this.multithreadTaskController.isMapping() != false;
    }

    public Boolean isThreadLogging() {
        return this.threadLogging;
    }

    public WebMap getJmServer() {
        return WebMap.getInstance();
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        if (this.multithreadTaskController != null) {
            this.multithreadTaskController.toggleTask(managerClass, enable, params);
        }
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        if (this.multithreadTaskController != null) {
            return this.multithreadTaskController.isTaskManagerEnabled(managerClass);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            boolean created;
            if (this.mc == null || this.mc.field_71441_e == null || !this.initialized.booleanValue() || !this.coreProperties.mappingEnabled.get()) {
                return;
            }
            File worldDir = FileHandler.getJMWorldDir(this.mc, this.currentWorldId);
            if (!worldDir.exists() && !(created = worldDir.mkdirs())) {
                JMLogger.logOnce("CANNOT CREATE DATA DIRECTORY FOR WORLD: " + worldDir.getPath(), null);
                return;
            }
            this.reset();
            ColorManager.instance().ensureCurrent();
            this.multithreadTaskController = new TaskController();
            this.multithreadTaskController.enableTasks();
            long totalMB = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
            long freeMB = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
            String memory = String.format("Memory: %sMB total, %sMB free", totalMB, freeMB);
            this.logger.info(String.format("Mapping started in %s%sDIM%s. %s ", FileHandler.getJMWorldDir(this.mc, this.currentWorldId), File.separator, ForgeHelper.INSTANCE.getDimension((World)this.mc.field_71441_e), memory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMapping() {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            if (this.isMapping().booleanValue() && this.mc != null) {
                RegionImageCache.instance().flushToDisk(false);
                this.logger.info(String.format("Mapping halted in %s%sDIM%s", FileHandler.getJMWorldDir(this.mc, this.currentWorldId), File.separator, ForgeHelper.INSTANCE.getDimension((World)this.mc.field_71441_e)));
            }
            if (this.multithreadTaskController != null) {
                this.multithreadTaskController.disableTasks();
                this.multithreadTaskController.clear();
                this.multithreadTaskController = null;
            }
        }
    }

    private void reset() {
        if (!this.mc.func_71356_B() && this.currentWorldId == null) {
            WorldInfoHandler.requestWorldID();
        }
        WorldData.dimNames.clear();
        this.loadConfigProperties();
        DataCache.instance().purge();
        this.chunkRenderController = new ChunkRenderController();
        Fullscreen.state().requireRefresh();
        Fullscreen.state().follow.set(true);
        StatTimer.resetAll();
        TileDrawStepCache.clear();
        UIManager.getInstance().getMiniMap().reset();
        UIManager.getInstance().reset();
        WaypointStore.instance().reset();
    }

    public void queueMainThreadTask(IMainThreadTask task) {
        this.mainThreadTaskController.addTask(task);
    }

    public void performMainThreadTasks() {
        try {
            this.mainThreadTaskController.performTasks();
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMainThreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    public void performMultithreadTasks() {
        try {
            if (this.isMapping().booleanValue()) {
                this.multithreadTaskController.performTasks();
            }
        }
        catch (Throwable t) {
            String error = "Error in JourneyMap.performMultithreadTasks(): " + t.getMessage();
            ChatLog.announceError(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }

    public ChunkRenderController getChunkRenderController() {
        return this.chunkRenderController;
    }

    public void loadConfigProperties() {
        this.coreProperties = PropertiesBase.reload(this.coreProperties, CoreProperties.class);
        this.fullMapProperties = PropertiesBase.reload(this.fullMapProperties, FullMapProperties.class);
        this.miniMapProperties1 = PropertiesBase.reload(this.miniMapProperties1, MiniMapProperties.class);
        this.miniMapProperties2 = PropertiesBase.reload(this.miniMapProperties2, MiniMapProperties2.class);
        this.webMapProperties = PropertiesBase.reload(this.webMapProperties, WebMapProperties.class);
        this.waypointProperties = PropertiesBase.reload(this.waypointProperties, WaypointProperties.class);
    }

    @Override
    public void handleWorldIdMessage(String worldId, EntityPlayerMP playerEntity) {
        this.setCurrentWorldId(worldId);
    }

    public String getCurrentWorldId() {
        return this.currentWorldId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentWorldId(String worldId) {
        JourneymapClient journeymapClient = this;
        synchronized (journeymapClient) {
            boolean directoryUnchanged;
            File currentWorldDirectory = FileHandler.getJMWorldDirForWorldId(this.mc, this.currentWorldId);
            File newWorldDirectory = FileHandler.getJMWorldDir(this.mc, worldId);
            boolean worldIdUnchanged = Constants.safeEqual(worldId, this.currentWorldId);
            boolean bl = directoryUnchanged = currentWorldDirectory != null && newWorldDirectory != null && currentWorldDirectory.getPath().equals(newWorldDirectory.getPath());
            if (worldIdUnchanged && directoryUnchanged && worldId != null) {
                Journeymap.getLogger().info("World UID hasn't changed: " + worldId);
                return;
            }
            boolean wasMapping = this.isMapping();
            if (wasMapping) {
                this.stopMapping();
            }
            this.currentWorldId = worldId;
            Journeymap.getLogger().info("World UID is set to: " + worldId);
        }
    }
}

