/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.properties.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.List;
import journeymap.client.ui.option.StringListProvider;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Config {
    public Category category();

    public boolean master() default false;

    public String key();

    public String defaultEnum() default "";

    public Class<? extends StringListProvider> stringListProvider() default NoStringProvider.class;

    public double minValue() default 0.0;

    public double maxValue() default 0.0;

    public double defaultValue() default 0.0;

    public boolean defaultBoolean() default true;

    public int sortOrder() default 100;

    public static class NoStringProvider
    implements StringListProvider {
        @Override
        public List<String> getStrings() {
            return Collections.emptyList();
        }

        @Override
        public String getDefaultString() {
            return null;
        }
    }

    public static enum None {
        NONE;

    }

    public static enum Category {
        Inherit(""),
        MiniMap1("jm.config.category.minimap"),
        MiniMap2("jm.config.category.minimap2"),
        FullMap("jm.config.category.fullmap"),
        WebMap("jm.config.category.webmap"),
        Radar("jm.config.category.radar"),
        Waypoint("jm.config.category.waypoint"),
        WaypointBeacon("jm.config.category.waypoint_beacons"),
        Cartography("jm.config.category.cartography"),
        Advanced("jm.config.category.advanced");

        public final String key;

        private Category(String key) {
            this.key = key;
        }
    }
}

