/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketExtremeRecipe;
import com.github.vfyjxf.nee.utils.ItemUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NEEExtremeAutoCrafterHandler
implements IOverlayHandler {
    public static final NEEExtremeAutoCrafterHandler instance = new NEEExtremeAutoCrafterHandler();

    private NEEExtremeAutoCrafterHandler() {
    }

    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        NEENetworkHandler.getInstance().sendToServer((IMessage)this.packetExtremeRecipe(recipe, recipeIndex));
    }

    private PacketExtremeRecipe packetExtremeRecipe(IRecipeHandler recipe, int recipeIndex) {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 3) / 18;
            int row = (positionedStack.rely - 3) / 18;
            if (positionedStack.rely == 129) {
                col = (positionedStack.relx - 2) / 18;
            }
            int slotIndex = col + row * 9;
            ItemStack currentStack = positionedStack.item;
            ItemStack preferModItem = ItemUtils.getPreferModItem(positionedStack.items);
            if (preferModItem != null) {
                currentStack = preferModItem;
            }
            for (ItemStack stack : positionedStack.items) {
                if (!ItemUtils.isPreferItems(stack)) continue;
                currentStack = stack.func_77946_l();
            }
            recipeInputs.func_74782_a("#" + slotIndex, (NBTBase)ItemUtils.writeItemStackToNBT(currentStack, currentStack.field_77994_a));
        }
        return new PacketExtremeRecipe(recipeInputs);
    }

    @SubscribeEvent
    public void onActionPerformedEventPost(GuiRecipeButton.UpdateRecipeButtonsEvent.Post event) {
        GuiRecipe guiRecipe;
        GuiScreen guiScreen;
        if (NEEConfig.noShift && (guiScreen = event.gui) instanceof GuiRecipe && this.isGuiExtremeTerm(guiRecipe = (GuiRecipe)guiScreen)) {
            for (int i = 0; i < event.buttonList.size(); ++i) {
                Object e = event.buttonList.get(i);
                if (!(e instanceof GuiOverlayButton)) continue;
                GuiOverlayButton btn = (GuiOverlayButton)e;
                btn.setRequireShiftForOverlayRecipe(false);
            }
        }
    }

    private boolean isGuiExtremeTerm(GuiRecipe<?> gui) {
        return gui.firstGui != null && this.getClass().isInstance(gui.getHandler().getOverlayHandler(gui.firstGui, 0));
    }
}

