/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers.named;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.INamedArgumentHandler;
import dev.rndmorris.salisarcana.lib.EnumHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;

public abstract class EnumHandler<E extends Enum<E>>
implements INamedArgumentHandler {
    protected final Class<E> enumDefinition;

    public EnumHandler(Class<E> enumDefinition) {
        this.enumDefinition = enumDefinition;
    }

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        Enum result = EnumHelper.tryParseEnum((Enum[])((Enum[])this.enumDefinition.getEnumConstants()), (String)((String)args.next()));
        if (result == null) {
            throw new CommandException("salisarcana:error.unknown_value", new Object[]{args.next()});
        }
        return result;
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        args.next();
        if (args.hasNext()) {
            return null;
        }
        return Arrays.stream((Enum[])this.enumDefinition.getEnumConstants()).map(Enum::toString).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return this.enumDefinition;
    }
}

