/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import com.google.common.base.Optional;
import java.util.regex.Pattern;

public class FeatureNameExtractor {
    private static final Pattern PATTERN_ITEM_MULTI_PART = Pattern.compile("ItemMultiPart", 16);
    private static final Pattern PATTERN_ITEM_MULTI_MATERIAL = Pattern.compile("ItemMultiMaterial", 16);
    private static final Pattern PATTERN_QUARTZ = Pattern.compile("Quartz", 16);
    private final Class<?> clazz;
    private final Optional<String> subName;

    public FeatureNameExtractor(Class<?> clazz, Optional<String> subName) {
        this.clazz = clazz;
        this.subName = subName;
    }

    public String get() {
        String name = this.clazz.getSimpleName();
        if (name.startsWith("ItemMultiPart")) {
            name = PATTERN_ITEM_MULTI_PART.matcher(name).replaceAll("ItemPart");
        } else if (name.startsWith("ItemMultiMaterial")) {
            name = PATTERN_ITEM_MULTI_MATERIAL.matcher(name).replaceAll("ItemMaterial");
        }
        if (this.subName.isPresent()) {
            String subName = (String)this.subName.get();
            if (subName.startsWith("P2PTunnel")) {
                return "ItemPart.P2PTunnel";
            }
            if (subName.equals("CertusQuartzTools")) {
                return PATTERN_QUARTZ.matcher(name).replaceAll("CertusQuartz");
            }
            if (subName.equals("NetherQuartzTools")) {
                return PATTERN_QUARTZ.matcher(name).replaceAll("NetherQuartz");
            }
            name = name + '.' + subName;
        }
        return name;
    }
}

