/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.ICellCacheRegistry;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEMonitorHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.helpers.IPriorityHost;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.tile.storage.TileDrive;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileChest
extends AENetworkPowerTile
implements IMEChest,
IFluidHandler,
ITerminalHost,
IPriorityHost,
IConfigManagerHost,
IColorableTile,
IGridTickable {
    private static final ChestNoHandler NO_HANDLER = new ChestNoHandler();
    private static final int[] SIDES = new int[]{0};
    private static final int[] FRONT = new int[]{1};
    private static final int[] NO_SLOTS = new int[0];
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 2, Integer.MAX_VALUE, true);
    private final BaseActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager(this);
    private ItemStack storageType;
    private int priority = 0;
    private int state = 0;
    private int type = 0;
    private boolean wasActive = false;
    private AEColor paintedColor = AEColor.Transparent;
    private boolean isCached = false;
    private ICellHandler cellHandler;
    private MEMonitorHandler itemCell;
    private MEMonitorHandler fluidCell;
    private boolean displayNeedsUpdate;

    public TileChest() {
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(40.0));
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.config.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
    }

    public IMEInventory<IAEItemStack> getInternal(StorageChannel channel) throws ChestNoHandler {
        return this.getHandler(channel);
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        if (x == MENetworkPowerStorage.PowerEventType.REQUEST_POWER) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.displayNeedsUpdate = true;
        }
    }

    private void recalculateDisplay() {
        boolean currentActive;
        this.displayNeedsUpdate = false;
        int newState = 0;
        int newType = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x) << 3 * x;
            newType |= this.getCellType(x) << 2 * x;
        }
        if (this.isPowered()) {
            newState |= 8;
        }
        if (this.wasActive != (currentActive = this.getProxy().isActive())) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (this.state != newState || this.type != newType) {
            this.markForUpdate();
            this.state = newState;
            this.type = newType;
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(15, 15, false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.recalculateDisplay();
        return TickRateModulation.SAME;
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    public IMEInventoryHandler getInternalHandler(StorageChannel channel) {
        return this.cellHandler.getCellInventory(this.inv.func_70301_a(1), this, channel);
    }

    public IMEInventoryHandler getHandler(StorageChannel channel) throws ChestNoHandler {
        if (!this.isCached) {
            this.itemCell = null;
            this.fluidCell = null;
            ItemStack is = this.inv.func_70301_a(1);
            if (is != null) {
                this.isCached = true;
                this.cellHandler = AEApi.instance().registries().cell().getHandler(is);
                if (this.cellHandler != null) {
                    double power = 1.0;
                    IMEInventoryHandler itemCell = this.cellHandler.getCellInventory(is, this, StorageChannel.ITEMS);
                    IMEInventoryHandler fluidCell = this.cellHandler.getCellInventory(is, this, StorageChannel.FLUIDS);
                    if (itemCell != null) {
                        power += this.cellHandler.cellIdleDrain(is, itemCell);
                    } else if (fluidCell != null) {
                        power += this.cellHandler.cellIdleDrain(is, fluidCell);
                    }
                    this.getProxy().setIdlePowerUsage(power);
                    this.itemCell = this.wrap(itemCell);
                    this.fluidCell = this.wrap(fluidCell);
                }
            }
        }
        switch (channel) {
            case FLUIDS: {
                if (this.fluidCell == null) {
                    throw NO_HANDLER;
                }
                return this.fluidCell;
            }
            case ITEMS: {
                if (this.itemCell == null) {
                    throw NO_HANDLER;
                }
                return this.itemCell;
            }
        }
        return null;
    }

    private <StackType extends IAEStack> MEMonitorHandler<StackType> wrap(IMEInventoryHandler h) {
        if (h == null) {
            return null;
        }
        MEInventoryHandler ih = new MEInventoryHandler(h, h.getChannel());
        ih.setPriority(this.priority);
        ChestMonitorHandler g = new ChestMonitorHandler(ih);
        g.addListener(new ChestNetNotifier(h.getChannel()), (Object)g);
        return g;
    }

    public BaseActionSource getActionSource() {
        return this.mySrc;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state >> slot * 3 & 7;
        }
        ItemStack cell = this.inv.func_70301_a(1);
        ICellHandler ch = AEApi.instance().registries().cell().getHandler(cell);
        if (ch != null) {
            IMEInventoryHandler handler2;
            try {
                handler2 = this.getHandler(StorageChannel.ITEMS);
                if (handler2 instanceof ChestMonitorHandler) {
                    return ch.getStatusForCell(cell, ((ChestMonitorHandler)handler2).getInternalHandler());
                }
            }
            catch (ChestNoHandler handler2) {
                // empty catch block
            }
            try {
                handler2 = this.getHandler(StorageChannel.FLUIDS);
                if (handler2 instanceof ChestMonitorHandler) {
                    return ch.getStatusForCell(cell, ((ChestMonitorHandler)handler2).getInternalHandler());
                }
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public int getCellType(int slot) {
        if (Platform.isClient()) {
            return this.type >> slot * 2 & 3;
        }
        ItemStack cell = this.inv.func_70301_a(1);
        ICellHandler ch = AEApi.instance().registries().cell().getHandler(cell);
        ChestMonitorHandler tempCMH = null;
        if (ch != null) {
            IMEInventoryHandler iMEInventoryHandler;
            ChestMonitorHandler CMH;
            IMEInventoryHandler handler2;
            try {
                handler2 = this.getHandler(StorageChannel.ITEMS);
                if (handler2 instanceof ChestMonitorHandler) {
                    tempCMH = CMH = (ChestMonitorHandler)handler2;
                }
            }
            catch (ChestNoHandler handler2) {
                // empty catch block
            }
            try {
                handler2 = this.getHandler(StorageChannel.FLUIDS);
                if (handler2 instanceof ChestMonitorHandler) {
                    tempCMH = CMH = (ChestMonitorHandler)handler2;
                }
            }
            catch (ChestNoHandler handler3) {
                // empty catch block
            }
            if (tempCMH != null && (iMEInventoryHandler = tempCMH.getInternalHandler()) instanceof ICellCacheRegistry) {
                ICellCacheRegistry iccr = (ICellCacheRegistry)((Object)iMEInventoryHandler);
                switch (iccr.getCellType()) {
                    case ITEM: {
                        return 0;
                    }
                    case FLUID: {
                        return 1;
                    }
                    case ESSENTIA: {
                        return 2;
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (Platform.isClient()) {
            return (this.state & 8) == 8;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            try {
                gridPowered = this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        double stash = 0.0;
        try {
            IEnergyGrid eg = this.getProxy().getEnergy();
            stash = eg.extractAEPower(amt, mode, PowerMultiplier.ONE);
            if (stash >= amt) {
                return stash;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    @TileEvent(value=TileEventType.TICK)
    public void Tick_TileChest() {
        block6: {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            double idleUsage = this.getProxy().getIdlePowerUsage();
            try {
                double powerUsed;
                if (!this.getProxy().getEnergy().isNetworkPowered() && (powerUsed = this.extractAEPower(idleUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= idleUsage != (this.state & 8) > 0) {
                    this.displayNeedsUpdate = true;
                }
            }
            catch (GridAccessException e) {
                double powerUsed = this.extractAEPower(this.getProxy().getIdlePowerUsage(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (powerUsed + 0.1 >= idleUsage == (this.state & 8) > 0) break block6;
                this.displayNeedsUpdate = true;
            }
        }
        if (this.displayNeedsUpdate) {
            this.recalculateDisplay();
        }
        if (this.inv.func_70301_a(0) != null) {
            this.tryToStoreContents();
        }
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileChest(ByteBuf data) {
        data.writeByte(this.state);
        data.writeByte(this.type);
        data.writeByte(this.paintedColor.ordinal());
        ItemStack is = this.inv.func_70301_a(1);
        if (is == null) {
            data.writeInt(0);
        } else {
            data.writeInt(is.func_77960_j() << 16 | Item.func_150891_b((Item)is.func_77973_b()));
        }
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileChest(ByteBuf data) {
        int oldState = this.state;
        int oldTypes = this.type;
        ItemStack oldType = this.storageType;
        this.state = data.readByte() & 0xF;
        this.type = data.readByte() & 3;
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.getProxy().setColor(this.paintedColor);
        int item = data.readInt();
        this.storageType = item == 0 ? null : new ItemStack(Item.func_150899_d((int)(item & 0xFFFF)), 1, item >> 16);
        return oldPaintedColor != this.paintedColor || this.state != oldState || this.type != oldTypes || !Platform.isSameItemPrecise(oldType, this.storageType);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileChest(NBTTagCompound data) {
        this.config.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
            this.getProxy().setColor(this.paintedColor);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileChest(NBTTagCompound data) {
        this.config.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.displayNeedsUpdate = true;
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.displayNeedsUpdate = true;
    }

    public IMEMonitor getItemInventory() {
        return this.itemCell;
    }

    public IMEMonitor getFluidInventory() {
        return this.fluidCell;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        this.tryToStoreContents();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (slot == 1) {
            this.itemCell = null;
            this.fluidCell = null;
            this.isCached = false;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
                IStorageGrid gs = this.getProxy().getStorage();
                Platform.postChanges(gs, removed, added, this.mySrc);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (this.field_145850_b != null) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.markForUpdate();
            }
        }
    }

    @Override
    public boolean func_102007_a(int slotIndex, ItemStack insertingItem, int side) {
        if (slotIndex == 1) {
            if (AEApi.instance().registries().cell().getCellInventory(insertingItem, this, StorageChannel.ITEMS) != null) {
                return true;
            }
            if (AEApi.instance().registries().cell().getCellInventory(insertingItem, this, StorageChannel.FLUIDS) != null) {
                return true;
            }
        } else {
            try {
                IMEInventoryHandler cell = this.getHandler(StorageChannel.ITEMS);
                IAEItemStack returns = cell.injectItems(AEApi.instance().storage().createItemStack(this.inv.func_70301_a(0)), Actionable.SIMULATE, this.mySrc);
                return returns == null || returns.getStackSize() != (long)insertingItem.field_77994_a;
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        return slotIndex == 1;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        if (ForgeDirection.SOUTH == side) {
            return FRONT;
        }
        if (this.isPowered()) {
            try {
                if (this.getHandler(StorageChannel.ITEMS) != null) {
                    return SIDES;
                }
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return NO_SLOTS;
    }

    private void tryToStoreContents() {
        try {
            if (this.func_70301_a(0) != null) {
                IMEInventoryHandler cell = this.getHandler(StorageChannel.ITEMS);
                IAEItemStack returns = Platform.poweredInsert(this, cell, AEApi.instance().storage().createItemStack(this.inv.func_70301_a(0)), this.mySrc);
                if (returns == null) {
                    this.inv.func_70299_a(0, null);
                } else {
                    this.inv.func_70299_a(0, returns.getItemStack());
                }
            }
        }
        catch (ChestNoHandler chestNoHandler) {
            // empty catch block
        }
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive()) {
            try {
                return Collections.singletonList(this.getHandler(channel));
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.itemCell = null;
        this.fluidCell = null;
        this.isCached = false;
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        double req = (double)resource.amount / 500.0;
        double available = this.extractAEPower(req, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        if (available >= req - 0.01) {
            try {
                IMEInventoryHandler h = this.getHandler(StorageChannel.FLUIDS);
                this.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                AEFluidStack results = h.injectItems(AEFluidStack.create(resource), doFill ? Actionable.MODULATE : Actionable.SIMULATE, this.mySrc);
                if (results == null) {
                    return resource.amount;
                }
                return resource.amount - (int)results.getStackSize();
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        try {
            IMEInventoryHandler h = this.getHandler(StorageChannel.FLUIDS);
            return h.canAccept(AEFluidStack.create(new FluidStack(fluid, 1)));
        }
        catch (ChestNoHandler chestNoHandler) {
            return false;
        }
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        try {
            IMEInventoryHandler h = this.getHandler(StorageChannel.FLUIDS);
            if (h.getChannel() == StorageChannel.FLUIDS) {
                return new FluidTankInfo[]{new FluidTankInfo(null, 1)};
            }
        }
        catch (ChestNoHandler chestNoHandler) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        if (Platform.canAccess(this.getProxy(), src) && side != this.getForward()) {
            return this;
        }
        return null;
    }

    public ItemStack getStorageType() {
        if (this.isPowered()) {
            return this.storageType;
        }
        return null;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public boolean openGui(EntityPlayer p, ICellHandler ch, ItemStack cell, int side) {
        IMEInventoryHandler invHandler2;
        try {
            invHandler2 = this.getHandler(StorageChannel.ITEMS);
            if (ch != null && invHandler2 != null) {
                ch.openChestGui(p, this, ch, invHandler2, cell, StorageChannel.ITEMS);
                return true;
            }
        }
        catch (ChestNoHandler invHandler2) {
            // empty catch block
        }
        try {
            invHandler2 = this.getHandler(StorageChannel.FLUIDS);
            if (ch != null && invHandler2 != null) {
                ch.openChestGui(p, this, ch, invHandler2, cell, StorageChannel.FLUIDS);
                return true;
            }
        }
        catch (ChestNoHandler chestNoHandler) {
            // empty catch block
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor newPaintedColor, EntityPlayer who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.getProxy().setColor(this.paintedColor);
        if (this.getGridNode(side) != null) {
            this.getGridNode(side).updateState();
        }
        this.func_70296_d();
        this.markForUpdate();
        return true;
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    @Override
    public boolean toggleItemStorageCellLocking() {
        ItemStack cell = this.inv.func_70301_a(1);
        if (ItemBasicStorageCell.checkInvalidForLockingAndStickyCarding(cell, this.cellHandler)) {
            return false;
        }
        IMEInventoryHandler inv = this.cellHandler.getCellInventory(cell, this, StorageChannel.ITEMS);
        if (inv instanceof ICellInventoryHandler) {
            ICellInventoryHandler handler = (ICellInventoryHandler)inv;
            if (ItemBasicStorageCell.cellIsPartitioned(handler)) {
                TileDrive.unpartitionStorageCell(handler);
            } else {
                TileDrive.partitionStorageCellToItemsOnCell(handler);
            }
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public int applyStickyToItemStorageCells(ItemStack cards) {
        ICellWorkbenchItem cellItem;
        ItemStack cell = this.inv.func_70301_a(1);
        if (ItemBasicStorageCell.checkInvalidForLockingAndStickyCarding(cell, this.cellHandler) && cards.field_77994_a != 0) {
            return 0;
        }
        Item item = cell.func_77973_b();
        if (item instanceof ICellWorkbenchItem && TileDrive.applyStickyCardToItemStorageCell(this.cellHandler, cell, this, cellItem = (ICellWorkbenchItem)item)) {
            if (this.isCached) {
                this.isCached = false;
            }
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return 1;
        }
        return 0;
    }

    private static class ChestNoHandler
    extends Exception {
        private static final long serialVersionUID = 7995805326136526631L;

        private ChestNoHandler() {
        }
    }

    private class ChestMonitorHandler<T extends IAEStack>
    extends MEMonitorHandler<T> {
        public ChestMonitorHandler(IMEInventoryHandler<T> t) {
            super(t);
        }

        private IMEInventoryHandler<T> getInternalHandler() {
            IMEInventoryHandler h = this.getHandler();
            if (h instanceof MEInventoryHandler) {
                return (IMEInventoryHandler)((MEInventoryHandler)h).getInternal();
            }
            return this.getHandler();
        }

        @Override
        public T injectItems(T input, Actionable mode, BaseActionSource src) {
            if (src.isPlayer() && !this.securityCheck(((PlayerSource)src).player, SecurityPermissions.INJECT)) {
                return input;
            }
            return super.injectItems(input, mode, src);
        }

        private boolean securityCheck(EntityPlayer player, SecurityPermissions requiredPermission) {
            if (TileChest.this.getTile() instanceof IActionHost && requiredPermission != null) {
                IGrid g;
                IGridNode gn = ((IActionHost)TileChest.this.getTile()).getActionableNode();
                if (gn != null && (g = gn.getGrid()) != null) {
                    boolean requirePower = false;
                    ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                    if (sg.hasPermission(player, requiredPermission)) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public T extractItems(T request, Actionable mode, BaseActionSource src) {
            if (src.isPlayer() && !this.securityCheck(((PlayerSource)src).player, SecurityPermissions.EXTRACT)) {
                return null;
            }
            return super.extractItems(request, mode, src);
        }
    }

    private class ChestNetNotifier<T extends IAEStack<T>>
    implements IMEMonitorHandlerReceiver<T> {
        private final StorageChannel chan;

        public ChestNetNotifier(StorageChannel chan) {
            this.chan = chan;
        }

        @Override
        public boolean isValid(Object verificationToken) {
            if (this.chan == StorageChannel.ITEMS) {
                return verificationToken == TileChest.this.itemCell;
            }
            if (this.chan == StorageChannel.FLUIDS) {
                return verificationToken == TileChest.this.fluidCell;
            }
            return false;
        }

        @Override
        public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, BaseActionSource source) {
            try {
                if (TileChest.this.getProxy().isActive()) {
                    TileChest.this.getProxy().getStorage().postAlterationOfStoredItems(this.chan, change, TileChest.this.mySrc);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            TileChest.this.displayNeedsUpdate = true;
        }

        @Override
        public void onListUpdate() {
        }
    }
}

