/*
 * Decompiled with CFR 0.152.
 */
package xonin.backhand.mixins.early.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Objects;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistrySimple;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xonin.backhand.api.core.BackhandUtils;
import xonin.backhand.api.core.IBackhandPlayer;
import xonin.backhand.api.core.IOffhandInventory;
import xonin.backhand.hooks.containerfix.IContainerHook;
import xonin.backhand.packet.BackhandPacketHandler;
import xonin.backhand.packet.OffhandAnimationPacket;
import xonin.backhand.packet.OffhandSyncOffhandUse;

@Mixin(value={EntityPlayer.class})
public abstract class MixinEntityPlayer
extends EntityLivingBase
implements IBackhandPlayer {
    @Shadow
    private ItemStack field_71074_e;
    @Shadow
    public InventoryPlayer field_71071_by;
    @Unique
    private float backhand$offHandSwingProgress = 0.0f;
    @Unique
    private float backhand$prevOffHandSwingProgress = 0.0f;
    @Unique
    private int backhand$offHandSwingProgressInt = 0;
    @Unique
    private boolean backhand$isOffHandSwingInProgress = false;
    @Unique
    private boolean backhand$isOffhandItemInUs = false;

    private MixinEntityPlayer(World p_i1594_1_) {
        super(p_i1594_1_);
    }

    @WrapMethod(method={"onItemUseFinish"})
    private void backhand$onItemUseFinishEnd(Operation<Void> original) {
        EntityPlayer player = (EntityPlayer)this;
        if (Objects.equals(this.field_71074_e, BackhandUtils.getOffhandItem(player))) {
            BackhandUtils.useOffhandItem(player, () -> original.call(new Object[0]));
        } else {
            original.call(new Object[0]);
        }
    }

    @ModifyExpressionValue(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/InventoryPlayer;getCurrentItem()Lnet/minecraft/item/ItemStack;")})
    private ItemStack backhand$onUpdate$getCurrentItem(ItemStack original) {
        ItemStack itemStack = BackhandUtils.getOffhandItem((EntityPlayer)this);
        if (this.field_71074_e == itemStack) {
            return itemStack;
        }
        return original;
    }

    @Inject(method={"setItemInUse"}, at={@At(value="TAIL")})
    private void backhand$setItemInUse(ItemStack p_71008_1_, int p_71008_2_, CallbackInfo ci) {
        if (Objects.equals(p_71008_1_, BackhandUtils.getOffhandItem((EntityPlayer)this))) {
            this.backhand$updateOffhandUse(true);
        } else if (this.isOffhandItemInUse()) {
            this.backhand$updateOffhandUse(false);
        }
    }

    @Inject(method={"clearItemInUse"}, at={@At(value="TAIL")})
    private void backhand$clearOffhand(CallbackInfo ci) {
        if (this.isOffhandItemInUse()) {
            this.backhand$updateOffhandUse(false);
        }
    }

    @Inject(method={"updateEntityActionState"}, at={@At(value="TAIL")})
    private void backhand$updateOffhandSwingProgress(CallbackInfo ci) {
        this.backhand$prevOffHandSwingProgress = this.backhand$offHandSwingProgress;
        int var1 = this.func_82166_i();
        if (this.backhand$isOffHandSwingInProgress) {
            ++this.backhand$offHandSwingProgressInt;
            if (this.backhand$offHandSwingProgressInt >= var1) {
                this.backhand$offHandSwingProgressInt = 0;
                this.backhand$isOffHandSwingInProgress = false;
            }
        } else {
            this.backhand$offHandSwingProgressInt = 0;
        }
        this.backhand$offHandSwingProgress = (float)this.backhand$offHandSwingProgressInt / (float)var1;
    }

    @WrapWithCondition(method={"stopUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;onPlayerStoppedUsing(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;I)V")})
    private boolean backhand$stopUsingItem(ItemStack stack, World world, EntityPlayer player, int p_77974_3_) {
        ItemStack offhand = BackhandUtils.getOffhandItem(player);
        if (offhand != null && !this.isUsingOffhand() && stack.func_77975_n() == EnumAction.bow && ((RegistrySimple)BlockDispenser.field_149943_a).func_148741_d((Object)offhand.func_77973_b())) {
            int slot = this.field_71071_by.field_70461_c == 0 ? 1 : 0;
            ItemStack swappedStack = player.field_71071_by.field_70462_a[slot];
            this.field_71071_by.field_70462_a[slot] = offhand;
            BackhandUtils.setPlayerOffhandItem(player, swappedStack);
            stack.func_77974_b(world, player, p_77974_3_);
            player.field_71071_by.field_70462_a[slot] = this.backhand$getLegalStack(swappedStack);
            BackhandUtils.setPlayerOffhandItem(player, this.backhand$getLegalStack(offhand));
            return false;
        }
        return true;
    }

    @Redirect(method={"onUpdate"}, at=@At(value="INVOKE", target="net/minecraftforge/common/ForgeHooks.canInteractWith(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/inventory/Container;)Z", remap=false))
    private static boolean backhand$canInteractWith(EntityPlayer player, Container openContainer) {
        if (((IContainerHook)openContainer).backhand$wasOpenedWithOffhand()) {
            int currentItem = BackhandUtils.swapToOffhand(player);
            boolean retValue = ForgeHooks.canInteractWith((EntityPlayer)player, (Container)openContainer);
            BackhandUtils.swapBack(player, currentItem);
            return retValue;
        }
        return ForgeHooks.canInteractWith((EntityPlayer)player, (Container)openContainer);
    }

    @Unique
    private void backhand$updateOffhandUse(boolean state) {
        EntityPlayer player = (EntityPlayer)this;
        this.setOffhandItemInUse(state);
        if (!this.field_70170_p.field_72995_K) {
            BackhandPacketHandler.sendPacketToAllTracking((Entity)player, new OffhandSyncOffhandUse(player, state));
        }
    }

    public void func_71038_i() {
        if (this.isUsingOffhand()) {
            this.swingOffItem();
        } else {
            super.func_71038_i();
        }
    }

    @Override
    public void swingOffItem() {
        EntityPlayer player = (EntityPlayer)this;
        ItemStack stack = BackhandUtils.getOffhandItem(player);
        if (stack != null && stack.func_77973_b() != null && BackhandUtils.useOffhandItem(player, false, () -> stack.func_77973_b().onEntitySwing((EntityLivingBase)player, stack))) {
            return;
        }
        if (!this.backhand$isOffHandSwingInProgress || this.backhand$offHandSwingProgressInt >= this.func_82166_i() / 2 || this.backhand$offHandSwingProgressInt < 0) {
            this.backhand$offHandSwingProgressInt = -1;
            this.backhand$isOffHandSwingInProgress = true;
            if (!this.field_70170_p.field_72995_K) {
                BackhandPacketHandler.sendPacketToAllTracking((Entity)player, new OffhandAnimationPacket(player));
            }
        }
    }

    @Override
    public float getOffSwingProgress(float frame) {
        float diff = this.backhand$offHandSwingProgress - this.backhand$prevOffHandSwingProgress;
        if (diff < 0.0f) {
            diff += 1.0f;
        }
        return this.backhand$prevOffHandSwingProgress + diff * frame;
    }

    @Override
    public void setOffhandItemInUse(boolean usingOffhand) {
        this.backhand$isOffhandItemInUs = usingOffhand;
    }

    @Override
    public boolean isOffhandItemInUse() {
        return this.backhand$isOffhandItemInUs;
    }

    @Override
    public boolean isUsingOffhand() {
        return this.field_71071_by.field_70461_c == ((IOffhandInventory)this.field_71071_by).backhand$getOffhandSlot();
    }

    @Unique
    private ItemStack backhand$getLegalStack(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        return stack;
    }
}

