/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.block.BlockSpectralContainer;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class RitualEffectLava
extends RitualEffect {
    public static final int sanctusDrain = 20;
    public static final int offensaDrain = 50;
    public static final int reductusDrain = 5;
    public static final int fireFuseCost = 1000;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (this.canDrainReagent(ritualStone, ReagentRegistry.offensaReagent, 50, false) && SoulNetworkHandler.canSyphonFromOnlyNetwork(owner, 1000)) {
            boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 5, false);
            boolean drainReductus = world.func_82737_E() % 100L == 0L;
            int range = 5;
            List<EntityLivingBase> entityList = SpellHelper.getLivingEntitiesInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, range, range);
            EntityPlayer player = SpellHelper.getPlayerForUsername(owner);
            for (EntityLivingBase entity : entityList) {
                if (entity == player || !this.canDrainReagent(ritualStone, ReagentRegistry.offensaReagent, 50, false) || !SoulNetworkHandler.canSyphonFromOnlyNetwork(owner, 1000) || entity.func_70644_a(AlchemicalWizardry.customPotionFireFuse)) continue;
                if (hasReductus && this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 5, false) && entity instanceof EntityPlayer) {
                    if (!drainReductus) continue;
                    this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 5, true);
                    continue;
                }
                entity.func_70690_d(new PotionEffect(AlchemicalWizardry.customPotionFireFuse.field_76415_H, 100, 0));
                this.canDrainReagent(ritualStone, ReagentRegistry.offensaReagent, 50, true);
                SoulNetworkHandler.syphonFromNetwork(owner, 1000);
            }
        }
        Block block = world.func_147439_a(x, y + 1, z);
        if (world.func_147437_c(x, y + 1, z) && !(block instanceof BlockSpectralContainer)) {
            if (currentEssence < this.getCostPerRefresh()) {
                SoulNetworkHandler.causeNauseaToPlayer(owner);
            } else {
                for (int i = 0; i < 10; ++i) {
                    SpellHelper.sendIndexedParticleToAllAround(world, x, y, z, 20, world.field_73011_w.field_76574_g, 3, x, y, z);
                }
                world.func_147465_d(x, y + 1, z, Blocks.field_150353_l, 0, 3);
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
            }
        } else {
            int amount;
            boolean hasSanctus = this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 20, false);
            if (!hasSanctus) {
                return;
            }
            TileEntity tile = world.func_147438_o(x, y + 1, z);
            if (tile instanceof IFluidHandler && (amount = ((IFluidHandler)tile).fill(ForgeDirection.DOWN, new FluidStack(FluidRegistry.LAVA, 1000), false)) >= 1000) {
                ((IFluidHandler)tile).fill(ForgeDirection.DOWN, new FluidStack(FluidRegistry.LAVA, 1000), true);
                this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 20, true);
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostLava[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> lavaRitual = new ArrayList<RitualComponent>();
        lavaRitual.add(new RitualComponent(1, 0, 0, 2));
        lavaRitual.add(new RitualComponent(-1, 0, 0, 2));
        lavaRitual.add(new RitualComponent(0, 0, 1, 2));
        lavaRitual.add(new RitualComponent(0, 0, -1, 2));
        return lavaRitual;
    }
}

