/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.ItemStackAdapter;
import WayofTime.alchemicalWizardry.common.summoning.meteor.Meteor;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponentAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MeteorRegistry {
    public static List<Meteor> meteorList = new ArrayList<Meteor>();

    public static void loadConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(MeteorComponent.class, (Object)new MeteorComponentAdapter()).registerTypeAdapter(ItemStack.class, (Object)new ItemStackAdapter()).create();
        File file = new File("config/BloodMagic/meteors");
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                try {
                    if (f.isDirectory() || !f.getName().endsWith(".json")) continue;
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    Meteor m = (Meteor)gson.fromJson((Reader)br, Meteor.class);
                    MeteorRegistry.registerMeteor(m);
                }
                catch (JsonSyntaxException | FileNotFoundException e) {
                    AlchemicalWizardry.logger.warn("Error adding meteor {}", new Object[]{f.getName()});
                    e.printStackTrace();
                }
            }
        }
    }

    public static void registerMeteor(Meteor meteor) {
        meteor.validate();
        meteorList.add(meteor);
    }

    public static void registerMeteor(ItemStack stack, String[] componentList, int radius, int cost) {
        MeteorRegistry.registerMeteor(stack, MeteorComponent.parseStringArray(componentList), radius, cost, null, 0);
    }

    public static void registerMeteor(ItemStack stack, List<MeteorComponent> componentList, int radius, int cost, List<MeteorComponent> fillerList, int fillerChance) {
        if (stack != null && componentList != null) {
            Meteor meteor = new Meteor(stack, radius, cost, fillerChance, componentList, fillerList);
            meteor.validate();
            meteorList.add(meteor);
        }
    }

    public static void createMeteorImpact(World world, int x, int y, int z, int meteorID, List<Reagent> reagents) {
        if (meteorID < meteorList.size()) {
            meteorList.get(meteorID).createMeteorImpact(world, x, y, z, reagents);
        }
    }

    public static int getMeteorIDForItem(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        for (int i = 0; i < meteorList.size(); ++i) {
            ItemStack focusStack = MeteorRegistry.meteorList.get((int)i).focusItem;
            if (focusStack == null || focusStack.func_77973_b() != stack.func_77973_b() || focusStack.func_77960_j() != Short.MAX_VALUE && focusStack.func_77960_j() != stack.func_77960_j()) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidMeteorFocusItem(ItemStack stack) {
        return MeteorRegistry.getMeteorIDForItem(stack) != -1;
    }
}

