/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.guis;

import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGCraft;
import gcewing.sg.blocks.DHDBlock;
import gcewing.sg.interfaces.ISGEnergySource;
import gcewing.sg.tileentities.BaseTileInventory;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.utils.BaseBlockUtils;
import gcewing.sg.utils.Trans3;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import org.joml.Vector3d;
import org.joml.Vector3i;

public class DHDTE
extends BaseTileInventory
implements ISGEnergySource {
    public static boolean debugLink = false;
    public static int linkRangeX = 5;
    public static int linkRangeY = 1;
    public static int linkRangeZ = 6;
    public static final int firstFuelSlot = 0;
    public static final int numFuelSlots = 4;
    public static final int numSlots = 4;
    public boolean isLinkedToStargate;
    public Vector3i linkedPos = new Vector3i(0, 0, 0);
    public String enteredAddress = "";
    IInventory inventory = new InventoryBasic("DHD", false, 4);
    public static AxisAlignedBB bounds;
    public static double maxEnergyBuffer;
    public double energyInBuffer;

    public static void configure(BaseConfiguration cfg) {
        linkRangeX = cfg.getInteger("dhd", "linkRangeX", linkRangeX);
        linkRangeY = cfg.getInteger("dhd", "linkRangeY", linkRangeY);
        linkRangeZ = cfg.getInteger("dhd", "linkRangeZ", linkRangeZ);
        maxEnergyBuffer = SGBaseTE.energyPerFuelItem;
    }

    public static DHDTE at(IBlockAccess world, Vector3i pos) {
        TileEntity te = BaseBlockUtils.getWorldTileEntity(world, pos);
        if (te instanceof DHDTE) {
            return (DHDTE)te;
        }
        return null;
    }

    public static DHDTE at(IBlockAccess world, NBTTagCompound nbt) {
        Vector3i pos = new Vector3i(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        return DHDTE.at(world, pos);
    }

    public void setEnteredAddress(String address) {
        this.enteredAddress = address;
        this.markChanged();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return bounds.func_72321_a((double)this.getX() + 0.5, (double)this.getY(), (double)this.getZ() + 0.5);
    }

    public double func_145833_n() {
        return 32768.0;
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    public DHDBlock getBlock() {
        return (DHDBlock)this.func_145838_q();
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbt) {
        super.readContentsFromNBT(nbt);
        this.isLinkedToStargate = nbt.func_74767_n("isLinkedToStargate");
        this.energyInBuffer = nbt.func_74769_h("energyInBuffer");
        int x = nbt.func_74762_e("linkedX");
        int y = nbt.func_74762_e("linkedY");
        int z = nbt.func_74762_e("linkedZ");
        this.linkedPos = new Vector3i(x, y, z);
        this.enteredAddress = nbt.func_74779_i("enteredAddress");
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbt) {
        super.writeContentsToNBT(nbt);
        nbt.func_74757_a("isLinkedToStargate", this.isLinkedToStargate);
        nbt.func_74780_a("energyInBuffer", this.energyInBuffer);
        nbt.func_74768_a("linkedX", this.linkedPos.x);
        nbt.func_74768_a("linkedY", this.linkedPos.y);
        nbt.func_74768_a("linkedZ", this.linkedPos.z);
        nbt.func_74778_a("enteredAddress", this.enteredAddress);
    }

    public SGBaseTE getLinkedStargateTE() {
        TileEntity gte;
        if (this.isLinkedToStargate && (gte = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, this.linkedPos)) instanceof SGBaseTE) {
            return (SGBaseTE)gte;
        }
        return null;
    }

    public void checkForLink() {
        if (debugLink) {
            SGCraft.log.debug(String.format("DHDTE.checkForLink at %s: isLinkedToStargate = %s", this.getPos(), this.isLinkedToStargate));
        }
        if (this.isLinkedToStargate) {
            return;
        }
        Trans3 t = this.localToGlobalTransformation();
        for (int i = -linkRangeX; i <= linkRangeX; ++i) {
            for (int j = -linkRangeY; j <= linkRangeY; ++j) {
                for (int k = 1; k <= linkRangeZ; ++k) {
                    TileEntity te;
                    Vector3d p = t.p(new Vector3d((double)i, (double)j, (double)(-k)));
                    Vector3i blockPos = new Vector3i((int)Math.floor(p.x), (int)Math.floor(p.y), (int)Math.floor(p.z));
                    if (debugLink) {
                        SGCraft.log.debug(String.format("DHDTE.checkForLink: probing %s", blockPos));
                    }
                    if (!((te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)this.field_145850_b, blockPos)) instanceof SGBaseTE)) continue;
                    if (debugLink) {
                        SGCraft.log.debug(String.format("DHDTE.checkForLink: Found stargate at %s", BaseBlockUtils.getTileEntityPos(te)));
                    }
                    if (!this.linkToStargate((SGBaseTE)te)) continue;
                    return;
                }
            }
        }
    }

    boolean linkToStargate(SGBaseTE gte) {
        if (this.isLinkedToStargate || gte.isLinkedToController || !gte.isMerged) {
            return false;
        }
        if (debugLink) {
            SGCraft.log.debug(String.format("DHDTE.linkToStargate: Linking controller at %s with stargate at %s", this.getPos(), BaseBlockUtils.getTileEntityPos(gte)));
        }
        this.linkedPos = gte.getPos();
        this.isLinkedToStargate = true;
        this.markChanged();
        gte.linkedPos = this.getPos();
        gte.isLinkedToController = true;
        gte.markChanged();
        return true;
    }

    public void clearLinkToStargate() {
        if (debugLink) {
            SGCraft.log.debug(String.format("DHDTE: Unlinking controller at %s from stargate", this.getPos()));
        }
        this.isLinkedToStargate = false;
        this.markChanged();
    }

    @Override
    public double availableEnergy() {
        double energy = this.energyInBuffer;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.fuelStackInSlot(i);
            if (stack == null) continue;
            energy += (double)stack.field_77994_a * SGBaseTE.energyPerFuelItem;
        }
        return energy;
    }

    @Override
    public double drawEnergy(double amount) {
        double energyDrawn = 0.0;
        while (energyDrawn < amount && (this.energyInBuffer != 0.0 || this.useFuelItem())) {
            double e = Math.min(amount, this.energyInBuffer);
            energyDrawn += e;
            this.energyInBuffer -= e;
        }
        if (SGBaseTE.debugEnergyUse) {
            SGCraft.log.debug(String.format("DHDTE.drawEnergy: %s; supplied: %s; buffered: %s", amount, energyDrawn, this.energyInBuffer));
        }
        this.markChanged();
        return energyDrawn;
    }

    boolean useFuelItem() {
        for (int i = 3; i >= 0; --i) {
            ItemStack stack = this.fuelStackInSlot(i);
            if (stack == null) continue;
            this.func_70298_a(i, 1);
            this.energyInBuffer += SGBaseTE.energyPerFuelItem;
            return true;
        }
        return false;
    }

    ItemStack fuelStackInSlot(int i) {
        ItemStack stack = this.func_70301_a(0 + i);
        if (DHDTE.isValidFuelItem(stack)) {
            return stack;
        }
        return null;
    }

    public static boolean isValidFuelItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() == SGCraft.naquadah && stack.field_77994_a > 0;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return DHDTE.isValidFuelItem(stack);
    }
}

