/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling;

import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import iguanaman.iguanatweakstconstruct.leveling.modifiers.ModCritical;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.ToolCore;

public class LevelingActiveToolMod
extends ActiveToolMod {
    static List<Material> materialBlacklist = Arrays.asList(Material.field_151584_j, Material.field_151582_l, Material.field_151594_q, Material.field_151592_s, Material.field_76233_E, Material.field_151597_y);

    public boolean beforeBlockBreak(ToolCore tool, ItemStack stack, int x, int y, int z, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        if (entity instanceof FakePlayer) {
            return false;
        }
        if (!(tool instanceof HarvestTool)) {
            return false;
        }
        Block block = entity.field_70170_p.func_147439_a(x, y, z);
        int meta = entity.field_70170_p.func_72805_g(x, y, z);
        if (block == null || materialBlacklist.contains(block.func_149688_o())) {
            return false;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        HarvestTool harvestTool = (HarvestTool)tool;
        boolean harvestable = false;
        boolean effective = false;
        boolean strong = false;
        harvestable = harvestTool.canHarvestBlock(block, stack);
        Float strength = Float.valueOf(harvestTool.calculateStrength(tags, block, meta));
        strong = strength.floatValue() >= 1.0f;
        effective = harvestTool.isEffective(block.func_149688_o());
        boolean blockIsOre = false;
        ItemStack blockStack = new ItemStack(Item.func_150898_a((Block)block), 1, meta);
        for (int id : OreDictionary.getOreIDs((ItemStack)blockStack)) {
            if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
            blockIsOre = true;
            break;
        }
        if (harvestable && effective && strong) {
            int xp = 1;
            if (blockIsOre) {
                ++xp;
            }
            LevelingLogic.addXP(stack, (EntityPlayer)entity, xp);
            if (block.func_149745_a(IguanaTweaksTConstruct.random) > 1) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LAPIS, 1, tags);
            } else {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.REDSTONE, 1, tags);
            }
            boolean itsHotInHere = false;
            itsHotInHere |= entity.field_70170_p.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151587_i;
            itsHotInHere |= entity.field_70170_p.func_147439_a(x - 1, y, z).func_149688_o() == Material.field_151587_i;
            itsHotInHere |= entity.field_70170_p.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151587_i;
            itsHotInHere |= entity.field_70170_p.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151587_i;
            itsHotInHere |= entity.field_70170_p.func_147439_a(x, y, z + 1).func_149688_o() == Material.field_151587_i;
            if (itsHotInHere |= entity.field_70170_p.func_147439_a(x, y, z - 1).func_149688_o() == Material.field_151587_i) {
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.AUTOSMELT, 10, tags);
            }
        }
        return false;
    }

    public boolean doesCriticalHit(ToolCore tool, NBTTagCompound tags, NBTTagCompound toolTags, ItemStack stack, EntityLivingBase player, Entity entity) {
        if (toolTags.func_74764_b(ModCritical.modCritical.key)) {
            return IguanaTweaksTConstruct.random.nextInt(10) == 0;
        }
        return false;
    }
}

