/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling;

import iguanaman.iguanatweakstconstruct.leveling.IguanaToolLeveling;
import iguanaman.iguanatweakstconstruct.leveling.LevelingTooltips;
import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import iguanaman.iguanatweakstconstruct.override.XPAdjustmentMap;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.reference.Reference;
import iguanaman.iguanatweakstconstruct.replacing.ReplacementLogic;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.items.tools.Cleaver;
import tconstruct.items.tools.Excavator;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Hatchet;
import tconstruct.items.tools.LumberAxe;
import tconstruct.items.tools.Mattock;
import tconstruct.items.tools.Pickaxe;
import tconstruct.items.tools.Scythe;
import tconstruct.items.tools.Shovel;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;

public final class LevelingLogic {
    public static final String TAG_EXP = "ToolEXP";
    public static final String TAG_LEVEL = "ToolLevel";
    public static final String TAG_BOOST_EXP = "HeadEXP";
    public static final String TAG_IS_BOOSTED = "HarvestLevelModified";

    private LevelingLogic() {
    }

    public static int getLevel(NBTTagCompound tags) {
        return tags.func_74762_e(TAG_LEVEL);
    }

    public static int getHarvestLevel(NBTTagCompound tags) {
        return tags.func_74764_b("HarvestLevel") ? tags.func_74762_e("HarvestLevel") : -1;
    }

    public static long getXp(NBTTagCompound tags) {
        return tags.func_74763_f(TAG_EXP);
    }

    public static long getBoostXp(NBTTagCompound tags) {
        return tags.func_74763_f(TAG_BOOST_EXP);
    }

    public static boolean hasLevel(NBTTagCompound tags) {
        return tags.func_74764_b(TAG_LEVEL);
    }

    public static boolean hasXp(NBTTagCompound tags) {
        return tags.func_74764_b(TAG_EXP);
    }

    public static boolean hasBoostXp(NBTTagCompound tags) {
        return tags.func_74764_b(TAG_BOOST_EXP);
    }

    public static boolean isBoosted(NBTTagCompound tags) {
        return tags.func_74767_n(TAG_IS_BOOSTED);
    }

    public static boolean isMaxLevel(NBTTagCompound tags) {
        return LevelingLogic.getLevel(tags) >= Config.maxToolLevel;
    }

    public static boolean canBoostMiningLevel(NBTTagCompound tags) {
        return tags.func_74764_b(TAG_IS_BOOSTED) && !LevelingLogic.isBoosted(tags) && LevelingLogic.getHarvestLevel(tags) < HarvestLevels.max;
    }

    public static void addLevelingTags(NBTTagCompound tag, ToolCore tool) {
        tag.func_74768_a(TAG_LEVEL, 1);
        tag.func_74772_a(TAG_EXP, 0L);
        LevelingLogic.addBoostTags(tag, tool);
    }

    public static void addBoostTags(NBTTagCompound tag, ToolCore tool) {
        int hlvl = tag.func_74762_e("HarvestLevel");
        if (!Config.pickaxeBoostRequired) {
            return;
        }
        if (hlvl == 0 || !(tool instanceof Pickaxe) && !(tool instanceof Hammer)) {
            return;
        }
        tag.func_74772_a(TAG_BOOST_EXP, 0L);
        tag.func_74757_a(TAG_IS_BOOSTED, false);
        tag.func_74768_a("HarvestLevel", hlvl - 1);
    }

    public static void updateXP(ItemStack tool, EntityPlayer player, long toolXP, long boostXP) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!LevelingLogic.hasLevel(tags)) {
            return;
        }
        int level = LevelingLogic.getLevel(tags);
        boolean leveled = false;
        boolean pickLeveled = false;
        if (toolXP >= 0L && LevelingLogic.hasXp(tags) && level > 0 && !LevelingLogic.isMaxLevel(tags) && Config.toolLeveling) {
            tags.func_74772_a(TAG_EXP, toolXP);
            if (toolXP >= (long)LevelingLogic.getRequiredXp(tool, tags)) {
                int cxp = tags.func_74762_e("CheatyXP");
                if (cxp * 2 >= LevelingLogic.getRequiredXp(tool, tags)) {
                    if (player != null && !player.field_70170_p.field_72995_K) {
                        String text = StatCollector.func_74838_a((String)"message.levelup.chicken");
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + text));
                        player.field_70170_p.func_72956_a((Entity)player, Reference.RESOURCE + ":chicken", 0.9f, 1.0f);
                    }
                    tags.func_74778_a("Original", Item.field_150901_e.func_148750_c((Object)tool.func_77973_b()));
                    tool.func_150996_a(IguanaToolLeveling.rubberChicken);
                    tags.func_74772_a(TAG_EXP, 0L);
                    tags.func_74768_a("CheatyXP", 0);
                    if (player != null && player.field_70170_p.field_72995_K) {
                        for (int i = 0; i < 1337; ++i) {
                            player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1));
                        }
                    }
                    return;
                }
                LevelingLogic.levelUpTool(tool, player);
                leveled = true;
            }
        }
        if (Config.levelingPickaxeBoost && LevelingLogic.canBoostMiningLevel(tags)) {
            tags.func_74772_a(TAG_BOOST_EXP, boostXP);
            if (boostXP >= (long)LevelingLogic.getRequiredBoostXp(tool)) {
                LevelingLogic.levelUpMiningLevel(tool, player, leveled);
                pickLeveled = true;
            }
        }
        if ((leveled || pickLeveled) && !player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, Reference.RESOURCE + ":chime", 0.9f, 1.0f);
        }
    }

    public static void addXP(ItemStack tool, EntityPlayer player, long xp) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (tool == null || !tool.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!LevelingLogic.hasLevel(tags) || !LevelingLogic.hasXp(tags)) {
            return;
        }
        Long toolXp = -1L;
        if (LevelingLogic.hasXp(tags)) {
            toolXp = LevelingLogic.getXp(tags) + xp;
        }
        Long boostXp = -1L;
        if (LevelingLogic.hasBoostXp(tags)) {
            boostXp = LevelingLogic.getBoostXp(tags) + xp;
        }
        LevelingLogic.updateXP(tool, player, toolXp, boostXp);
    }

    public static int getRequiredBoostXp(ItemStack tool) {
        return LevelingLogic.getRequiredXp(tool, null, true);
    }

    public static int getRequiredXp(ItemStack tool, NBTTagCompound tags) {
        return LevelingLogic.getRequiredXp(tool, tags, false);
    }

    protected static int getRequiredXp(ItemStack tool, NBTTagCompound tags, boolean miningBoost) {
        if (tags == null) {
            tags = tool.func_77978_p().func_74775_l("InfiTool");
        }
        float base = 100.0f;
        boolean bow = false;
        boolean weapon = false;
        boolean harvest = false;
        if (tool.func_77973_b() instanceof ToolCore) {
            for (String trait : ((ToolCore)tool.func_77973_b()).getTraits()) {
                if ("bow".equals(trait)) {
                    bow = true;
                }
                if ("weapon".equals(trait)) {
                    weapon = true;
                }
                if (!"harvest".equals(trait)) continue;
                harvest = true;
            }
        }
        if (bow) {
            base = 200.0f;
            base *= tags.func_74760_g("FlightSpeed") * 0.7f;
            base *= (float)Config.xpRequiredWeaponsPercentage / 100.0f;
        } else if (weapon && !(tool.func_77973_b() instanceof Hammer)) {
            base = 140.0f;
            base *= ((ToolCore)tool.func_77973_b()).getDamageModifier();
            base *= (float)Math.max(1, tags.func_74762_e("Attack")) * 1.2f;
            if (tool.func_77973_b() instanceof Scythe) {
                base *= 1.5f;
            }
            base *= (float)Config.xpRequiredWeaponsPercentage / 100.0f;
        } else {
            if (tags.func_74764_b("HarvestLevel") && LevelingLogic.getHarvestLevel(tags) < 1) {
                base -= 20.0f;
            }
            if (tags.func_74764_b("HarvestLevel") && LevelingLogic.getHarvestLevel(tags) < 2) {
                base -= 15.0f;
            }
            int baseMiningSpeed = TConstructRegistry.getMaterial((int)tags.func_74762_e("Head")).toolSpeed();
            int miningSpeed = tags.func_74762_e("MiningSpeed");
            float divider = 2.4f;
            if (tags.func_74764_b("MiningSpeed2")) {
                baseMiningSpeed += TConstructRegistry.getMaterial((int)tags.func_74762_e("Accessory")).toolSpeed();
                miningSpeed += tags.func_74762_e("MiningSpeed2");
                divider += 1.0f;
            }
            if (tags.func_74764_b("MiningSpeedHandle")) {
                baseMiningSpeed += TConstructRegistry.getMaterial((int)tags.func_74762_e("Handle")).toolSpeed();
                miningSpeed += tags.func_74762_e("MiningSpeedHandle");
                divider += 1.0f;
            }
            if (tags.func_74764_b("MiningSpeedExtra")) {
                baseMiningSpeed += TConstructRegistry.getMaterial((int)tags.func_74762_e("Extra")).toolSpeed();
                miningSpeed += tags.func_74762_e("MiningSpeedExtra");
                divider += 1.0f;
            }
            base += ((float)baseMiningSpeed + (float)(miningSpeed - baseMiningSpeed) / 5.0f) / divider;
            if (tool.func_77973_b() instanceof Hammer) {
                base *= 5.1f;
            }
            if (tool.func_77973_b() instanceof Excavator) {
                base *= 6.2f;
            }
            if (tool.func_77973_b() instanceof LumberAxe) {
                base *= 1.38f;
            }
            if (tool.func_77973_b() instanceof Shovel) {
                base *= 1.2f;
            }
            if (tool.func_77973_b() instanceof Hatchet) {
                base *= 0.66f;
            }
            base *= (float)Config.xpRequiredToolsPercentage / 100.0f;
        }
        if (miningBoost) {
            int harvestLevelCopper = HarvestLevels._2_copper;
            int harvestLevel = LevelingLogic.getHarvestLevel(tags);
            if (harvestLevel >= harvestLevelCopper) {
                base = (float)((double)base * Math.pow(Config.xpPerBoostLevelMultiplier, harvestLevel - harvestLevelCopper));
            }
            if (harvestLevel == 0) {
                base /= Config.xpPerBoostLevelMultiplier * Config.xpPerBoostLevelMultiplier;
            }
            base *= (float)Config.levelingPickaxeBoostXpPercentage / 100.0f;
        } else {
            int level = tags.func_74762_e(TAG_LEVEL);
            if (level >= 1) {
                base = (float)((double)base * Math.pow(Config.xpPerLevelMultiplier, level - 1));
            }
            if (tags.func_74764_b("HarvestLevel") && LevelingLogic.getHarvestLevel(tags) == 0) {
                base /= Config.xpPerLevelMultiplier * Config.xpPerLevelMultiplier;
            }
            float xpMultiplier = LevelingLogic.getXPMultiplier(tool, tags);
            base *= xpMultiplier;
        }
        return Math.round(base);
    }

    private static float getXPMultiplier(ItemStack tool, NBTTagCompound tags) {
        String matName;
        boolean nonHeadsCount = !Config.onlyHeadsChangeXPRequirement;
        ToolCore core = (ToolCore)tool.func_77973_b();
        boolean extraIsHead = core instanceof Hammer;
        boolean accessoryIsHead = extraIsHead || core instanceof Excavator || core instanceof Cleaver || core instanceof LumberAxe || core instanceof Mattock;
        double numberOfParts = 0.0;
        double xpModSoFar = 1.0;
        if (ReplacementLogic.getPart(core, ReplacementLogic.PartTypes.HEAD) != null) {
            numberOfParts += 1.0;
            int toolMaterialHead = ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.HEAD);
            matName = TConstructRegistry.getMaterial((int)toolMaterialHead).name();
            xpModSoFar *= (double)XPAdjustmentMap.get(matName);
        }
        if (ReplacementLogic.getPart(core, ReplacementLogic.PartTypes.HANDLE) != null && nonHeadsCount) {
            numberOfParts += 1.0;
            int toolMaterialHandle = ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.HANDLE);
            matName = TConstructRegistry.getMaterial((int)toolMaterialHandle).name();
            xpModSoFar *= (double)XPAdjustmentMap.get(matName);
        }
        if (ReplacementLogic.getPart(core, ReplacementLogic.PartTypes.ACCESSORY) != null && (accessoryIsHead || nonHeadsCount)) {
            numberOfParts += 1.0;
            int toolMaterialAccessory = ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.ACCESSORY);
            matName = TConstructRegistry.getMaterial((int)toolMaterialAccessory).name();
            xpModSoFar *= (double)XPAdjustmentMap.get(matName);
        }
        if (ReplacementLogic.getPart(core, ReplacementLogic.PartTypes.EXTRA) != null && (extraIsHead || nonHeadsCount)) {
            numberOfParts += 1.0;
            int toolMaterialExtra = ReplacementLogic.getToolPartMaterial(tags, ReplacementLogic.PartTypes.EXTRA);
            matName = TConstructRegistry.getMaterial((int)toolMaterialExtra).name();
            xpModSoFar *= (double)XPAdjustmentMap.get(matName);
        }
        return (float)Math.pow(xpModSoFar, 1.0 / numberOfParts);
    }

    public static void levelUpTool(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        World world = player.field_70170_p;
        int level = LevelingLogic.getLevel(tags);
        ++level;
        if (!world.field_72995_K) {
            if (StatCollector.func_94522_b((String)("message.levelup." + level))) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + StatCollector.func_74837_a((String)("message.levelup." + level), (Object[])new Object[]{stack.func_82833_r() + EnumChatFormatting.DARK_AQUA})));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_AQUA + StatCollector.func_74837_a((String)"message.levelup.generic", (Object[])new Object[]{stack.func_82833_r() + EnumChatFormatting.DARK_AQUA, LevelingTooltips.getLevelString(level)})));
            }
        }
        if (Config.toolLevelingRandomBonuses) {
            int bonusesToAdd = 0;
            for (int lvl : Config.randomBonusesAtlevels) {
                if (level != lvl) continue;
                ++bonusesToAdd;
            }
            while (bonusesToAdd-- > 0) {
                RandomBonuses.tryModifying(player, stack);
            }
        }
        tags.func_74768_a(TAG_LEVEL, level);
        tags.func_74772_a(TAG_EXP, 0L);
        int currentModifiers = tags.func_74762_e("Modifiers");
        int modifiersToAdd = 0;
        for (int lvl : Config.toolModifiersAtLevels) {
            if (level != lvl) continue;
            ++modifiersToAdd;
        }
        if (modifiersToAdd > 0) {
            tags.func_74768_a("Modifiers", currentModifiers += modifiersToAdd);
            if (!world.field_72995_K) {
                if (world.field_73012_v.nextInt(10) < modifiersToAdd) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(LevelingTooltips.getInfoString(StatCollector.func_74838_a((String)"message.levelup.newmodifier.2"), EnumChatFormatting.DARK_AQUA, String.format("+%d %s", modifiersToAdd, StatCollector.func_74838_a((String)"message.levelup.modifier")), EnumChatFormatting.GOLD)));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(LevelingTooltips.getInfoString(StatCollector.func_74838_a((String)"message.levelup.newmodifier.1"), EnumChatFormatting.DARK_AQUA, String.format("+%d %s", modifiersToAdd, StatCollector.func_74838_a((String)"message.levelup.modifier")), EnumChatFormatting.GOLD)));
                }
            }
        }
    }

    public static void levelUpMiningLevel(ItemStack stack, EntityPlayer player, boolean leveled) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (LevelingLogic.isBoosted(tags)) {
            return;
        }
        if (LevelingLogic.hasBoostXp(tags)) {
            tags.func_74772_a(TAG_BOOST_EXP, 0L);
        }
        if (player != null && !player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(LevelingTooltips.getInfoString(StatCollector.func_74837_a((String)"message.levelup.miningboost", (Object[])new Object[]{stack.func_82833_r()}), EnumChatFormatting.DARK_AQUA, String.format("+%d %s", 1, StatCollector.func_74838_a((String)"message.levelup.mininglevel")), EnumChatFormatting.GOLD)));
        }
        tags.func_74757_a(TAG_IS_BOOSTED, true);
        tags.func_74768_a("HarvestLevel", tags.func_74762_e("HarvestLevel") + 1);
    }
}

