/*
 * Decompiled with CFR 0.152.
 */
package detrav.utils;

import gregtech.GTMod;
import gtPlusPlus.core.block.base.BlockBaseOre;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.core.material.MaterialsOres;
import gtPlusPlus.core.material.nuclear.MaterialsFluorides;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.block.Block;

public class GTppHelper {
    private static boolean initialized;
    private static final HashMap<Short, Material> decodeoresGTpp;
    private static final HashMap<Material, Short> encodeoresGTpp;

    private static void generate_OreIDs() {
        int n;
        Field[] fields = MaterialsOres.class.getFields();
        for (n = 0; n < fields.length; n = (int)((short)(n + 1))) {
            try {
                Object o = fields[n].get(null);
                if (!(o instanceof Material)) continue;
                Material m = (Material)o;
                Short i = (short)(n + 1);
                decodeoresGTpp.put(i, m);
                encodeoresGTpp.put(m, i);
                continue;
            }
            catch (Exception e) {
                GTMod.GT_FML_LOGGER.error("Exception caught when trying to generate GT++ ore ids for detrav ore scanner", (Throwable)e);
            }
        }
        n = (short)(n + 1);
        decodeoresGTpp.put((short)(n + 1), MaterialsFluorides.FLUORITE);
        encodeoresGTpp.put(MaterialsFluorides.FLUORITE, (short)(n + 1));
        n = (short)(n + 1);
        decodeoresGTpp.put((short)(n + 1), MaterialMisc.RARE_EARTH_LOW);
        encodeoresGTpp.put(MaterialMisc.RARE_EARTH_LOW, (short)(n + 1));
        n = (short)(n + 1);
        decodeoresGTpp.put((short)(n + 1), MaterialMisc.RARE_EARTH_MID);
        encodeoresGTpp.put(MaterialMisc.RARE_EARTH_MID, (short)(n + 1));
        n = (short)(n + 1);
        decodeoresGTpp.put((short)(n + 1), MaterialMisc.RARE_EARTH_HIGH);
        encodeoresGTpp.put(MaterialMisc.RARE_EARTH_HIGH, (short)(n + 1));
        n = (short)(n + 1);
        decodeoresGTpp.put((short)(n + 1), MaterialsAlloy.KOBOLDITE);
        encodeoresGTpp.put(MaterialsAlloy.KOBOLDITE, (short)(n + 1));
        n = (short)(n + 1);
        decodeoresGTpp.put((short)(n + 1), MaterialsElements.STANDALONE.RUNITE);
        encodeoresGTpp.put(MaterialsElements.STANDALONE.RUNITE, (short)(n + 1));
        n = (short)(n + 1);
        decodeoresGTpp.put((short)(n + 1), MaterialsElements.STANDALONE.GRANITE);
        encodeoresGTpp.put(MaterialsElements.STANDALONE.GRANITE, (short)(n + 1));
    }

    public static short getMetaFromBlock(Block block) {
        if (!initialized) {
            GTppHelper.generate_OreIDs();
            initialized = true;
        }
        return (short)(encodeoresGTpp.get(((BlockBaseOre)block).getMaterialEx()) + 7000);
    }

    public static Material getMatFromMeta(int meta) {
        if (!initialized) {
            GTppHelper.generate_OreIDs();
            initialized = true;
        }
        return decodeoresGTpp.get((short)(meta - 7000));
    }

    public static boolean isGTppBlock(Block block) {
        return block instanceof BlockBaseOre;
    }

    public static String getGTppVeinName(Block block) {
        return block.func_149732_F();
    }

    static {
        decodeoresGTpp = new HashMap();
        encodeoresGTpp = new HashMap();
    }
}

