/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import com.google.common.collect.ImmutableList;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.util.ExoticEnergyInputHelper;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.common.tileentities.machines.multi.purification.MTEHatchLensHousing;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSteamBusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSteamBusOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum HatchElement implements IHatchElement<MTEMultiBlockBase>
{
    Muffler("GT5U.MBTT.MufflerHatch", MTEMultiBlockBase::addMufflerToMachineList, new Class[]{MTEHatchMuffler.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mMufflerHatches.size();
        }
    }
    ,
    Maintenance("GT5U.MBTT.MaintenanceHatch", MTEMultiBlockBase::addMaintenanceToMachineList, new Class[]{MTEHatchMaintenance.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mMaintenanceHatches.size();
        }
    }
    ,
    InputHatch("GT5U.MBTT.InputHatch", MTEMultiBlockBase::addInputHatchToMachineList, new Class[]{MTEHatchInput.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mInputHatches.size();
        }
    }
    ,
    InputBus("GT5U.MBTT.InputBus", MTEMultiBlockBase::addInputBusToMachineList, new Class[]{MTEHatchInputBus.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mInputBusses.size();
        }

        @Override
        public List<Class<? extends IMetaTileEntity>> mteBlacklist() {
            return ImmutableList.of(MTEHatchLensHousing.class, MTEHatchSteamBusInput.class);
        }
    }
    ,
    OutputHatch("GT5U.MBTT.OutputHatch", MTEMultiBlockBase::addOutputHatchToMachineList, new Class[]{MTEHatchOutput.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mOutputHatches.size();
        }
    }
    ,
    OutputBus("GT5U.MBTT.OutputBus", MTEMultiBlockBase::addOutputBusToMachineList, new Class[]{MTEHatchOutputBus.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mOutputBusses.size();
        }

        @Override
        public List<Class<? extends IMetaTileEntity>> mteBlacklist() {
            return ImmutableList.of(MTEHatchSteamBusOutput.class);
        }
    }
    ,
    Energy("GT5U.MBTT.EnergyHatch", MTEMultiBlockBase::addEnergyInputToMachineList, new Class[]{MTEHatchEnergy.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mEnergyHatches.size();
        }
    }
    ,
    Dynamo("GT5U.MBTT.DynamoHatch", MTEMultiBlockBase::addDynamoToMachineList, new Class[]{MTEHatchDynamo.class}){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.mDynamoHatches.size();
        }
    }
    ,
    ExoticEnergy("GT5U.MBTT.MultiampEnergyHatch", MTEMultiBlockBase::addExoticEnergyInputToMachineList, new Class[0]){

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return ExoticEnergyInputHelper.getAllClasses();
        }

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.getExoticEnergyHatches().size();
        }
    }
    ,
    MultiAmpEnergy("GT5U.MBTT.MultiampEnergyHatch", MTEMultiBlockBase::addMultiAmpEnergyInputToMachineList, new Class[0]){

        @Override
        public long count(MTEMultiBlockBase t) {
            return t.getExoticEnergyHatches().size();
        }
    };

    private final String name;
    private final List<Class<? extends IMetaTileEntity>> mteClasses;
    private final IGTHatchAdder<MTEMultiBlockBase> adder;

    @SafeVarargs
    private HatchElement(String name, IGTHatchAdder<MTEMultiBlockBase> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
        this.name = name;
        this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
        this.adder = adder;
    }

    @Override
    public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
        return this.mteClasses;
    }

    @Override
    public String getDisplayName() {
        return GTUtility.translate(this.name, new Object[0]);
    }

    @Override
    public IGTHatchAdder<? super MTEMultiBlockBase> adder() {
        return this.adder;
    }
}

