/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TCAspects;
import gregtech.api.enums.TextureSet;
import gregtech.api.objects.MaterialStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MaterialBuilder {
    public static final int DIESEL = 0;
    public static final int GAS = 1;
    public static final int THERMAL = 2;
    public static final int SEMIFLUID = 3;
    public static final int PLASMA = 4;
    public static final int MAGIC = 5;
    private final int metaItemSubID;
    private final TextureSet iconSet;
    private float toolSpeed = 1.0f;
    private int durability = 0;
    private int toolQuality = 0;
    private int types = 0;
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int a = 0;
    private String name;
    private final String defaultLocalName;
    private int fuelType = 0;
    private int fuelPower = 0;
    private int meltingPoint = 0;
    private int blastFurnaceTemp = 0;
    private boolean blastFurnaceRequired = false;
    private boolean transparent = false;
    private int oreValue = 1;
    private int densityMultiplier = 1;
    private int densityDivider = 1;
    private Dyes color = Dyes._NULL;
    private int extraData = 0;
    private List<MaterialStack> materialList = new ArrayList<MaterialStack>();
    private List<TCAspects.TC_AspectStack> aspects = new ArrayList<TCAspects.TC_AspectStack>();
    private boolean hasCorrespondingFluid = false;
    private boolean hasCorrespondingGas = false;
    private boolean canBeCracked = false;
    private int liquidTemperature = 300;
    private int gasTemperature = 300;

    public MaterialBuilder(int metaItemSubID, TextureSet iconSet, String defaultLocalName) {
        this.metaItemSubID = metaItemSubID;
        this.iconSet = iconSet;
        this.name = defaultLocalName.replace(" ", "").replace("-", "");
        this.defaultLocalName = defaultLocalName;
    }

    public Materials constructMaterial() {
        return new Materials(this.metaItemSubID, this.iconSet, this.toolSpeed, this.durability, this.toolQuality, this.types, this.r, this.g, this.b, this.a, this.name, this.defaultLocalName, this.fuelType, this.fuelPower, this.meltingPoint, this.blastFurnaceTemp, this.blastFurnaceRequired, this.transparent, this.oreValue, this.densityMultiplier, this.densityDivider, this.color, this.extraData, this.materialList, this.aspects).setHasCorrespondingFluid(this.hasCorrespondingFluid).setHasCorrespondingGas(this.hasCorrespondingGas).setCanBeCracked(this.canBeCracked);
    }

    public MaterialBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public MaterialBuilder setTypes(int types) {
        this.types = types;
        return this;
    }

    public MaterialBuilder addDustItems() {
        this.types |= 1;
        return this;
    }

    public MaterialBuilder addMetalItems() {
        this.types |= 2;
        return this;
    }

    public MaterialBuilder addGemItems() {
        this.types |= 4;
        return this;
    }

    public MaterialBuilder addOreItems() {
        this.types |= 8;
        return this;
    }

    public MaterialBuilder addCell() {
        this.types |= 0x10;
        return this;
    }

    public MaterialBuilder addPlasma() {
        this.types |= 0x20;
        return this;
    }

    public MaterialBuilder addToolHeadItems() {
        this.types |= 0x40;
        return this;
    }

    public MaterialBuilder addGearItems() {
        this.types |= 0x80;
        return this;
    }

    public MaterialBuilder addFluid() {
        this.hasCorrespondingFluid = true;
        return this;
    }

    public MaterialBuilder addGas() {
        this.hasCorrespondingGas = true;
        return this;
    }

    public MaterialBuilder setRGBA(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public MaterialBuilder setRGB(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    public MaterialBuilder setRGB(int rgb) {
        this.r = rgb >> 16 & 0xFF;
        this.g = rgb >> 8 & 0xFF;
        this.b = rgb & 0xFF;
        return this;
    }

    public MaterialBuilder setTransparent(boolean transparent) {
        this.transparent = transparent;
        return this;
    }

    public MaterialBuilder setColor(Dyes color) {
        this.color = color;
        return this;
    }

    public MaterialBuilder setToolSpeed(float toolSpeed) {
        this.toolSpeed = toolSpeed;
        return this;
    }

    public MaterialBuilder setDurability(int durability) {
        this.durability = durability;
        return this;
    }

    public MaterialBuilder setToolQuality(int toolQuality) {
        this.toolQuality = toolQuality;
        return this;
    }

    public MaterialBuilder setFuelType(int fuelType) {
        this.fuelType = fuelType;
        return this;
    }

    public MaterialBuilder setFuelPower(int fuelPower) {
        this.fuelPower = fuelPower;
        return this;
    }

    public MaterialBuilder setMeltingPoint(int meltingPoint) {
        this.meltingPoint = meltingPoint;
        return this;
    }

    public MaterialBuilder setBlastFurnaceTemp(int blastFurnaceTemp) {
        this.blastFurnaceTemp = blastFurnaceTemp;
        return this;
    }

    public MaterialBuilder setBlastFurnaceRequired(boolean blastFurnaceRequired) {
        this.blastFurnaceRequired = blastFurnaceRequired;
        return this;
    }

    public MaterialBuilder setOreValue(int oreValue) {
        this.oreValue = oreValue;
        return this;
    }

    public MaterialBuilder setDensityMultiplier(int densityMultiplier) {
        this.densityMultiplier = densityMultiplier;
        return this;
    }

    public MaterialBuilder setDensityDivider(int densityDivider) {
        this.densityDivider = densityDivider;
        return this;
    }

    public MaterialBuilder setExtraData(int extraData) {
        this.extraData = extraData;
        return this;
    }

    public MaterialBuilder addElectrolyzerRecipe() {
        this.extraData |= 1;
        return this;
    }

    public MaterialBuilder addCentrifugeRecipe() {
        this.extraData |= 2;
        return this;
    }

    public MaterialBuilder setMaterialList(List<MaterialStack> materialList) {
        this.materialList = materialList;
        return this;
    }

    public MaterialBuilder setMaterialList(MaterialStack ... materials) {
        this.materialList = Arrays.asList(materials);
        return this;
    }

    public MaterialBuilder setAspects(List<TCAspects.TC_AspectStack> aspects) {
        this.aspects = aspects;
        return this;
    }

    public int getLiquidTemperature() {
        return this.liquidTemperature;
    }

    public MaterialBuilder setLiquidTemperature(int liquidTemperature) {
        this.liquidTemperature = liquidTemperature;
        return this;
    }

    public int getGasTemperature() {
        return this.gasTemperature;
    }

    public MaterialBuilder setGasTemperature(int gasTemperature) {
        this.gasTemperature = gasTemperature;
        return this;
    }

    public boolean canBeCracked() {
        return this.canBeCracked;
    }

    public MaterialBuilder setCanBeCracked(boolean canBeCracked) {
        this.canBeCracked = canBeCracked;
        return this;
    }
}

