/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregtechWailaProvider;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.net.GTPacketRequestCoverData;
import gregtech.api.net.GTPacketSendCoverData;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.common.covers.Cover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public abstract class CoverableTileEntity
extends BaseTileEntity
implements ICoverable,
IGregtechWailaProvider {
    @Deprecated
    public static final String[] COVER_DATA_NBT_KEYS = (String[])Arrays.stream(ForgeDirection.VALID_DIRECTIONS).mapToInt(Enum::ordinal).mapToObj(i -> "mCoverData" + i).toArray(String[]::new);
    private static final String NBT_COVER_SIDE = "s";
    private static final String[] COVER_DIRECTION_NAMES = new String[]{"GT5U.interface.coverTabs.down", "GT5U.interface.coverTabs.up", "GT5U.interface.coverTabs.north", "GT5U.interface.coverTabs.south", "GT5U.interface.coverTabs.west", "GT5U.interface.coverTabs.east"};
    protected final Cover[] covers = new Cover[]{CoverRegistry.NO_COVER, CoverRegistry.NO_COVER, CoverRegistry.NO_COVER, CoverRegistry.NO_COVER, CoverRegistry.NO_COVER, CoverRegistry.NO_COVER};
    private byte validCoversMask;
    protected final byte[] mSidedRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    protected boolean mRedstone = false;
    protected byte mStrongRedstone = 0;
    protected short mID = 0;
    public long mTickTimer = 0L;
    protected static final int COVER_WINDOW_ID_START = 1;

    protected void writeCoverNBT(NBTTagCompound aNBT, boolean isDrop) {
        NBTTagList tList = this.buildCoversNbtTag();
        if (tList.func_74745_c() > 0) {
            aNBT.func_74782_a("gt.covers", (NBTBase)tList);
        }
        if (this.mStrongRedstone > 0) {
            aNBT.func_74774_a("mStrongRedstone", this.mStrongRedstone);
        }
        if (!isDrop) {
            aNBT.func_74773_a("mRedstoneSided", this.mSidedRedstone);
            aNBT.func_74757_a("mRedstone", this.mRedstone);
        }
    }

    @NotNull
    private NBTTagList buildCoversNbtTag() {
        NBTTagList covers = new NBTTagList();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Cover cover = this.getCoverAtSide(side);
            if (!cover.isValid()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a(NBT_COVER_SIDE, (byte)side.ordinal());
            CoverRegistry.writeCoverToNbt(cover, nbt);
            covers.func_74742_a((NBTBase)nbt);
        }
        return covers;
    }

    protected void readCoverNBT(NBTTagCompound aNBT) {
        this.mRedstone = aNBT.func_74767_n("mRedstone");
        this.mStrongRedstone = aNBT.func_74771_c("mStrongRedstone");
        if (aNBT.func_74764_b("mRedstoneSided")) {
            byte[] readArray = aNBT.func_74770_j("mRedstoneSided");
            System.arraycopy(readArray, 0, this.mSidedRedstone, 0, Math.min(this.mSidedRedstone.length, readArray.length));
        }
        this.applyCovers(CoverableTileEntity.readCoversNBT(aNBT, this));
    }

    private void applyCovers(@NotNull List<Cover> storedCovers) {
        for (Cover cover : storedCovers) {
            this.applyCover(cover, cover.getSide());
            if (!cover.isDataNeededOnClient()) continue;
            this.issueCoverUpdate(cover.getSide());
        }
    }

    @NotNull
    public static List<Cover> readCoversNBT(NBTTagCompound aNBT, CoverableTileEntity coverableTileEntity) {
        if (aNBT != null && aNBT.func_74764_b("gt.covers")) {
            NBTTagList tList = aNBT.func_150295_c("gt.covers", 10);
            ArrayList<Cover> storedCovers = new ArrayList<Cover>();
            for (int i = 0; i < tList.func_74745_c(); i = (int)((byte)(i + 1))) {
                NBTTagCompound tNBT = tList.func_150305_b(i);
                ForgeDirection side = ForgeDirection.getOrientation((int)tNBT.func_74771_c(NBT_COVER_SIDE));
                storedCovers.add(CoverRegistry.buildCoverFromNbt(tNBT, side, coverableTileEntity));
            }
            return storedCovers;
        }
        return Collections.emptyList();
    }

    public abstract boolean isStillValid();

    protected boolean doCoverThings() {
        byte validCoversMask = this.validCoversMask;
        if (validCoversMask == 0) {
            return true;
        }
        for (int i = Integer.numberOfTrailingZeros(validCoversMask); i < 6; ++i) {
            if ((validCoversMask >>> i & 1) == 0 || this.tickCoverAtSide(ForgeDirection.VALID_DIRECTIONS[i])) continue;
            return false;
        }
        return true;
    }

    protected void onCoverUnload() {
        byte validCoversMask = this.validCoversMask;
        if (validCoversMask == 0) {
            return;
        }
        for (int i = Integer.numberOfTrailingZeros(validCoversMask); i < 6; ++i) {
            if ((validCoversMask >>> i & 1) == 0) continue;
            this.onCoverUnloadAtSide(ForgeDirection.VALID_DIRECTIONS[i]);
        }
    }

    public void onCoverUnloadAtSide(ForgeDirection side) {
        Cover cover = this.getCoverAtSide(side);
        if (!cover.isValid()) {
            return;
        }
        cover.onCoverUnload();
    }

    private boolean tickCoverAtSide(ForgeDirection side) {
        Cover cover = this.getCoverAtSide(side);
        if (!cover.isValid()) {
            return true;
        }
        int aTickTimer = MinecraftServer.func_71276_C().func_71259_af();
        int tCoverTickRate = cover.getTickRate();
        if (tCoverTickRate > 0 && aTickTimer % tCoverTickRate == 0) {
            byte tRedstone = cover.isRedstoneSensitive(aTickTimer) ? this.getInputRedstoneSignal(side) : (byte)0;
            cover.doCoverThings(tRedstone, aTickTimer);
            return this.isStillValid();
        }
        return true;
    }

    public abstract boolean allowCoverOnSide(ForgeDirection var1, ItemStack var2);

    protected void checkDropCover() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Cover cover = this.getCoverAtSide(side);
            if (!cover.isValid() || this.allowCoverOnSide(side, cover.asItemStack())) continue;
            this.dropCover(side, side);
        }
    }

    @Override
    public void issueCoverUpdate(ForgeDirection side) {
        Cover cover = this.getCoverAtSide(side);
        if (this.field_145850_b == null || this.isServerSide() && cover.isDataNeededOnClient()) {
            cover.setNeedsUpdate(true);
        }
    }

    public final ITexture getCoverTexture(ForgeDirection side) {
        Cover cover = this.getCoverAtSide(side);
        if (!cover.isValid()) {
            return null;
        }
        if (GTMod.GT.isClientSide() && GTMod.clientProxy().shouldHideThings()) {
            return Textures.BlockIcons.HIDDEN_TEXTURE[0];
        }
        ITexture coverTexture = this instanceof BaseMetaPipeEntity ? cover.getSpecialFaceTexture() : cover.getOverlayTexture();
        return coverTexture != null ? coverTexture : CoverRegistry.getCoverTexture(cover.asItemStack());
    }

    protected void requestCoverDataIfNeeded() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Cover cover = this.getCoverAtSide(side);
            if (!cover.isDataNeededOnClient()) continue;
            GTValues.NW.sendToServer(new GTPacketRequestCoverData(cover, this));
        }
    }

    @Override
    public void attachCover(@NotNull Cover cover) {
        ForgeDirection side = cover.getSide();
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        Cover oldCover = this.getCoverAtSide(side);
        int newCoverId = cover.getCoverID();
        if (oldCover.getCoverID() != newCoverId) {
            if (!cover.isValid() && this.isClientSide()) {
                oldCover.onCoverRemoval();
            }
            this.synchronizeCover(cover, side);
        }
    }

    private void synchronizeCover(@NotNull Cover cover, ForgeDirection side) {
        this.applyCover(cover, side);
        this.issueCoverUpdate(side);
        this.issueBlockUpdate();
    }

    @Override
    public ItemStack getCoverItemAtSide(ForgeDirection side) {
        return this.getCoverAtSide(side).asItemStack();
    }

    private void applyCover(@NotNull Cover cover, ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            this.covers[side.ordinal()] = cover;
            this.validCoversMask = (byte)(this.validCoversMask & (byte)(~side.flag));
            if (cover.isValid()) {
                this.validCoversMask = (byte)(this.validCoversMask | side.flag);
            }
        }
    }

    @Override
    public boolean hasCoverAtSide(ForgeDirection side) {
        return this.getCoverAtSide(side).isValid();
    }

    @Override
    @NotNull
    public final Cover getCoverAtSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            return this.covers[side.ordinal()];
        }
        return CoverRegistry.NO_COVER;
    }

    @Override
    public ItemStack detachCover(ForgeDirection side) {
        Cover cover = this.getCoverAtSide(side);
        if (!cover.isValid()) {
            return null;
        }
        cover.onCoverRemoval();
        this.synchronizeCover(CoverRegistry.NO_COVER, side);
        this.updateOutputRedstoneSignal(side);
        return GTOreDictUnificator.get(true, cover.asItemStack());
    }

    @Override
    public void dropCover(ForgeDirection side, ForgeDirection droppedSide) {
        ItemStack droppedCover = this.detachCover(side);
        if (droppedCover != null) {
            EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(droppedSide, 1) + 0.5, (double)this.getOffsetY(droppedSide, 1) + 0.5, (double)this.getOffsetZ(droppedSide, 1) + 0.5, droppedCover);
            tEntity.field_70159_w = 0.0;
            tEntity.field_70181_x = 0.0;
            tEntity.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)tEntity);
        }
    }

    protected void onBaseTEDestroyed() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Cover cover = this.getCoverAtSide(side);
            if (!cover.isValid()) continue;
            cover.onBaseTEDestroyed();
        }
    }

    protected void setRedstoneOutput(int packedRedstoneValue) {
        this.mSidedRedstone[0] = (byte)((packedRedstoneValue & 1) == 1 ? 15 : 0);
        this.mSidedRedstone[1] = (byte)((packedRedstoneValue & 2) == 2 ? 15 : 0);
        this.mSidedRedstone[2] = (byte)((packedRedstoneValue & 4) == 4 ? 15 : 0);
        this.mSidedRedstone[3] = (byte)((packedRedstoneValue & 8) == 8 ? 15 : 0);
        this.mSidedRedstone[4] = (byte)((packedRedstoneValue & 0x10) == 16 ? 15 : 0);
        this.mSidedRedstone[5] = (byte)((packedRedstoneValue & 0x20) == 32 ? 15 : 0);
    }

    public byte getSidedRedstoneMask() {
        byte redstone = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.mSidedRedstone[i] <= 0) continue;
            redstone = (byte)(redstone | (byte)(1 << i));
        }
        return redstone;
    }

    @Override
    public void setOutputRedstoneSignal(ForgeDirection side, byte strength) {
        byte cappedStrength = (byte)Math.min(Math.max(0, strength), 15);
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        int ordinalSide = side.ordinal();
        if (this.mSidedRedstone[ordinalSide] != cappedStrength || (this.mStrongRedstone & 1 << ordinalSide) > 0) {
            this.mSidedRedstone[ordinalSide] = cappedStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setStrongOutputRedstoneSignal(ForgeDirection side, byte strength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | (byte)side.flag);
        this.setOutputRedstoneSignal(side, strength);
    }

    @Override
    public void setRedstoneOutputStrength(ForgeDirection side, boolean isStrong) {
        this.mStrongRedstone = isStrong ? (byte)(this.mStrongRedstone | (byte)side.flag) : (byte)(this.mStrongRedstone & ~((byte)side.flag));
        this.setOutputRedstoneSignal(side, this.mSidedRedstone[side.ordinal()]);
    }

    @Override
    public boolean getRedstoneOutputStrength(ForgeDirection side) {
        return (this.mStrongRedstone & side.flag) != 0;
    }

    @Override
    public void setInternalOutputRedstoneSignal(ForgeDirection side, byte aStrength) {
        if (!this.getCoverAtSide(side).manipulatesSidedRedstoneOutput()) {
            this.setOutputRedstoneSignal(side, aStrength);
        }
    }

    @Override
    public boolean getRedstone() {
        return Arrays.stream(ForgeDirection.VALID_DIRECTIONS).anyMatch(this::getRedstone);
    }

    @Override
    public boolean getRedstone(ForgeDirection side) {
        return this.getInternalInputRedstoneSignal(side) > 0;
    }

    @Override
    public byte getStrongestRedstone() {
        return Arrays.stream(ForgeDirection.VALID_DIRECTIONS).map(this::getInternalInputRedstoneSignal).max(Comparator.comparing(Byte::valueOf)).orElse((byte)0);
    }

    @Override
    public byte getStrongOutputRedstoneSignal(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        return side != ForgeDirection.UNKNOWN && (this.mStrongRedstone & 1 << ordinalSide) != 0 ? (byte)(this.mSidedRedstone[ordinalSide] & 0xF) : (byte)0;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    @Override
    public byte getInternalInputRedstoneSignal(ForgeDirection side) {
        return (byte)(this.getCoverAtSide(side).getRedstoneInput(this.getInputRedstoneSignal(side)) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(ForgeDirection side) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(side, 1), (int)this.getOffsetY(side, 1), this.getOffsetZ(side, 1), side.ordinal()) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(ForgeDirection side) {
        return this.getCoverAtSide(side).manipulatesSidedRedstoneOutput() ? this.mSidedRedstone[side.ordinal()] : this.getGeneralRS(side);
    }

    protected void updateOutputRedstoneSignal(ForgeDirection side) {
        this.setOutputRedstoneSignal(side, (byte)0);
    }

    @Override
    public void updateAttachedCover(int coverId, ForgeDirection side, NBTTagCompound nbt) {
        Cover cover = this.getCoverAtSide(side);
        if (!cover.isValid() || cover.getCoverID() != coverId) {
            return;
        }
        cover.readFromNbt(nbt);
    }

    @Override
    public void updateAttachedCover(ByteArrayDataInput data) {
        int coverId = data.readInt();
        ForgeDirection side = ForgeDirection.getOrientation((int)data.readByte());
        Cover cover = this.getCoverAtSide(side);
        if (!cover.isValid() || cover.getCoverID() != coverId) {
            return;
        }
        cover.readFromPacket(data);
    }

    protected void sendCoverDataIfNeeded() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Cover cover = this.getCoverAtSide(side);
            if (!cover.needsUpdate()) continue;
            GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GTPacketSendCoverData(cover, this, side), this.field_145851_c, this.field_145849_e);
            cover.setNeedsUpdate(false);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ForgeDirection currentFacing = accessor.getSide();
        for (Cover cover : this.covers) {
            ItemStack coverStack;
            if (!cover.isValid() || (coverStack = cover.asItemStack()) == null) continue;
            currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.cover", (Object[])new Object[]{currentFacing == cover.getSide() ? StatCollector.func_74838_a((String)"GT5U.waila.cover.current_facing") : StatCollector.func_74838_a((String)("GT5U.interface.coverTabs." + cover.getSide().toString().toLowerCase())), coverStack.func_82833_r()}));
            String behaviorDesc = cover.getDescription();
            if (Objects.equals(behaviorDesc, "")) continue;
            currentTip.add(behaviorDesc);
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        for (Cover cover : this.covers) {
            if (cover == null || !cover.isValid()) continue;
            GTValues.NW.sendToPlayer(new GTPacketSendCoverData(cover, this, cover.getSide()), player);
        }
    }

    public static void addInstalledCoversInformation(NBTTagCompound aNBT, List<String> aList) {
        if (aNBT == null || aList == null) {
            return;
        }
        NBTTagList tList = aNBT.func_150295_c("gt.covers", 10);
        for (int i = 0; i < tList.func_74745_c(); i = (int)((byte)(i + 1))) {
            ItemStack coverStack;
            byte sideValue;
            NBTTagCompound tNBT = tList.func_150305_b(i);
            Cover cover = CoverRegistry.buildCoverFromNbt(tNBT, ForgeDirection.getOrientation((int)(sideValue = tNBT.func_74771_c(NBT_COVER_SIDE))), null);
            if (!cover.isValid() || (coverStack = cover.asItemStack()) == null) continue;
            aList.add(StatCollector.func_74837_a((String)"GT5U.interface.coverTabs.cover_on", (Object[])new Object[]{GTLanguageManager.getTranslation(GTLanguageManager.FACES[sideValue]), coverStack.func_82833_r()}));
        }
        byte strongRedstone = aNBT.func_74771_c("mStrongRedstone");
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            String string;
            if ((strongRedstone & dir.flag) == 0) continue;
            Object[] objectArray = new Object[1];
            switch (dir) {
                case DOWN: {
                    string = "GT5U.interface.coverTabs.redstone.bottom";
                    break;
                }
                case UP: {
                    string = "GT5U.interface.coverTabs.redstone.top";
                    break;
                }
                case NORTH: {
                    string = "GT5U.interface.coverTabs.redstone.north";
                    break;
                }
                case SOUTH: {
                    string = "GT5U.interface.coverTabs.redstone.south";
                    break;
                }
                case WEST: {
                    string = "GT5U.interface.coverTabs.redstone.west";
                    break;
                }
                case EAST: {
                    string = "GT5U.interface.coverTabs.redstone.east";
                    break;
                }
                default: {
                    string = "GT5U.interface.coverTabs.redstone.unknown";
                }
            }
            objectArray[0] = StatCollector.func_74838_a((String)string);
            aList.add(StatCollector.func_74837_a((String)"GT5U.interface.coverTabs.emits_redstone", (Object[])objectArray));
        }
    }

    protected ModularWindow createCoverWindow(EntityPlayer player, ForgeDirection side) {
        return this.getCoverAtSide(side).createCoverWindow(player);
    }

    @Override
    public void addCoverTabs(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int xPos;
        int COVER_TAB_LEFT = -16;
        boolean COVER_TAB_TOP = true;
        int COVER_TAB_HEIGHT = 20;
        int COVER_TAB_WIDTH = 18;
        int COVER_TAB_SPACING = 2;
        int ICON_SIZE = 16;
        final boolean flipHorizontally = GTMod.proxy.mCoverTabsFlipped;
        Column columnWidget = new Column();
        builder.widget((Widget)columnWidget);
        int n = xPos = flipHorizontally ? this.getGUIWidth() - -16 - 18 : -16;
        if (GTMod.proxy.mCoverTabsVisible) {
            columnWidget.setPos(xPos, 1 + this.getCoverTabHeightOffset()).setEnabled(widget -> ((Column)widget).getChildren().stream().anyMatch(Widget::isEnabled));
        } else {
            columnWidget.setEnabled(false);
        }
        columnWidget.setAlignment(MainAxisAlignment.SPACE_BETWEEN).setSpace(2);
        for (final ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            buildContext.addSyncedWindow(direction.ordinal() + 1, player -> this.createCoverWindow(player, direction));
            columnWidget.addChild(new MultiChildWidget().addChild(new ButtonWidget(){

                public IDrawable[] getBackground() {
                    ArrayList<UITexture> backgrounds = new ArrayList<UITexture>();
                    GUITextureSet tabIconSet = CoverableTileEntity.this.getGUITextureSet();
                    if (CoverableTileEntity.this.getCoverAtSide(direction).hasCoverGUI()) {
                        if (this.isHovering()) {
                            backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabHighlightFlipped() : tabIconSet.getCoverTabHighlight());
                        } else {
                            backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabNormalFlipped() : tabIconSet.getCoverTabNormal());
                        }
                    } else {
                        backgrounds.add(flipHorizontally ? tabIconSet.getCoverTabDisabledFlipped() : tabIconSet.getCoverTabDisabled());
                    }
                    return backgrounds.toArray(new IDrawable[0]);
                }
            }.setOnClick((clickData, widget) -> this.onTabClicked((Widget.ClickData)clickData, (Widget)widget, direction)).dynamicTooltip(() -> this.getCoverTabTooltip(direction)).setSize(18, 20)).addChild(new ItemDrawable(() -> this.getCoverItemAtSide(direction)).asWidget().setPos(1 + (flipHorizontally ? -1 : 1), 2)).setEnabled(widget -> this.getCoverItemAtSide(direction) != null));
        }
    }

    protected int getCoverTabHeightOffset() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    protected List<String> getCoverTabTooltip(ForgeDirection side) {
        Cover cover = this.getCoverAtSide(side);
        ItemStack coverItem = cover.asItemStack();
        if (coverItem == null) {
            return Collections.emptyList();
        }
        boolean coverHasGUI = cover.hasCoverGUI();
        Minecraft mc = Minecraft.func_71410_x();
        List tooltip = coverItem.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)((coverHasGUI ? EnumChatFormatting.UNDERLINE : EnumChatFormatting.DARK_GRAY) + StatCollector.func_74838_a((String)COVER_DIRECTION_NAMES[side.ordinal()]) + (coverHasGUI ? EnumChatFormatting.RESET + ": " : ": " + EnumChatFormatting.RESET) + (String)tooltip.get(0)));
        builder.addAll(cover.getAdditionalTooltip());
        builder.addAll(IntStream.range(1, tooltip.size()).mapToObj(index -> EnumChatFormatting.GRAY + (String)tooltip.get(index)).iterator());
        return builder.build();
    }

    protected void onTabClicked(Widget.ClickData ignoredClickData, Widget widget, ForgeDirection side) {
        if (this.isClientSide()) {
            return;
        }
        widget.getContext().openSyncedWindow(side.ordinal() + 1);
    }
}

