/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.GTMod;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class OverclockDescriber {
    protected final byte tier;

    public OverclockDescriber(byte tier) {
        this.tier = tier;
    }

    public final byte getTier() {
        return this.tier;
    }

    public abstract String getTierString();

    public abstract OverclockCalculator createCalculator(OverclockCalculator var1, GTRecipe var2);

    public abstract void drawEnergyInfo(RecipeDisplayInfo var1);

    public void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
        if (this.getDurationTicks(recipeInfo.calculator) <= 0) {
            return;
        }
        String textToDraw = GTMod.proxy.mNEIRecipeSecondMode && this.getDurationSeconds(recipeInfo.calculator) > 1.0 ? this.getDurationStringSeconds(recipeInfo.calculator) : this.getDurationStringTicks(recipeInfo.calculator);
        recipeInfo.drawText(textToDraw);
    }

    public boolean canHandle(GTRecipe recipe) {
        byte tier = GTUtility.getTier(recipe.mEUt);
        return this.tier >= tier;
    }

    private int getDurationTicks(OverclockCalculator calculator) {
        return calculator.getDuration();
    }

    private double getDurationSeconds(OverclockCalculator calculator) {
        return 0.05 * (double)this.getDurationTicks(calculator);
    }

    private String getDurationStringSeconds(OverclockCalculator calculator) {
        return StatCollector.func_74837_a((String)"GT5U.nei.display.duration.seconds", (Object[])new Object[]{GTUtility.formatNumbers(this.getDurationSeconds(calculator))});
    }

    private String getDurationStringTicks(OverclockCalculator calculator) {
        return StatCollector.func_74837_a((String)"GT5U.nei.display.duration.ticks", (Object[])new Object[]{GTUtility.formatNumbers(this.getDurationTicks(calculator))});
    }
}

