/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.gui.modularui.FallbackableSteamTexture;
import gregtech.api.gui.modularui.SteamTexture;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.util.FieldsAreNonnullByDefault;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public final class BasicUIProperties {
    public final int maxItemInputs;
    public final int maxItemOutputs;
    public final int maxFluidInputs;
    public final int maxFluidOutputs;
    private final SlotOverlayGetter<IDrawable> slotOverlays;
    private final SlotOverlayGetter<SteamTexture> slotOverlaysSteam;
    @Nullable
    public final FallbackableUITexture progressBarTexture;
    @Nullable
    public final FallbackableSteamTexture progressBarTextureSteam;
    public final ProgressBar.Direction progressBarDirection;
    public final Size progressBarSize;
    public final Pos2d progressBarPos;
    public final int progressBarImageSize;
    public final boolean useProgressBar;
    public final boolean useSpecialSlot;
    public final List<Rectangle> neiTransferRect;
    @Nullable
    public final String neiTransferRectId;
    public final List<Pair<IDrawable, Pair<Size, Pos2d>>> specialTextures;
    public final List<Pair<SteamTexture, Pair<Size, Pos2d>>> specialTexturesSteam;
    public final IDrawable logo;
    public final Size logoSize;
    public final Pos2d logoPos;
    public final IntFunction<List<Pos2d>> itemInputPositionsGetter;
    public final IntFunction<List<Pos2d>> itemOutputPositionsGetter;
    public final Supplier<Pos2d> specialItemPositionGetter;
    public final IntFunction<List<Pos2d>> fluidInputPositionsGetter;
    public final IntFunction<List<Pos2d>> fluidOutputPositionsGetter;
    public final int amperage;

    public static BasicUIPropertiesBuilder builder() {
        return new BasicUIPropertiesBuilder();
    }

    public BasicUIPropertiesBuilder toBuilder() {
        return new BasicUIPropertiesBuilder().maxItemInputs(this.maxItemInputs).maxItemOutputs(this.maxItemOutputs).maxFluidInputs(this.maxFluidInputs).maxFluidOutputs(this.maxFluidOutputs).slotOverlays(this.slotOverlays).slotOverlaysSteam(this.slotOverlaysSteam).progressBarTexture(this.progressBarTexture).progressBarTextureSteam(this.progressBarTextureSteam).progressBarDirection(this.progressBarDirection).progressBarSize(this.progressBarSize).progressBarPos(this.progressBarPos).useProgressBar(this.useProgressBar).useSpecialSlot(this.useSpecialSlot).neiTransferRect(this.neiTransferRect).neiTransferRectId(this.neiTransferRectId).specialTextures(this.specialTextures).specialTexturesSteam(this.specialTexturesSteam).logo(this.logo).logoSize(this.logoSize).logoPos(this.logoPos).itemInputPositionsGetter(this.itemInputPositionsGetter).itemOutputPositionsGetter(this.itemOutputPositionsGetter).specialItemPositionGetter(this.specialItemPositionGetter).fluidInputPositionsGetter(this.fluidInputPositionsGetter).fluidOutputPositionsGetter(this.fluidOutputPositionsGetter).amperage(this.amperage);
    }

    BasicUIProperties(int maxItemInputs, int maxItemOutputs, int maxFluidInputs, int maxFluidOutputs, SlotOverlayGetter<IDrawable> slotOverlays, SlotOverlayGetter<SteamTexture> slotOverlaysSteam, @Nullable FallbackableUITexture progressBarTexture, @Nullable FallbackableSteamTexture progressBarTextureSteam, ProgressBar.Direction progressBarDirection, Size progressBarSize, Pos2d progressBarPos, boolean useProgressBar, boolean useSpecialSlot, List<Rectangle> neiTransferRect, @Nullable String neiTransferRectId, List<Pair<IDrawable, Pair<Size, Pos2d>>> specialTextures, List<Pair<SteamTexture, Pair<Size, Pos2d>>> specialTexturesSteam, IDrawable logo, Size logoSize, Pos2d logoPos, IntFunction<List<Pos2d>> itemInputPositionsGetter, IntFunction<List<Pos2d>> itemOutputPositionsGetter, Supplier<Pos2d> specialItemPositionGetter, IntFunction<List<Pos2d>> fluidInputPositionsGetter, IntFunction<List<Pos2d>> fluidOutputPositionsGetter, int amperage) {
        int n;
        if (maxItemInputs < 0 || maxItemOutputs < 0 || maxFluidInputs < 0 || maxFluidOutputs < 0) {
            throw new IllegalArgumentException("maxItemInputs, maxItemOutputs, maxFluidInputs and maxFluidOutputs cannot be negative");
        }
        if (amperage < 1) {
            throw new IllegalArgumentException("Amperage cannot be lower than 1");
        }
        this.maxItemInputs = maxItemInputs;
        this.maxItemOutputs = maxItemOutputs;
        this.maxFluidInputs = maxFluidInputs;
        this.maxFluidOutputs = maxFluidOutputs;
        this.slotOverlays = slotOverlays;
        this.slotOverlaysSteam = slotOverlaysSteam;
        this.progressBarTexture = progressBarTexture;
        this.progressBarTextureSteam = progressBarTextureSteam;
        this.progressBarDirection = progressBarDirection;
        this.progressBarSize = progressBarSize;
        this.progressBarPos = progressBarPos;
        this.useProgressBar = useProgressBar;
        this.useSpecialSlot = useSpecialSlot;
        this.neiTransferRect = neiTransferRect;
        this.neiTransferRectId = neiTransferRectId;
        this.specialTextures = specialTextures;
        this.specialTexturesSteam = specialTexturesSteam;
        this.logo = logo;
        this.logoSize = logoSize;
        this.logoPos = logoPos;
        this.itemInputPositionsGetter = itemInputPositionsGetter;
        this.itemOutputPositionsGetter = itemOutputPositionsGetter;
        this.specialItemPositionGetter = specialItemPositionGetter;
        this.fluidInputPositionsGetter = fluidInputPositionsGetter;
        this.fluidOutputPositionsGetter = fluidOutputPositionsGetter;
        this.amperage = amperage;
        switch (progressBarDirection) {
            case UP: 
            case DOWN: {
                n = progressBarSize.height;
                break;
            }
            case CIRCULAR_CW: {
                n = Math.max(progressBarSize.width, progressBarSize.height);
                break;
            }
            default: {
                n = progressBarSize.width;
            }
        }
        this.progressBarImageSize = n;
    }

    @Nullable
    public IDrawable getOverlayForSlot(int index, boolean isFluid, boolean isOutput, boolean isSpecial) {
        return this.slotOverlays.apply(index, isFluid, isOutput, isSpecial);
    }

    @Nullable
    public SteamTexture getOverlayForSlotSteam(int index, boolean isFluid, boolean isOutput, boolean isSpecial) {
        return this.slotOverlaysSteam.apply(index, isFluid, isOutput, isSpecial);
    }

    public static interface SlotOverlayGetter<T> {
        @Nullable
        public T apply(int var1, boolean var2, boolean var3, boolean var4);
    }
}

