/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.GTMod;
import gregtech.api.enums.ItemList;
import gregtech.api.util.AssemblyLineServer;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class AssemblyLineUtils {
    private static boolean loadedALRecipes = false;
    private static final Multimap<GTUtility.ItemId, GTRecipe.RecipeAssemblyLine> AL_RECIPE_LOOKUP = MultimapBuilder.hashKeys().arrayListValues().build();

    private static void loadALRecipes() {
        if (loadedALRecipes) {
            return;
        }
        for (GTRecipe.RecipeAssemblyLine recipe : GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes) {
            AL_RECIPE_LOOKUP.put((Object)GTUtility.ItemId.create(recipe.mOutput), (Object)recipe);
        }
        loadedALRecipes = true;
    }

    public static Collection<GTRecipe.RecipeAssemblyLine> findALRecipeFromDataStick(ItemStack dataStick) {
        return AssemblyLineUtils.findALRecipeByOutput(AssemblyLineUtils.getDataStickOutput(dataStick));
    }

    public static Collection<GTRecipe.RecipeAssemblyLine> findALRecipeByOutput(ItemStack output) {
        if (output == null) {
            return Collections.emptyList();
        }
        AssemblyLineUtils.loadALRecipes();
        return AL_RECIPE_LOOKUP.get((Object)GTUtility.ItemId.create(output));
    }

    public static NBTTagCompound saveRecipe(GTRecipe.RecipeAssemblyLine recipe) {
        return recipe.mOutput.func_77955_b(new NBTTagCompound());
    }

    public static Collection<GTRecipe.RecipeAssemblyLine> loadRecipe(NBTTagCompound tag) {
        ItemStack output = ItemStack.func_77949_a((NBTTagCompound)tag);
        return AssemblyLineUtils.findALRecipeByOutput(output);
    }

    @Nullable
    public static GTRecipe.RecipeAssemblyLine assertSingleRecipe(Collection<GTRecipe.RecipeAssemblyLine> recipes) {
        if (recipes.isEmpty()) {
            return null;
        }
        if (recipes.size() > 1) {
            if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                throw new RuntimeException("found too many assembly line recipes for output: '" + recipes.iterator().next().mOutput.func_82833_r() + "', this method assumes this cannot happen");
            }
            GTMod.GT_FML_LOGGER.error("found too many assembly line recipes for output: '" + recipes.iterator().next().mOutput.func_82833_r() + "', this method assumes this cannot happen", (Throwable)new Exception());
        }
        return recipes.iterator().next();
    }

    public static boolean isItemDataStick(ItemStack aStack) {
        return GTUtility.isStackValid(aStack) && ItemList.Tool_DataStick.isStackEqual(aStack, false, true);
    }

    public static boolean doesDataStickHaveOutput(ItemStack aDataStick) {
        return AssemblyLineUtils.isItemDataStick(aDataStick) && aDataStick.func_77942_o() && aDataStick.func_77978_p().func_74764_b("output");
    }

    public static ItemStack getDataStickOutput(ItemStack aDataStick) {
        if (AssemblyLineUtils.doesDataStickHaveOutput(aDataStick)) {
            return GTUtility.loadItem(aDataStick.func_77978_p(), "output");
        }
        return null;
    }

    public static boolean setAssemblyLineRecipeOnDataStick(ItemStack aDataStick, GTRecipe.RecipeAssemblyLine aNewRecipe) {
        return AssemblyLineUtils.setAssemblyLineRecipeOnDataStick(aDataStick, aNewRecipe, true);
    }

    public static boolean setAssemblyLineRecipeOnDataStick(ItemStack aDataStick, GTRecipe.RecipeAssemblyLine aNewRecipe, boolean setUpdateTime) {
        if (!AssemblyLineUtils.isItemDataStick(aDataStick)) {
            return false;
        }
        if (aNewRecipe.mOutput == null) {
            return false;
        }
        String s = aNewRecipe.mOutput.func_82833_r();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = AssemblyLineServer.lServerNames.get(aNewRecipe.mOutput.func_82833_r())) == null) {
            s = aNewRecipe.mOutput.func_82833_r();
        }
        String author = "Assembling Line Recipe Generator";
        String displayName = null;
        if (aDataStick.func_77942_o()) {
            NBTTagCompound displayTag;
            NBTTagCompound tag = aDataStick.func_77978_p();
            if (tag.func_150297_b("author", 8)) {
                author = tag.func_74779_i("author");
            }
            if (tag.func_150297_b("display", 10) && (displayTag = tag.func_74775_l("display")).func_150297_b("Name", 8)) {
                displayName = displayTag.func_74779_i("Name");
            }
        }
        aDataStick.func_77982_d(new NBTTagCompound());
        NBTTagCompound rootTag = aDataStick.func_77978_p();
        if (displayName != null) {
            aDataStick.func_151001_c(displayName);
        }
        GTUtility.ItemNBT.setBookTitle(aDataStick, s + " Construction Data");
        rootTag.func_74782_a("output", (NBTBase)aNewRecipe.mOutput.func_77955_b(new NBTTagCompound()));
        rootTag.func_74778_a("author", author);
        NBTTagList tooltip = new NBTTagList();
        tooltip.func_74742_a((NBTBase)new NBTTagString("Construction plan for " + aNewRecipe.mOutput.field_77994_a + " " + s + ". Needed EU/t: " + aNewRecipe.mEUt + " Production time: " + aNewRecipe.mDuration / 20));
        rootTag.func_74782_a("pages", (NBTBase)tooltip);
        if (setUpdateTime) {
            rootTag.func_74772_a("lastUpdate", System.currentTimeMillis());
        }
        return true;
    }
}

