/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.GTMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.StatCollector;

public class GTTooltipDataCache {
    private final Map<String, TooltipData> fetchedTooltipData = new HashMap<String, TooltipData>();

    public TooltipData getData(String key, Object ... args) {
        TooltipData tooltipData = this.fetchedTooltipData.get(key);
        if (tooltipData == null) {
            tooltipData = this.getUncachedTooltipData(key, args);
            this.fetchedTooltipData.put(key, tooltipData);
        }
        return tooltipData;
    }

    public TooltipData getUncachedTooltipData(String key, Object ... args) {
        List<String> lines = this.getAllLines(key, args);
        int normalLines = lines.size();
        if (Math.max(GTMod.proxy.mTooltipVerbosity, GTMod.proxy.mTooltipShiftVerbosity) >= 3) {
            lines.addAll(this.getAllLines(key + ".extended", args));
        }
        if (lines.isEmpty()) {
            lines.add(key);
        }
        return new TooltipData(lines.subList(0, GTTooltipDataCache.getVerbosityIndex(GTMod.proxy.mTooltipVerbosity, normalLines, lines.size())), lines.subList(0, GTTooltipDataCache.getVerbosityIndex(GTMod.proxy.mTooltipShiftVerbosity, normalLines, lines.size())));
    }

    private List<String> getAllLines(String key, Object ... args) {
        ArrayList<String> lines = new ArrayList<String>();
        String keyToLookup = key;
        int i = 1;
        while (StatCollector.func_94522_b((String)keyToLookup)) {
            lines.add(StatCollector.func_74837_a((String)keyToLookup, (Object[])args));
            keyToLookup = key + "." + i++;
        }
        return lines;
    }

    private static int getVerbosityIndex(int tooltipVerbosity, int defaultIndex, int maxIndex) {
        int index = tooltipVerbosity < 1 ? 0 : (tooltipVerbosity == 1 ? 1 : (tooltipVerbosity == 2 ? defaultIndex : maxIndex));
        return index;
    }

    public static class TooltipData {
        public List<String> text;
        public List<String> shiftText;

        public TooltipData(List<String> text, List<String> shiftText) {
            this.text = text;
            this.shiftText = shiftText;
        }
    }
}

