/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.jetbrains.annotations.NotNull;

public class OutputHatchWrapper
implements IFluidStore {
    private final MTEHatchOutput outputHatch;
    private final Predicate<FluidStack> filter;

    public OutputHatchWrapper(MTEHatchOutput outputHatch, Predicate<FluidStack> filter) {
        this.outputHatch = outputHatch;
        this.filter = filter;
    }

    public FluidStack getFluid() {
        return this.outputHatch.getFluid();
    }

    public int getFluidAmount() {
        return this.outputHatch.getFluidAmount();
    }

    public int getCapacity() {
        return this.outputHatch.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.outputHatch.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.outputHatch.fill(resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.outputHatch.drain(maxDrain, doDrain);
    }

    @Override
    public boolean isEmptyAndAcceptsAnyFluid() {
        return false;
    }

    @Override
    public boolean canStoreFluid(@NotNull FluidStack fluidStack) {
        return this.outputHatch.canStoreFluid(fluidStack) && this.filter.test(fluidStack);
    }

    public MTEHatchOutput unwrap() {
        return this.outputHatch;
    }
}

