/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.covers.conditions.MaintenanceAlertCondition;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.gui.CoverNeedMaintenanceGui;
import gregtech.common.covers.modes.RedstoneMode;
import gregtech.common.gui.mui1.cover.NeedMaintainanceUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class CoverNeedMaintainance
extends CoverLegacyData {
    public CoverNeedMaintainance(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public static boolean isRotor(ItemStack rotor) {
        return rotor != null && rotor.func_77973_b() instanceof MetaGeneratedTool && rotor.func_77960_j() >= 170 && rotor.func_77960_j() <= 176;
    }

    public MaintenanceAlertCondition getMaintenanceAlertCondition() {
        int coverVariable = this.coverData;
        if (coverVariable >= 0 && coverVariable < MaintenanceAlertCondition.values().length << 1) {
            return MaintenanceAlertCondition.values()[coverVariable >> 1];
        }
        return MaintenanceAlertCondition.ISSUE_1;
    }

    public void setMaintenanceAlertCondition(MaintenanceAlertCondition threshold) {
        this.setVariable(this.coverData & 1 | threshold.ordinal() << 1);
    }

    public RedstoneMode getRedstoneMode() {
        int coverVariable = this.coverData;
        return (coverVariable & 1) > 0 ? RedstoneMode.INVERTED : RedstoneMode.NORMAL;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.setVariable(redstoneMode == RedstoneMode.NORMAL ? this.coverData & 0xFFFFFFFE : this.coverData | 1);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        IGregTechTileEntity tTileEntity;
        IMetaTileEntity mTileEntity;
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        boolean needsRepair = false;
        if (coverable instanceof IGregTechTileEntity && (mTileEntity = (tTileEntity = (IGregTechTileEntity)coverable).getMetaTileEntity()) instanceof MTEMultiBlockBase) {
            MTEMultiBlockBase multi = (MTEMultiBlockBase)mTileEntity;
            int ideal = multi.getIdealStatus();
            int real = multi.getRepairStatus();
            ItemStack tRotor = multi.getRealInventory()[1];
            int coverVar = this.coverData >>> 1;
            if (coverVar < 5) {
                if (ideal - real > coverVar) {
                    needsRepair = true;
                }
            } else if (coverVar == 5 || coverVar == 6) {
                if (CoverNeedMaintainance.isRotor(tRotor)) {
                    long mExpectedDamage;
                    long tMax = MetaGeneratedTool.getToolMaxDamage(tRotor);
                    long tCur = MetaGeneratedTool.getToolDamage(tRotor);
                    needsRepair = coverVar == 5 ? tCur >= tMax * 8L / 10L : tCur + (mExpectedDamage = Math.round(Math.min((double)(multi.mEUt / multi.damageFactorLow), Math.pow(multi.mEUt, multi.damageFactorHigh)))) * 2L >= tMax;
                } else {
                    needsRepair = true;
                }
            }
        }
        if (this.coverData % 2 == 0) {
            needsRepair = !needsRepair;
        }
        coverable.setOutputRedstoneSignal(this.coverSide, (byte)(needsRepair ? 0 : 15));
        coverable.setOutputRedstoneSignal(this.coverSide.getOpposite(), (byte)(needsRepair ? 0 : 15));
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 14;
        if (this.coverData < 0) {
            this.coverData = 13;
        }
        switch (this.coverData) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, NeedMaintainanceUIFactory.getMaintenanceIssuesCount(this.coverData / 2 + 1, this.coverData % 2 != 0));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.need_maint_rotor_lo"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.need_maint_rotor_lo") + StatCollector.func_74838_a((String)"gt.interact.desc.inverted_b"));
                break;
            }
            case 12: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.need_maint_rotor_hi"));
                break;
            }
            case 13: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.need_maint_rotor_hi") + StatCollector.func_74838_a((String)"gt.interact.desc.inverted_b"));
            }
        }
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 60;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverNeedMaintenanceGui(this);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new NeedMaintainanceUIFactory(buildContext).createWindow();
    }
}

