/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc;

import baubles.api.BaublesApi;
import com.gtnewhorizon.gtnhlib.datastructs.space.ArrayProximityMap4D;
import com.gtnewhorizon.gtnhlib.datastructs.space.VolumeShape;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IWirelessCharger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WirelessChargerManager {
    public static final int CHARGE_TICK = 20;
    private final ArrayProximityMap4D<IWirelessCharger> CHARGER_MAP = new ArrayProximityMap4D(VolumeShape.SPHERE);

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            if (this.CHARGER_MAP.isEmpty()) {
                return;
            }
            if (event.player.field_70173_aa % 20 == 5) {
                EntityPlayer player = event.player;
                this.CHARGER_MAP.forEachInRange(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, charger -> {
                    if (charger.canChargePlayerItems(player)) {
                        charger.chargePlayerItems(player, player.field_71071_by.field_70460_b, player.field_71071_by.field_70462_a, WirelessChargerManager.getBaublesItems(player));
                    }
                });
            }
        }
    }

    public void addCharger(@NotNull IWirelessCharger charger, int range) {
        IGregTechTileEntity te = charger.getChargerTE();
        this.CHARGER_MAP.put((Object)charger, te.getWorld().field_73011_w.field_76574_g, te.getXCoord(), (int)te.getYCoord(), te.getZCoord(), range);
    }

    public void removeCharger(@NotNull IWirelessCharger charger) {
        IGregTechTileEntity te = charger.getChargerTE();
        this.CHARGER_MAP.remove(te.getWorld().field_73011_w.field_76574_g, te.getXCoord(), (int)te.getYCoord(), te.getZCoord());
    }

    private static ItemStack[] getBaublesItems(@NotNull EntityPlayer player) {
        IInventory baubleInv;
        ItemStack[] baubleItems = null;
        if (Mods.Baubles.isModLoaded() && (baubleInv = BaublesApi.getBaubles((EntityPlayer)player)) != null) {
            baubleItems = new ItemStack[baubleInv.func_70302_i_()];
            for (int i = 0; i < baubleInv.func_70302_i_(); ++i) {
                baubleItems[i] = baubleInv.func_70301_a(i);
            }
        }
        return baubleItems;
    }
}

