/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.factory;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Grid;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.common.modularui2.sync.SelectItemServerAction;
import gregtech.common.modularui2.widget.SlotLikeButtonWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SelectItemGuiBuilder {
    public static final int DESELECTED = -1;
    private static final int COLS = 9;
    private static final int GUI_WIDTH = 176;
    private final ModularPanel panel;
    private final List<ItemStack> choices;
    @Nullable
    private ItemStack headerItem;
    @Nullable
    private IKey title;
    private int selected;
    @Nullable
    private IntSyncValue selectedSyncHandler;
    @Nullable
    private SelectItemServerAction onSelectedServerAction;
    @Nullable
    private OnSelectedAction onSelectedClientAction;
    @Nullable
    private IDrawable currentItemSlotOverlay;
    private boolean allowDeselected;
    private boolean built = false;

    public SelectItemGuiBuilder(ModularPanel panel, List<ItemStack> choices) {
        this.panel = panel;
        this.choices = choices;
    }

    public SelectItemGuiBuilder setHeaderItem(@Nullable ItemStack headerItem) {
        this.headerItem = headerItem;
        return this;
    }

    public SelectItemGuiBuilder setTitle(@Nullable IKey title) {
        this.title = title;
        return this;
    }

    public SelectItemGuiBuilder setSelected(int selected) {
        if (selected < -1 || selected >= this.choices.size()) {
            return this;
        }
        if (this.built && !this.allowDeselected && selected == -1) {
            return this;
        }
        this.selected = selected;
        return this;
    }

    public SelectItemGuiBuilder setSelectedSyncHandler(@Nullable IntSyncValue selectedSyncHandler) {
        this.selectedSyncHandler = selectedSyncHandler;
        return this;
    }

    public SelectItemGuiBuilder setOnSelectedServerAction(SelectItemServerAction onSelectedServerAction) {
        this.onSelectedServerAction = onSelectedServerAction;
        return this;
    }

    public SelectItemGuiBuilder setOnSelectedClientAction(@Nullable OnSelectedAction onSelectedClientAction) {
        this.onSelectedClientAction = onSelectedClientAction;
        return this;
    }

    public SelectItemGuiBuilder setCurrentItemSlotOverlay(@Nullable IDrawable currentItemSlotOverlay) {
        this.currentItemSlotOverlay = currentItemSlotOverlay;
        return this;
    }

    public SelectItemGuiBuilder setAllowDeselected(boolean allowDeselected) {
        this.allowDeselected = allowDeselected;
        return this;
    }

    public ModularPanel build() {
        if (this.choices.isEmpty()) {
            throw new IllegalStateException("Choices must not be empty!");
        }
        int rows = (this.choices.size() - 1) / 9 + 1;
        this.panel.size(176, 53 + 18 * rows);
        this.panel.childIf(this.headerItem != null || this.title != null, (IWidget)((Flow)((Flow)((Flow)Flow.row().coverChildren()).childPadding(4).pos(5, 5)).child((IWidget)new ItemDrawable(this.headerItem).asWidget().size(16))).childIf(this.title != null, (IWidget)this.title.asWidget()));
        this.panel.child((IWidget)((TextWidget)((TextWidget)IKey.lang((String)"GT5U.gui.select.current").asWidget().leftRel(0.5f, -12, 1.0f)).height(18)).top(22));
        this.panel.child((IWidget)((SlotLikeButtonWidget)((SlotLikeButtonWidget)((SlotLikeButtonWidget)((SlotLikeButtonWidget)new SlotLikeButtonWidget(() -> this.selected > -1 ? this.choices.get(this.selected) : null).background(new IDrawable[]{GTGuiTextures.SLOT_ITEM_DARK, new DynamicDrawable(() -> this.currentItemSlotOverlay != null ? this.currentItemSlotOverlay : IDrawable.EMPTY)})).playClickSound(false)).onMousePressed(mouseButton -> true)).alignX(0.5f)).top(22));
        ArrayList choiceWidgets = new ArrayList();
        for (int i = 0; i < rows; ++i) {
            int index;
            ArrayList<ButtonWidget> rowWidgets = new ArrayList<ButtonWidget>();
            choiceWidgets.add(rowWidgets);
            for (int j = 0; j < 9 && (index = i * 9 + j) < this.choices.size(); ++j) {
                rowWidgets.add(((SlotLikeButtonWidget)((SlotLikeButtonWidget)new SlotLikeButtonWidget(this.choices.get(index)).background(new IDrawable[]{new DynamicDrawable(() -> this.selected == index ? GTGuiTextures.SLOT_ITEM_DARK : GTGuiTextures.SLOT_ITEM_STANDARD)})).size(18)).onMousePressed(mouseButton -> {
                    if (mouseButton == 0) {
                        this.setSelected(index);
                    } else {
                        this.setSelected(-1);
                    }
                    MouseData mouseData = MouseData.create((int)mouseButton);
                    if (this.onSelectedServerAction != null) {
                        this.onSelectedServerAction.send(this.selected, mouseData);
                    }
                    if (this.onSelectedClientAction != null) {
                        this.onSelectedClientAction.accept(this.selected, mouseData);
                    }
                    return true;
                }));
            }
        }
        this.panel.child((IWidget)((Grid)((Grid)new Grid().coverChildren()).pos(7, 46)).matrix(choiceWidgets));
        if (this.selectedSyncHandler != null) {
            this.setSelected(this.selectedSyncHandler.getIntValue());
            this.selectedSyncHandler.setChangeListener(() -> this.setSelected(this.selectedSyncHandler.getIntValue()));
        }
        if (!this.allowDeselected && this.selected == -1) {
            this.setSelected(0);
        }
        this.built = true;
        return this.panel;
    }

    @FunctionalInterface
    public static interface OnSelectedAction {
        public void accept(int var1, MouseData var2);
    }
}

