/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.value.sync.PhantomItemSlotSH;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import gregtech.api.util.item.GhostCircuitItemStackHandler;
import gregtech.common.items.ItemIntegratedCircuit;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class GhostCircuitSyncHandler
extends PhantomItemSlotSH {
    public static final int SYNC_CIRCUIT_CONFIG = 10;

    public GhostCircuitSyncHandler(ModularSlot slot) {
        super(slot);
    }

    protected void phantomClick(MouseData mouseData, ItemStack cursorStack) {
        if (cursorStack != null && cursorStack.func_77973_b() instanceof ItemIntegratedCircuit) {
            this.setCircuitConfig(cursorStack.func_77960_j());
        } else if (mouseData.mouseButton == 0) {
            this.setCircuitConfig(this.getNextCircuitConfig(1));
        } else if (mouseData.mouseButton == 1 && mouseData.shift) {
            this.setCircuitConfig(-1);
        } else if (mouseData.mouseButton == 1) {
            this.setCircuitConfig(this.getNextCircuitConfig(-1));
        }
    }

    protected void phantomScroll(MouseData mouseData) {
        this.setCircuitConfig(this.getNextCircuitConfig(mouseData.mouseButton));
    }

    private void setCircuitConfig(int config) {
        GhostCircuitItemStackHandler handler = this.getGhostCircuitHandler();
        if (handler.getCircuitConfig() != config) {
            handler.setCircuitConfig(config);
            this.syncToClient(1, buf -> {
                buf.writeBoolean(false);
                NetworkUtils.writeItemStack((PacketBuffer)buf, (ItemStack)handler.getStackInSlot(0));
                buf.writeBoolean(false);
                buf.writeBoolean(false);
            });
        }
    }

    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id == 10) {
            this.setCircuitConfig(buf.readShort());
        } else {
            super.readOnServer(id, buf);
        }
    }

    private int getNextCircuitConfig(int delta) {
        GhostCircuitItemStackHandler handler = this.getGhostCircuitHandler();
        if (!handler.hasCircuit()) {
            return delta == 1 ? 1 : 24;
        }
        if (handler.getCircuitConfig() + delta > 24) {
            return -1;
        }
        if (handler.getCircuitConfig() + delta < 1) {
            return -1;
        }
        return handler.getCircuitConfig() + delta;
    }

    public GhostCircuitItemStackHandler getGhostCircuitHandler() {
        IItemHandler handler = this.getSlot().getItemHandler();
        if (!(handler instanceof GhostCircuitItemStackHandler)) {
            throw new IllegalStateException("GhostCircuitSyncHandler has IItemHandler that is not GhostCircuitItemStackHandler");
        }
        GhostCircuitItemStackHandler ghostHandler = (GhostCircuitItemStackHandler)handler;
        return ghostHandler;
    }
}

