/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.widget;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.InteractionSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.common.covers.Cover;
import gregtech.common.text.ClientTickRateFormatter;
import net.minecraft.util.StatCollector;

public class CoverTickRateButton
extends ButtonWidget<CoverTickRateButton> {
    private final Cover cover;

    public CoverTickRateButton(Cover cover, PanelSyncManager syncManager) {
        this.cover = cover;
        this.overlay(new IDrawable[]{GTGuiTextures.OVERLAY_BUTTON_HOURGLASS});
        this.syncHandler(new InteractionSyncHandler().setOnMousePressed(this::onClick));
        this.tooltipBuilder(this::buildTooltip);
        IntSyncValue tickRateAdditionSyncHandler = SyncHandlers.intNumber(cover::getTickRateAddition, cover::setTickRateAddition);
        tickRateAdditionSyncHandler.setChangeListener(() -> ((CoverTickRateButton)this).markTooltipDirty());
        syncManager.syncValue("tickRateAddition", (SyncHandler)tickRateAdditionSyncHandler);
    }

    private void onClick(MouseData mouseData) {
        int iterations = mouseData.ctrl ? 5 : 1;
        boolean isDecreasing = mouseData.mouseButton == 1;
        for (int i = 0; i < iterations; ++i) {
            this.cover.adjustTickRateMultiplier(isDecreasing);
        }
    }

    private void buildTooltip(RichTooltip tooltip) {
        int tickRateAddition = this.cover.getTickRateAddition();
        String boundsNotification = tickRateAddition == 0 ? StatCollector.func_74838_a((String)"gt.cover.info.button.bounds_notification.minimum") : (this.cover.isTickRateAdditionMax() ? StatCollector.func_74838_a((String)"gt.cover.info.button.bounds_notification.maximum") : "");
        ((RichTooltip)((RichTooltip)tooltip.addLine((IDrawable)IKey.lang((String)"gt.cover.info.button.tick_rate.1", (Object[])new Object[]{new ClientTickRateFormatter(this.cover.getTickRate()), boundsNotification}))).addLine((IDrawable)IKey.lang((String)"gt.cover.info.button.tick_rate.2"))).addLine((IDrawable)IKey.lang((String)"gt.cover.info.button.tick_rate.3"));
    }
}

