/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IModelCustomExt;
import gregtech.api.enums.Mods;
import gregtech.common.tileentities.render.TileEntityNanoForgeRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import org.lwjgl.opengl.GL11;

public class NanoForgeRenderer
extends TileEntitySpecialRenderer {
    private static boolean initialized;
    private static ResourceLocation coreTexture;
    private static ResourceLocation shieldTexture;
    private static ResourceLocation ringTexture;
    private static IModelCustomExt nanoforgeCoreModel;
    private static IModelCustomExt nanoforgeShieldModel;
    private static IModelCustomExt nanoforgeRingOneModel;
    private static IModelCustomExt nanoforgeRingTwoModel;
    private static IModelCustomExt nanoforgeRingThreeModel;
    private static final float WARM_UP_TIME = 25.0f;
    private static final float FULL_CHAOS_TIME = 75.0f;
    private static final float SPEED_MULTIPLIER = 10.0f;
    private static final float CHAOS_SPEED_MULTIPLIER = 90.0f;
    private static final float SINUS_DIVIDER = 50.0f;
    private static final float MAX_CHAOS_SPEED_UP = 2.0f;
    private static final float RING_ROTATION_NORMAL = 1.0f;

    private void init() {
        coreTexture = new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/Core.png");
        shieldTexture = new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/Shield.png");
        ringTexture = new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/RING.png");
        nanoforgeCoreModel = (IModelCustomExt)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/nano-forge-render-core.obj"));
        nanoforgeShieldModel = (IModelCustomExt)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/nano-forge-render-shield.obj"));
        nanoforgeRingOneModel = (IModelCustomExt)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/nano-forge-render-ring-one.obj"));
        nanoforgeRingTwoModel = (IModelCustomExt)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/nano-forge-render-ring-two.obj"));
        nanoforgeRingThreeModel = (IModelCustomExt)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/nano-forge-render-ring-three.obj"));
        initialized = true;
    }

    private void renderNanoForge(TileEntityNanoForgeRenderer tile, double x, double y, double z, float deltaT) {
        float timer = tile.getTimer();
        timer = !tile.getRunning() ? (timer -= deltaT) : (timer += deltaT);
        if (timer < 0.0f) {
            timer = 0.0f;
        }
        tile.setTimer(timer);
        this.func_147499_a(coreTexture);
        this.renderCore(x, y, z, timer, tile.getRed(), tile.getGreen(), tile.getBlue());
        this.func_147499_a(ringTexture);
        this.renderRingOne(x, y, z, timer);
        this.renderRingTwo(x, y, z, timer);
        this.renderRingThree(x, y, z, timer);
        this.func_147499_a(shieldTexture);
        this.renderShield(x, y, z, timer);
    }

    private void renderCore(double x, double y, double z, float timer, float r, float g, float b) {
        float chaos = Math.min(Math.max(timer - 25.0f, 0.0f) / 75.0f, 2.0f);
        float chaosScale = Math.min(Math.max(chaos, 0.05f), 1.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glScalef((float)chaosScale, (float)chaosScale, (float)chaosScale);
        GL11.glColor3f((float)r, (float)g, (float)b);
        GL11.glRotatef((float)(timer * 10.0f + timer * 90.0f * chaos), (float)((float)(0.3 * Math.sin(timer / 50.0f) + Math.sin((double)(timer / 50.0f) * 0.5) + 0.5 * Math.sin(timer / 50.0f * 3.0f))), (float)((float)(1.0 * Math.sin((double)(timer / 50.0f) * 0.3) + 3.0 * Math.sin(timer / 50.0f) + 0.3 * Math.sin(timer / 50.0f * 3.0f))), (float)((float)(2.0 * Math.sin((double)(timer / 50.0f) * 0.4) + Math.sin((double)(timer / 50.0f) * 1.5) + 1.2 * Math.sin(timer / 50.0f * 1.0f))));
        nanoforgeCoreModel.renderAllVBO();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderRingOne(double x, double y, double z, float timer) {
        float chaos = Math.min(Math.max(timer - 25.0f, 0.0f) / 75.0f, 2.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotatef((float)(timer * 10.0f + timer * 90.0f * chaos), (float)0.0f, (float)(0.5f + 1.0f * chaos), (float)0.0f);
        GL11.glRotatef((float)(timer * 90.0f * chaos), (float)NanoForgeRenderer.applyRotationMajor(timer), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(timer * 90.0f * chaos), (float)0.0f, (float)0.0f, (float)NanoForgeRenderer.applyRotationMinor(timer));
        nanoforgeRingOneModel.renderAllVBO();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderRingTwo(double x, double y, double z, float timer) {
        float chaos = Math.min(Math.max(timer - 25.0f, 0.0f) / 75.0f, 2.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotatef((float)(timer * 10.0f + timer * 90.0f * chaos), (float)(0.5f + 1.0f * chaos), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(timer * 90.0f * chaos), (float)0.0f, (float)0.0f, (float)NanoForgeRenderer.applyRotationMajor(timer));
        GL11.glRotatef((float)(timer * 90.0f * chaos), (float)0.0f, (float)NanoForgeRenderer.applyRotationMinor(timer), (float)0.0f);
        nanoforgeRingTwoModel.renderAllVBO();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderRingThree(double x, double y, double z, float timer) {
        float chaos = Math.min(Math.max(timer - 25.0f, 0.0f) / 75.0f, 2.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotatef((float)(timer * 10.0f + timer * 90.0f * chaos), (float)0.0f, (float)0.0f, (float)(0.5f + 1.0f * chaos));
        GL11.glRotatef((float)(timer * 90.0f * chaos), (float)0.0f, (float)NanoForgeRenderer.applyRotationMajor(timer), (float)0.0f);
        GL11.glRotatef((float)(timer * 90.0f * chaos), (float)NanoForgeRenderer.applyRotationMinor(timer), (float)0.0f, (float)0.0f);
        nanoforgeRingThreeModel.renderAllVBO();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderShield(double x, double y, double z, float timer) {
        float chaos = Math.min(Math.max(timer - 25.0f, 0.0f) / 75.0f, 2.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GL11.glRotatef((float)(timer * 10.0f + timer * 90.0f * chaos), (float)((float)(2.0 * Math.sin(timer / 50.0f) + Math.sin((double)(timer / 50.0f) * 0.5) + 0.5 * Math.sin(timer / 50.0f * 3.0f))), (float)((float)(1.0 * Math.sin((double)(timer / 50.0f) * 0.3) + 3.0 * Math.sin(timer / 50.0f) + 0.3 * Math.sin(timer / 50.0f * 3.0f))), (float)((float)(0.5 * Math.sin((double)(timer / 50.0f) * 0.4) + Math.sin((double)(timer / 50.0f) * 1.5) + 1.2 * Math.sin(timer / 50.0f * 1.0f))));
        nanoforgeShieldModel.renderAllVBO();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!(tile instanceof TileEntityNanoForgeRenderer)) {
            return;
        }
        TileEntityNanoForgeRenderer nanoforge = (TileEntityNanoForgeRenderer)tile;
        if (!initialized) {
            this.init();
            if (!initialized) {
                return;
            }
        }
        long systemTime = System.currentTimeMillis() % 36000000L;
        long diff = systemTime - nanoforge.getLastSystemTime();
        nanoforge.setLastSystemTime(systemTime);
        float deltaT = (float)diff / 1000.0f;
        if (deltaT > 1.0f) {
            deltaT = 0.0f;
        }
        this.renderNanoForge(nanoforge, x, y, z, deltaT);
    }

    private static float applyRotationMajor(float f) {
        return (float)(Math.sin(f / 50.0f) + 1.5 * Math.sin((double)(f / 50.0f) * 0.5) + 0.5 * Math.sin((double)(f / 50.0f) * 0.1));
    }

    private static float applyRotationMinor(float f) {
        return (float)(Math.sin(f / 50.0f) + 1.5 * Math.sin((double)(f / 50.0f) * 0.2) + 0.5 * Math.sin((double)(f / 50.0f) * 0.1));
    }
}

