/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.api.items.MetaGeneratedItem;
import gregtech.common.render.GTRenderUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class GlitchEffectMetaItemRenderer
implements IItemRenderer {
    public Random rand = new Random();
    int[] red = new int[]{255, 50, 50, 192};
    int[] cyan = new int[]{0, 220, 220, 160};
    final long frameTimeNanos = 10000000L;
    final int loopFrameCount = 200;
    final int glitchedDurationCount = 40;
    final int glitchMoveFrameCount = 5;
    double offsetRed = 0.0;
    double offsetCyan = 0.0;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        Item item2 = item.func_77973_b();
        if (item2 instanceof MetaGeneratedItem) {
            MetaGeneratedItem mgItem = (MetaGeneratedItem)item2;
            IIcon[] icons = mgItem.mIconList[item.func_77960_j() - mgItem.mOffset];
            if (icons != null && icons.length > 0 && icons[0] != null) {
                boolean timing;
                int currentFrame = (int)(System.nanoTime() % 2000000000L / 10000000L);
                boolean bl = timing = currentFrame <= 40;
                if (timing && currentFrame % 5 == 0) {
                    this.offsetRed = this.rand.nextDouble() * 1.7 * Math.signum(this.rand.nextGaussian());
                    this.offsetCyan = this.rand.nextDouble() * 1.7 * Math.signum(this.rand.nextGaussian());
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3008);
                GTRenderUtil.renderItem(type, icons[0]);
                if (type == IItemRenderer.ItemRenderType.INVENTORY && timing) {
                    GL11.glDisable((int)2929);
                    this.applyGlitchEffect(type, this.offsetCyan, this.cyan, icons[0]);
                    GL11.glEnable((int)2929);
                    this.applyGlitchEffect(type, this.offsetRed, this.red, icons[0]);
                }
                GL11.glDisable((int)3042);
            }
        }
        GL11.glPopMatrix();
    }

    private void applyGlitchEffect(IItemRenderer.ItemRenderType type, double offset, int[] color, IIcon ... icons) {
        for (IIcon icon : icons) {
            if (icon == null) continue;
            Tessellator t = Tessellator.field_78398_a;
            if (!type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) continue;
            t.func_78382_b();
            t.func_78369_a((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f);
            t.func_78374_a(0.0 + offset, 0.0 + offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            t.func_78374_a(0.0 + offset, 16.0 + offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 16.0 + offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 0.0 + offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            t.func_78381_a();
        }
    }
}

