/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import codechicken.lib.render.TextureUtils;
import fox.spiteful.avaritia.render.CosmicRenderShenanigans;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.common.render.GTRenderUtil;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class UniversiumRenderer
extends GeneratedMaterialRenderer {
    private static final float cosmicOpacity = 2.5f;

    @Override
    public boolean renderFluidDisplayItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        Item item = aStack.func_77973_b();
        if (item == null) {
            return false;
        }
        this.magicRenderMethod(type, ItemList.Emitter_UEV.get(1L, new Object[0]), item.func_77617_a(aStack.func_77960_j()), true, data);
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        short aMetaData = (short)aStack.func_77960_j();
        Item item = aStack.func_77973_b();
        if (!(item instanceof IGT_ItemWithMaterialRenderer)) {
            return;
        }
        IGT_ItemWithMaterialRenderer aItem = (IGT_ItemWithMaterialRenderer)item;
        int passes = 1;
        if (aItem.requiresMultipleRenderPasses()) {
            passes = aItem.getRenderPasses(aMetaData);
        }
        for (int pass = 0; pass < passes; ++pass) {
            IIcon tIcon = aItem.getIcon(aMetaData, pass);
            IIcon tOverlay = aItem.getOverlayIcon(aMetaData, pass);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3008);
            if (tIcon != null) {
                this.markNeedsAnimationUpdate(tIcon);
                this.magicRenderMethod(type, aStack, tIcon, false, data);
            }
            GL11.glDisable((int)2896);
            if (tOverlay != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                TextureUtils.bindAtlas((int)aItem.getSpriteNumber());
                this.markNeedsAnimationUpdate(tOverlay);
                this.renderItemOverlay(type, tOverlay);
            }
            GL11.glDisable((int)3042);
        }
    }

    private void magicRenderMethod(IItemRenderer.ItemRenderType type, ItemStack aStack, IIcon tIcon, boolean fluidDisplay, Object ... data) {
        if (!Mods.Avaritia.isModLoaded()) {
            return;
        }
        RenderItem r = RenderItem.getInstance();
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator t = Tessellator.field_78398_a;
        float minU = tIcon.func_94209_e();
        float maxU = tIcon.func_94212_f();
        float minV = tIcon.func_94206_g();
        float maxV = tIcon.func_94210_h();
        this.processLightLevel(type, data);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            RenderHelper.func_74520_c();
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2929);
            if (fluidDisplay) {
                ResourceLocation resourcelocation = mc.func_110434_K().func_130087_a(aStack.func_94608_d());
                mc.func_110434_K().func_110577_a(resourcelocation);
            } else {
                GTRenderUtil.renderItem(type, tIcon);
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            RenderHelper.func_74520_c();
            GL11.glDisable((int)3008);
            GL11.glDisable((int)2929);
            if (fluidDisplay) {
                GL11.glDisable((int)3042);
            }
            CosmicRenderShenanigans.cosmicOpacity = 2.5f;
            CosmicRenderShenanigans.inventoryRender = true;
            CosmicRenderShenanigans.useShader();
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GTRenderUtil.renderItem(type, tIcon);
            CosmicRenderShenanigans.releaseShader();
            CosmicRenderShenanigans.inventoryRender = false;
            GL11.glEnable((int)32826);
        } else {
            GTRenderUtil.renderItem(type, tIcon);
            int program = GL11.glGetInteger((int)35725);
            GL11.glDisable((int)3008);
            GL11.glDepthFunc((int)514);
            CosmicRenderShenanigans.cosmicOpacity = 2.5f;
            CosmicRenderShenanigans.useShader();
            GTRenderUtil.renderItem(type, tIcon);
            CosmicRenderShenanigans.releaseShader();
            GL11.glDepthFunc((int)515);
            GL20.glUseProgram((int)program);
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void processLightLevel(IItemRenderer.ItemRenderType type, Object ... data) {
        switch (type) {
            case ENTITY: {
                EntityItem ent = (EntityItem)data[1];
                if (ent == null) break;
                CosmicRenderShenanigans.setLightFromLocation((World)ent.field_70170_p, (int)MathHelper.func_76128_c((double)ent.field_70165_t), (int)MathHelper.func_76128_c((double)ent.field_70163_u), (int)MathHelper.func_76128_c((double)ent.field_70161_v));
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                EntityLivingBase ent = (EntityLivingBase)data[1];
                if (ent == null) break;
                CosmicRenderShenanigans.setLightFromLocation((World)ent.field_70170_p, (int)MathHelper.func_76128_c((double)ent.field_70165_t), (int)MathHelper.func_76128_c((double)ent.field_70163_u), (int)MathHelper.func_76128_c((double)ent.field_70161_v));
                break;
            }
            case INVENTORY: {
                CosmicRenderShenanigans.setLightLevel((float)10.2f);
                break;
            }
            default: {
                CosmicRenderShenanigans.setLightLevel((float)1.0f);
            }
        }
    }
}

