/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.common.config.MachineStats;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEMicrowaveEnergyTransmitter
extends MTEBasicTank
implements IAddGregtechLogo,
IAddUIWidgets {
    private static boolean sInterDimensionalTeleportAllowed = true;
    private static int mMaxLoss = 50;
    private static int mMaxLossDistance = 10000;
    private static boolean mPassiveEnergyUse = true;
    public int mTargetX = 0;
    public int mTargetY = 0;
    public int mTargetZ = 0;
    public int mTargetD = 0;
    public boolean mDebug = false;
    public boolean hasBlock = false;
    public int tTargetX = 0;
    public int tTargetY = 0;
    public int tTargetZ = 0;
    public int tTargetD = 0;
    public TileEntity tTile = null;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public MTEMicrowaveEnergyTransmitter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Transmits Energy Wirelessly", "Use Nitrogen Plasma", "for Inter-dimensional transmission", "0.004EU Loss per 100 Blocks"}, new ITexture[0]);
    }

    public MTEMicrowaveEnergyTransmitter(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.hasBlock = this.checkForBlock();
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMicrowaveEnergyTransmitter(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.infodata.coordinates"), StatCollector.func_74837_a((String)"GT5U.infodata.coordinates.x", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mTargetX) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.coordinates.y", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mTargetY) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.coordinates.z", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mTargetZ) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.dimension", (Object[])new Object[]{"" + EnumChatFormatting.GREEN + this.mTargetD + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.dimension.valid", (Object[])new Object[]{GTUtility.isRealDimension(this.mTargetD) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.infodata.yes") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.infodata.no") + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.dimension.registered", (Object[])new Object[]{DimensionManager.isDimensionRegistered((int)this.mTargetD) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.infodata.yes") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.infodata.no") + EnumChatFormatting.RESET})};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == ForgeDirection.DOWN) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_TELEPORTER), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TELEPORTER_GLOW).glow().build()};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        aNBT.func_74768_a("mTargetX", this.mTargetX);
        aNBT.func_74768_a("mTargetY", this.mTargetY);
        aNBT.func_74768_a("mTargetZ", this.mTargetZ);
        aNBT.func_74768_a("mTargetD", this.mTargetD);
        aNBT.func_74757_a("mDebug", this.mDebug);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
        this.mTargetX = aNBT.func_74762_e("mTargetX");
        this.mTargetY = aNBT.func_74762_e("mTargetY");
        this.mTargetZ = aNBT.func_74762_e("mTargetZ");
        this.mTargetD = aNBT.func_74762_e("mTargetD");
        this.mDebug = aNBT.func_74767_n("mDebug");
    }

    @Override
    public void onConfigLoad() {
        sInterDimensionalTeleportAllowed = MachineStats.teleporter.interDimensionalTPAllowed;
        mMaxLoss = Math.max(MachineStats.microwaveEnergyTransmitter.maxLoss, 11);
        mMaxLossDistance = MachineStats.microwaveEnergyTransmitter.maxLossDistance;
        mPassiveEnergyUse = MachineStats.microwaveEnergyTransmitter.passiveEnergyUse;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mTargetX == 0 && this.mTargetY == 0 && this.mTargetZ == 0 && this.mTargetD == 0) {
                this.mTargetX = aBaseMetaTileEntity.getXCoord();
                this.mTargetY = aBaseMetaTileEntity.getYCoord();
                this.mTargetZ = aBaseMetaTileEntity.getZCoord();
                this.mTargetD = aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
            }
            this.hasBlock = this.checkForBlock();
        }
    }

    public boolean checkForBlock() {
        for (int i = -5; i <= 5; i = (int)((byte)(i + 1))) {
            for (int j = -5; j <= 5; j = (int)((byte)(j + 1))) {
                for (int k = -5; k <= 5; k = (int)((byte)(k + 1))) {
                    if (this.getBaseMetaTileEntity().getBlockOffset(i, j, k) != GregTechAPI.sBlockMetal5 || this.getBaseMetaTileEntity().getMetaIDOffset(i, j, k) != 8) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasDimensionalTeleportCapability() {
        return this.mDebug || sInterDimensionalTeleportAllowed && (this.hasBlock || this.mFluid != null && this.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L)) && this.mFluid.amount >= 1000);
    }

    public boolean isDimensionalTeleportAvailable() {
        return this.mDebug || this.hasDimensionalTeleportCapability() && GTUtility.isRealDimension(this.mTargetD) && GTUtility.isRealDimension(this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mFluid == null) {
            this.mFluid = Materials.Nitrogen.getPlasma(0L);
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.getBaseMetaTileEntity().getTimer() % 100L == 50L) {
                this.hasBlock = this.checkForBlock();
            }
            if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().getRedstone()) {
                if (this.getBaseMetaTileEntity().getStoredEU() > GTValues.V[this.mTier] * 16L) {
                    if (mPassiveEnergyUse) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(2L << this.mTier - 1, false);
                    }
                    if (this.hasDimensionalTeleportCapability() && this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && this.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L))) {
                        --this.mFluid.amount;
                        if (this.mFluid.amount < 1) {
                            this.mFluid = null;
                        }
                    }
                    if (this.tTargetD != this.mTargetD || this.tTargetX != this.mTargetX || this.tTargetY != this.mTargetY || this.tTargetZ != this.mTargetZ) {
                        this.tTargetD = this.mTargetD;
                        this.tTargetX = this.mTargetX;
                        this.tTargetY = this.mTargetY;
                        this.tTargetZ = this.mTargetZ;
                        if (this.mTargetD == this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g) {
                            this.tTile = this.getBaseMetaTileEntity().getTileEntity(this.mTargetX, this.mTargetY, this.mTargetZ);
                        } else {
                            WorldServer tWorld = DimensionManager.getWorld((int)this.mTargetD);
                            if (tWorld != null) {
                                this.tTile = tWorld.func_147438_o(this.mTargetX, this.mTargetY, this.mTargetZ);
                            }
                        }
                    }
                    int tDistance = this.distanceCalculation();
                    if (this.tTile != null && this.tTile instanceof IEnergyConnected) {
                        IMetaTileEntity mte;
                        long packetSize = GTValues.V[this.mTier];
                        if (this.tTile instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)this.tTile).getMetaTileEntity()) instanceof BaseMetaTileEntity) {
                            packetSize = ((BaseMetaTileEntity)((Object)mte)).getMaxSafeInput();
                        }
                        long energyUse = 10L;
                        if (mMaxLossDistance != 0) {
                            energyUse = GTUtility.safeInt(10L + (long)tDistance * Math.max((long)mMaxLoss - 10L, 0L) / (long)mMaxLossDistance);
                        }
                        energyUse = packetSize + GTValues.V[this.mTier] * energyUse / 100L;
                        if (this.getBaseMetaTileEntity().isUniversalEnergyStored(energyUse) && ((IEnergyConnected)this.tTile).injectEnergyUnits(ForgeDirection.UNKNOWN, packetSize, 1L) > 0L) {
                            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(energyUse, false);
                        }
                    }
                }
                this.getBaseMetaTileEntity().setActive(true);
            } else {
                this.getBaseMetaTileEntity().setActive(false);
            }
        }
    }

    private int distanceCalculation() {
        double dx = this.getBaseMetaTileEntity().getXCoord() - this.mTargetX;
        double dy = this.getBaseMetaTileEntity().getYCoord() - this.mTargetY;
        double dz = this.getBaseMetaTileEntity().getZCoord() - this.mTargetZ;
        return Math.abs((this.mTargetD != this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g && this.isDimensionalTeleportAvailable() ? 100 : 1) * (int)Math.sqrt(dx * dx + dy * dy + dz * dz));
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 256L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return 3L;
    }

    @Override
    public int getOutputSlot() {
        return 0;
    }

    @Override
    public int getCapacity() {
        return 64000;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    protected boolean useMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(PosGuiData data, PanelSyncManager syncManager, UISettings uiSettings) {
        return (ModularPanel)GTGuis.mteTemplatePanelBuilder(this, data, syncManager, uiSettings).doesAddGregTechLogo(false).build().child((IWidget)((Flow)((Flow)((Flow)Flow.row().child((IWidget)((Flow)((Flow)Flow.column().child((IWidget)((Widget)GTGuiTextures.OVERLAY_BUTTON_BOUNDING_BOX.asWidget().size(18, 18)).topRel(0.5f))).heightRel(1.0f)).coverChildrenWidth())).child((IWidget)this.createSelectionColumn())).crossAxisAlignment(Alignment.CrossAxis.START).pos(4, 6)).coverChildren());
    }

    public Flow createSelectionColumn() {
        return (Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().child((IWidget)((Flow)((Flow)Flow.row().child((IWidget)((TextFieldWidget)new TextFieldWidget().setFormatAsInteger(true).value((IStringValue)new IntSyncValue(() -> this.mTargetX, i -> {
            this.mTargetX = i;
        })).size(77, 12)).margin(2, 0))).child((IWidget)IKey.lang((String)"GT5U.gui.text.microwave_energy_transmitter.x").asWidget())).coverChildren())).child((IWidget)((Flow)((Flow)Flow.row().child((IWidget)((TextFieldWidget)new TextFieldWidget().setFormatAsInteger(true).value((IStringValue)new IntSyncValue(() -> this.mTargetY, i -> {
            this.mTargetY = i;
        })).size(77, 12)).margin(2, 0))).child((IWidget)IKey.lang((String)"GT5U.gui.text.microwave_energy_transmitter.y").asWidget())).coverChildren())).child((IWidget)((Flow)((Flow)Flow.row().child((IWidget)((TextFieldWidget)new TextFieldWidget().setFormatAsInteger(true).value((IStringValue)new IntSyncValue(() -> this.mTargetZ, i -> {
            this.mTargetZ = i;
        })).size(77, 12)).margin(2, 0))).child((IWidget)IKey.lang((String)"GT5U.gui.text.microwave_energy_transmitter.z").asWidget())).coverChildren())).child((IWidget)((Flow)((Flow)((Flow)Flow.row().child((IWidget)((TextFieldWidget)new TextFieldWidget().setFormatAsInteger(true).value((IStringValue)new IntSyncValue(() -> this.mTargetD, i -> {
            this.mTargetD = i;
        })).size(77, 12)).margin(2, 0))).child((IWidget)IKey.lang((String)"GT5U.gui.text.microwave_energy_transmitter.d").asWidget())).child((IWidget)new DynamicDrawable(() -> GTUtility.isRealDimension(this.mTargetD) ? GTGuiTextures.OVERLAY_BUTTON_CHECKMARK : GTGuiTextures.OVERLAY_BUTTON_CROSS).asWidget().size(16, 16))).coverChildren())).crossAxisAlignment(Alignment.CrossAxis.START).childPadding(2).coverChildren();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setSize(90, 72).setPos(43, 4))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.x", (Object[])new Object[]{numberFormat.format((long)this.mTargetX)})).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 8))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.y", (Object[])new Object[]{numberFormat.format((long)this.mTargetY)})).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 16))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.z", (Object[])new Object[]{numberFormat.format((long)this.mTargetZ)})).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 24))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.dim", (Object[])new Object[]{numberFormat.format((long)this.mTargetD)})).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 32))).widget(TextWidget.dynamicString(() -> GTUtility.isRealDimension(this.mTargetD) ? StatCollector.func_74838_a((String)"GT5U.gui.text.dim.valid") : StatCollector.func_74838_a((String)"GT5U.gui.text.dim.invalid")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.hasDimensionalTeleportCapability()).setPos(46, 40))).widget((com.gtnewhorizons.modularui.api.widget.Widget)new FakeSyncWidget.FluidStackSyncer(() -> this.mFluid, val -> {
            this.mFluid = val;
        }));
        this.addChangeNumberButtons(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, -512, -64, 7);
        this.addChangeNumberButtons(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, -16, -1, 25);
        this.addChangeNumberButtons(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, 16, 1, 133);
        this.addChangeNumberButtons(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, 512, 64, 151);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.mTargetD += val.intValue(), -16, -8, 7, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.mTargetD += val.intValue(), -4, -1, 25, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.mTargetD += val.intValue(), 4, 1, 133, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.mTargetD += val.intValue(), 16, 8, 151, 58);
    }

    private void addChangeNumberButtons(ModularWindow.Builder builder, IDrawable overlay, int addNumberShift, int addNumber, int xPos) {
        this.addChangeNumberButton(builder, overlay, val -> this.mTargetX += val.intValue(), addNumberShift, addNumber, xPos, 4);
        this.addChangeNumberButton(builder, overlay, val -> this.mTargetY += val.intValue(), addNumberShift, addNumber, xPos, 22);
        this.addChangeNumberButton(builder, overlay, val -> this.mTargetZ += val.intValue(), addNumberShift, addNumber, xPos, 40);
    }

    private void addChangeNumberButton(ModularWindow.Builder builder, IDrawable overlay, Consumer<Integer> setter, int addNumberShift, int addNumber, int xPos, int yPos) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> setter.accept(clickData.shift ? addNumberShift : addNumber)).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, overlay}).setSize(18, 18).setPos(xPos, yPos));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setGregTechLogo(GTUITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_GRAY);
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(113, 56));
    }
}

