/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.value.sync.DoubleSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.ProgressWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.slot.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SteamVariant;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IGetTitleColor;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.RecipeMapWorkable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.api.modularui2.GTGuiTheme;
import gregtech.api.modularui2.GTGuiThemes;
import gregtech.api.modularui2.GTGuis;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTWaila;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.client.GTSoundLoop;
import gregtech.common.modularui2.widget.GTProgressWidget;
import gregtech.common.pollution.Pollution;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class MTEBrickedBlastFurnace
extends MetaTileEntity
implements IAlignment,
ISurvivalConstructable,
RecipeMapWorkable,
IAddUIWidgets,
IGetTitleColor,
ISecondaryDescribable {
    public static final int INPUT_SLOTS = 3;
    public static final int OUTPUT_SLOTS = 3;
    private static final IStructureDefinition<MTEBrickedBlastFurnace> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "c-c", "ccc"}, {"ccc", "clc", "ccc"}, {"c~c", "clc", "ccc"}, {"ccc", "ccc", "ccc"}})).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)15))).addElement('l', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150353_l, (int)1), StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150356_k, (int)1)})).build();
    private static final ITexture[] FACING_SIDE = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_DENSEBRICKS)};
    private static final ITexture[] FACING_FRONT = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_INACTIVE)};
    private static final ITexture[] FACING_ACTIVE = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE_GLOW).glow().build()};
    private MultiblockTooltipBuilder tooltipBuilder;
    public int mMaxProgresstime = 0;
    private volatile boolean mUpdated;
    public int mUpdate = 5;
    public int mProgresstime = 0;
    public boolean mMachine = false;
    @SideOnly(value=Side.CLIENT)
    protected GTSoundLoop activitySoundLoop;
    public ItemStack[] mOutputItems = new ItemStack[3];

    public MTEBrickedBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
    }

    public MTEBrickedBlastFurnace(String aName) {
        super(aName, 6);
    }

    @Override
    public String[] getDescription() {
        return this.getCurrentDescription();
    }

    @Override
    public boolean isDisplaySecondaryDescription() {
        return Keyboard.isKeyDown((int)42);
    }

    @Override
    public String[] getPrimaryDescription() {
        return this.getTooltip().getInformation();
    }

    @Override
    public String[] getSecondaryDescription() {
        return this.getTooltip().getStructureInformation();
    }

    protected MultiblockTooltipBuilder getTooltip() {
        if (this.tooltipBuilder == null) {
            this.tooltipBuilder = new MultiblockTooltipBuilder();
            this.tooltipBuilder.addMachineType("Blast Furnace, BBF").addInfo("Usable for Steel and general Pyrometallurgy").addInfo("Has a useful interface, unlike other gregtech multis").addPollutionAmount(GTMod.proxy.mPollutionPrimitveBlastFurnacePerSecond).beginStructureBlock(3, 4, 3, true).addController("Front center").addOtherStructurePart("Firebricks", "Everything except the controller").addStructureInfo("The top block is also empty").addStructureInfo("You can share the walls of GT multis, so").addStructureInfo("each additional one costs less, up to 4").toolTipFinisher(new String[0]);
        }
        return this.tooltipBuilder;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return (facing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return aActive ? FACING_ACTIVE : FACING_FRONT;
        }
        return FACING_SIDE;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        return CoverRegistry.getCoverPlacer(coverItem).allowOnPrimitiveBlock() && super.allowCoverOnSide(side, coverItem);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBrickedBlastFurnace(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        if (this.mOutputItems != null) {
            for (int i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null) continue;
                NBTTagCompound tNBT = new NBTTagCompound();
                this.mOutputItems[i].func_77955_b(tNBT);
                aNBT.func_74782_a("mOutputItem" + i, (NBTBase)tNBT);
            }
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mUpdate = 5;
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        this.mOutputItems = new ItemStack[3];
        for (int i = 0; i < 3; ++i) {
            this.mOutputItems[i] = GTUtility.loadItem(aNBT, "mOutputItem" + i);
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    public ExtendedFacing getExtendedFacing() {
        return ExtendedFacing.of((ForgeDirection)this.getBaseMetaTileEntity().getFrontFacing());
    }

    public void setExtendedFacing(ExtendedFacing alignment) {
        this.getBaseMetaTileEntity().setFrontFacing(alignment.getDirection());
    }

    public IAlignmentLimits getAlignmentLimits() {
        return (d, r, f) -> (d.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    private boolean checkMachine() {
        return STRUCTURE_DEFINITION.check((Object)this, "main", this.getBaseMetaTileEntity().getWorld(), this.getExtendedFacing(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 1, 2, 0, !this.mMachine);
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdated = true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        int lavaX = aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1);
        int lavaZ = aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1);
        if (aBaseMetaTileEntity.isClientSide()) {
            if (aBaseMetaTileEntity.isActive() && this.activitySoundLoop == null) {
                this.updateSound(aBaseMetaTileEntity);
            } else if (!aBaseMetaTileEntity.isActive() && this.activitySoundLoop != null) {
                this.activitySoundLoop = null;
            }
            if (aBaseMetaTileEntity.isActive()) {
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.3, 0.0).setIdentifier((Enum)ParticleFX.LARGE_SMOKE)).setPosition((float)lavaX + XSTR.XSTR_INSTANCE.nextFloat(), aBaseMetaTileEntity.getOffsetY(aBaseMetaTileEntity.getBackFacing(), 1), (float)lavaZ + XSTR.XSTR_INSTANCE.nextFloat()).setWorld(this.getBaseMetaTileEntity().getWorld()).run();
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdated) {
                if (this.mUpdate < 0) {
                    this.mUpdate = 5;
                }
                this.mUpdated = false;
            }
            if (this.mUpdate-- == 0) {
                this.mMachine = this.checkMachine();
            }
            if (this.mMachine) {
                if (this.mMaxProgresstime > 0) {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        this.addOutputProducts();
                        this.mOutputItems = null;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        GTMod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "steel");
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.checkRecipe();
                }
            }
            if (this.mMaxProgresstime > 0 && aTimer % 20L == 0L) {
                Pollution.addPollution(this.getBaseMetaTileEntity(), GTMod.proxy.mPollutionPrimitveBlastFurnacePerSecond);
            }
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0 && this.mMachine);
            short lavaY = aBaseMetaTileEntity.getYCoord();
            if (aBaseMetaTileEntity.isActive()) {
                if (aBaseMetaTileEntity.getAir(lavaX, lavaY, lavaZ)) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, (int)lavaY, lavaZ, Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getAir(lavaX, lavaY + 1, lavaZ)) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, lavaY + 1, lavaZ, Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
            } else {
                Block lowerLava = aBaseMetaTileEntity.getBlock(lavaX, lavaY, lavaZ);
                Block upperLava = aBaseMetaTileEntity.getBlock(lavaX, lavaY + 1, lavaZ);
                if (lowerLava == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, (int)lavaY, lavaZ, Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
                if (upperLava == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, lavaY + 1, lavaZ, Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound(IGregTechTileEntity aBaseMetaTileEntity) {
        this.activitySoundLoop = new GTSoundLoop(SoundResource.GTCEU_LOOP_FIRE.resourceLocation, aBaseMetaTileEntity, false, true);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.activitySoundLoop);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isClientSide()) {
            StructureLibAPI.queryAlignment((IAlignmentProvider)((IAlignmentProvider)aBaseMetaTileEntity));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isActive()) {
            double z;
            double x;
            ForgeDirection frontFacing = aBaseMetaTileEntity.getFrontFacing();
            double oX = (double)aBaseMetaTileEntity.getOffsetX(frontFacing, 1) + 0.5;
            double oY = aBaseMetaTileEntity.getOffsetY(frontFacing, 1);
            double oZ = (double)aBaseMetaTileEntity.getOffsetZ(frontFacing, 1) + 0.5;
            double offset = -0.48;
            double horizontal = (double)XSTR.XSTR_INSTANCE.nextFloat() * 8.0 / 16.0 - 0.25;
            double y = oY + (double)XSTR.XSTR_INSTANCE.nextFloat() * 10.0 / 16.0 + 0.3125;
            if (frontFacing == ForgeDirection.WEST) {
                x = oX - -0.48;
                z = oZ + horizontal;
            } else if (frontFacing == ForgeDirection.EAST) {
                x = oX + -0.48;
                z = oZ + horizontal;
            } else if (frontFacing == ForgeDirection.NORTH) {
                x = oX + horizontal;
                z = oZ - -0.48;
            } else {
                x = oX + horizontal;
                z = oZ + -0.48;
            }
            WorldSpawnedEventBuilder.ParticleEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setPosition(x, y, z).setWorld(this.getBaseMetaTileEntity().getWorld());
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.SMOKE)).run();
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.FLAME)).run();
        }
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.primitiveBlastRecipes;
    }

    private void addOutputProducts() {
        if (this.mOutputItems == null) {
            return;
        }
        int limit = Math.min(this.mOutputItems.length, 3);
        for (int i = 0; i < limit; ++i) {
            int absi = 3 + i;
            if (this.mInventory[absi] == null) {
                this.mInventory[absi] = GTUtility.copyOrNull(this.mOutputItems[i]);
                continue;
            }
            if (!GTUtility.areStacksEqual(this.mInventory[absi], this.mOutputItems[i])) continue;
            this.mInventory[absi].field_77994_a = Math.min(this.mInventory[absi].func_77976_d(), this.mInventory[absi].field_77994_a + this.mOutputItems[i].field_77994_a);
        }
    }

    private boolean spaceForOutput(ItemStack outputStack, int relativeOutputSlot) {
        int absoluteSlot = relativeOutputSlot + 3;
        if (this.mInventory[absoluteSlot] == null || outputStack == null) {
            return true;
        }
        return this.mInventory[absoluteSlot].field_77994_a + outputStack.field_77994_a <= this.mInventory[absoluteSlot].func_77976_d() && GTUtility.areStacksEqual(this.mInventory[absoluteSlot], outputStack);
    }

    private boolean checkRecipe() {
        int i;
        if (!this.mMachine) {
            return false;
        }
        ItemStack[] inputs = new ItemStack[3];
        System.arraycopy(this.mInventory, 0, inputs, 0, 3);
        GTRecipe recipe = this.getRecipeMap().findRecipeQuery().items(inputs).find();
        if (recipe == null) {
            this.mOutputItems = null;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (this.spaceForOutput(recipe.getOutput(i), i)) continue;
            this.mOutputItems = null;
            return false;
        }
        if (!recipe.isRecipeInputEqual(true, null, inputs)) {
            this.mOutputItems = null;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a != 0) continue;
            this.mInventory[i] = null;
        }
        this.mMaxProgresstime = recipe.mDuration;
        this.mOutputItems = recipe.mOutputs;
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public byte getTileEntityBaseType() {
        return 0;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return STRUCTURE_DEFINITION.survivalBuild((Object)this, stackSize, "main", this.getBaseMetaTileEntity().getWorld(), this.getExtendedFacing(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 1, 2, 0, elementBudget, env, false);
    }

    public IStructureDefinition<MTEBrickedBlastFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        STRUCTURE_DEFINITION.buildOrHints((Object)this, stackSize, "main", this.getBaseMetaTileEntity().getWorld(), this.getExtendedFacing(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 1, 2, 0, hintsOnly);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        if (!this.getBaseMetaTileEntity().isInvalidTileEntity()) {
            NBTTagCompound nbt = accessor.getNBTData();
            currenttip.add(GTWaila.getMachineProgressString(this.getBaseMetaTileEntity().isActive(), nbt.func_74762_e("mMaxProgressTime"), nbt.func_74762_e("mProgressTime")));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (!this.getBaseMetaTileEntity().isInvalidTileEntity()) {
            tag.func_74768_a("mProgressTime", this.getProgresstime());
            tag.func_74768_a("mMaxProgressTime", this.maxProgresstime());
        }
    }

    @Override
    protected boolean useMui2() {
        return true;
    }

    @Override
    protected GTGuiTheme getGuiTheme() {
        return GTGuiThemes.PRIMITIVE;
    }

    @Override
    public ModularPanel buildUI(PosGuiData data, PanelSyncManager syncManager, UISettings uiSettings) {
        syncManager.registerSlotGroup("item_inv", 0);
        return (ModularPanel)((ModularPanel)((ModularPanel)GTGuis.mteTemplatePanelBuilder(this, data, syncManager, uiSettings).build().child((IWidget)SlotGroupWidget.builder().matrix(new String[]{"I", "I", "I"}).key('I', index -> {
            String string;
            switch (index) {
                case 0: {
                    string = "overlayItemSlotIngot";
                    break;
                }
                case 1: {
                    string = "overlayItemSlotDust";
                    break;
                }
                case 2: {
                    string = "overlayItemSlotFurnace";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + index);
                }
            }
            String textureThemeId = string;
            return new ItemSlot().slot(new ModularSlot((IItemHandler)this.inventoryHandler, index).slotGroup("item_inv")).widgetTheme(textureThemeId);
        }).build().pos(33, 15))).child((IWidget)SlotGroupWidget.builder().matrix(new String[]{"III"}).key('I', index -> {
            String string;
            switch (index) {
                case 0: {
                    string = "overlayItemSlotIngot";
                    break;
                }
                case 1: 
                case 2: {
                    string = "overlayItemSlotDust";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + index);
                }
            }
            String textureThemeId = string;
            return new ItemSlot().slot(new ModularSlot((IItemHandler)this.inventoryHandler, index + 3).accessibility(false, true).slotGroup("item_inv")).widgetTheme(textureThemeId);
        }).build().pos(85, 24))).child((IWidget)((ProgressWidget)new GTProgressWidget().neiTransferRect(this.getRecipeMap()).value((IDoubleValue)new DoubleSyncValue(() -> (double)this.mProgresstime / (double)this.mMaxProgresstime)).texture(GTGuiTextures.PROGRESSBAR_ARROW_BBF, 20).pos(58, 24)).size(20, 18));
    }

    @Override
    public SteamVariant getSteamVariant() {
        return SteamVariant.PRIMITIVE;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_INGOT_STEAM.get(this.getSteamVariant())}).setPos(33, 15))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())}).setPos(33, 33))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 2).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_FURNACE_STEAM.get(this.getSteamVariant())}).setPos(33, 51))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 3).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_INGOT_STEAM.get(this.getSteamVariant())}).setPos(85, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 4).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())}).setPos(103, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 5).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())}).setPos(121, 24))).widget(new ProgressBar().setTexture(GTUITextures.PROGRESSBAR_ARROW_2_STEAM.get(this.getSteamVariant()), 20).setProgress(() -> Float.valueOf((float)this.mProgresstime / (float)this.mMaxProgresstime)).setNEITransferRect(this.getRecipeMap().getFrontend().getUIProperties().neiTransferRectId).setPos(58, 24).setSize(20, 18));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.STEAM.apply(this.getSteamVariant());
    }

    @Override
    public int getTitleColor() {
        return (Integer)this.COLOR_TITLE_WHITE.get();
    }
}

