/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ProcessingPlank
implements IOreRecipeRegistrator {
    private static final String[] SPECIAL_PLANKS = new String[]{"witchery:witchwood", "GalacticraftAmunRa:tile.wood1:2", "GalacticraftAmunRa:tile.wood1:3", "etfuturum:wood_planks"};
    private static final String[] SPECIAL_SLABS = new String[]{"witchery:witchwoodslab", "GalacticraftAmunRa:tile.woodSlab:1", "GalacticraftAmunRa:tile.woodSlab:0", "etfuturum:wood_slab"};
    private static final HashSet<String> sProcessedPlanks = new HashSet();

    public ProcessingPlank() {
        OrePrefixes.plank.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aOreDictName.startsWith("plankWood")) {
            boolean tIsWildcard;
            int tPlankMeta = aStack.func_77960_j();
            String tHashPrefix = aModName + ":" + aStack.func_77977_a();
            if (!sProcessedPlanks.add(tHashPrefix + ":" + tPlankMeta)) {
                return;
            }
            boolean bl = tIsWildcard = tPlankMeta == Short.MAX_VALUE;
            if (!tIsWildcard && sProcessedPlanks.contains(tHashPrefix + ":" + Short.MAX_VALUE)) {
                return;
            }
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stick, Materials.Wood, 2L)).duration(10).eut(8).addTo(RecipeMaps.latheRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(8, aStack), GTUtility.getIntegratedCircuit(8)).itemOutputs(new ItemStack((Block)Blocks.field_150486_ae, 1)).duration(800).eut(4).addTo(RecipeMaps.assemblerRecipes);
            if (aStack.func_77973_b() instanceof MetaGeneratedItem) {
                return;
            }
            if (tIsWildcard) {
                ItemStack tStack;
                for (int i = 0; i < 64 && ((tStack = GTUtility.copyMetaData(i, aStack)) != null || i < 16); i = (int)((byte)(i + 1))) {
                    this.convertSlabRecipe(tStack);
                }
            } else {
                this.convertSlabRecipe(aStack);
            }
        }
    }

    private void convertSlabRecipe(ItemStack aStack) {
        SpecialSlabConversionResult tSpecialResult = this.trySpecialSlabConversion(aStack);
        boolean tSkipRecipeCreation = tSpecialResult.isSpecialConversion && tSpecialResult.resultingSlab == null;
        ItemStack tOutput = tSpecialResult.resultingSlab;
        if (tOutput == null) {
            tOutput = GTModHandler.getRecipeOutputPreferNonOreDict(aStack, aStack, aStack);
        }
        if (tOutput == null || tOutput.field_77994_a < 3) {
            return;
        }
        GTModHandler.removeRecipeDelayed(aStack, aStack, aStack);
        if (tSkipRecipeCreation) {
            return;
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTUtility.copyAmount(tOutput.field_77994_a / 3, tOutput)).fluidInputs(Materials.Water.getFluid(4L)).duration(50).eut(4).addTo(RecipeMaps.cutterRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTUtility.copyAmount(tOutput.field_77994_a / 3, tOutput)).fluidInputs(GTModHandler.getDistilledWater(3L)).duration(50).eut(4).addTo(RecipeMaps.cutterRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTUtility.copyAmount(tOutput.field_77994_a / 3, tOutput)).fluidInputs(Materials.Lubricant.getFluid(1L)).duration(25).eut(4).addTo(RecipeMaps.cutterRecipes);
        GTModHandler.addCraftingRecipe(GTUtility.copyAmount(tOutput.field_77994_a / 3, tOutput), GTModHandler.RecipeBits.BUFFERED, new Object[]{"sP", Character.valueOf('P'), aStack});
    }

    private SpecialSlabConversionResult trySpecialSlabConversion(ItemStack aPlankStack) {
        GameRegistry.UniqueIdentifier tIdentifier = GameRegistry.findUniqueIdentifierFor((Item)aPlankStack.func_77973_b());
        int tPlankMeta = aPlankStack.func_77960_j();
        for (int i = 0; i < SPECIAL_PLANKS.length; ++i) {
            int tSlabMeta;
            String[] tSlabParts;
            block4: {
                String[] tPlanksParts;
                String tPlankUniqueId = SPECIAL_PLANKS[i];
                if (tPlankUniqueId == null || (tPlanksParts = tPlankUniqueId.split(":")).length < 2 || !tPlanksParts[0].equals(tIdentifier.modId) || !tPlanksParts[1].equals(tIdentifier.name) || tPlanksParts.length > 2 && !tPlanksParts[2].equals("" + tPlankMeta) || i >= SPECIAL_SLABS.length) continue;
                String tSlabUniqueId = SPECIAL_SLABS[i];
                if (tSlabUniqueId == null) {
                    return new SpecialSlabConversionResult(true, null);
                }
                tSlabParts = tSlabUniqueId.split(":");
                if (tSlabParts.length < 2) continue;
                tSlabMeta = tPlankMeta;
                try {
                    if (tSlabParts.length <= 2) break block4;
                    tSlabMeta = Integer.parseInt(tSlabParts[2]);
                }
                catch (NumberFormatException ignored) {
                    continue;
                }
            }
            return new SpecialSlabConversionResult(true, GTModHandler.getModItem(tSlabParts[0], tSlabParts[1], 6L, tSlabMeta));
        }
        return new SpecialSlabConversionResult(false, null);
    }

    private class SpecialSlabConversionResult {
        private boolean isSpecialConversion;
        private ItemStack resultingSlab;

        private SpecialSlabConversionResult(boolean isSpecialConversion, ItemStack resultingSlab) {
            this.isSpecialConversion = isSpecialConversion;
            this.resultingSlab = resultingSlab;
        }
    }
}

