/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.fluids.GTPPFluids;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchAirIntake;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTELargeRocketEngine
extends GTPPMultiBlockBase<MTELargeRocketEngine>
implements ISurvivalConstructable {
    protected int fuelConsumption = 0;
    protected int fuelValue = 0;
    protected int fuelRemaining = 0;
    protected int freeFuelTicks = 0;
    protected int euProduction = 0;
    protected boolean boostEu = false;
    public static String mLubricantName = "Carbon Dioxide";
    public static String mCoolantName = "Liquid Hydrogen";
    public static String mCasingName = "Turbodyne Casing";
    public static String mIntakeHatchName = "Tungstensteel Turbine Casing";
    public static String mGearboxName = "Inconel Reinforced Casing";
    private static Fluid sAirFluid = null;
    private static FluidStack sAirFluidStack = null;
    private int mCasing;
    private static IStructureDefinition<MTELargeRocketEngine> STRUCTURE_DEFINITION = null;
    private static final int CASING_ID = TAE.getIndexFromPage(3, 11);

    public MTELargeRocketEngine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        MTELargeRocketEngine.setAir();
    }

    public MTELargeRocketEngine(String aName) {
        super(aName);
        MTELargeRocketEngine.setAir();
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Generating Power from Rocket Fuels").addInfo("Supply GT++ Rocket Fuels and 1000L of " + mLubricantName + " per hour").addInfo("Produces as much energy as you put fuel in, with optional boosting").addInfo("This multi doesn't accept fluids if not enabled - enable it first!").addInfo("Consumes 2000L/s of air and pollutes 1500 gibbl/s per 16384 eu/t produced").addInfo("Place 1-8 Air Intake Hatches on the sides to maintain Air input").addInfo("If it runs out of air, it will shut down and have to be manually restarted").addInfo("Supply 3L of " + mCoolantName + " per second, per 1000 EU/t to boost").addInfo("Takes 3x the amount of " + mLubricantName + " and maintains efficiency").addInfo("Fuel efficiency starts at ~160%, falls more slowly at higher EU/t if boosted").addInfo("If producing more than 30k EU/t, fuel efficiency will be lower:").addInfo("(These thresholds are 3x higher when boosted, boosted values displayed second)").addInfo("- 75% of max fuel efficiency at 53k or 159k EU/t output energy").addInfo("- 50% of max fuel efficiency at 69k or 207k EU/t output energy").addInfo("- 25% of max fuel efficiency at 98k or 294k EU/t output energy").addInfo("formula: x = input of energy (30000^(1/3)/ x^(1/3)) * (80000^(1/3)/ x^(1/3))").addTecTechHatchInfo().beginStructureBlock(3, 3, 10, false).addController("Front Center").addCasingInfoMin(mCasingName, 64, false).addCasingInfoMin(mGearboxName, 8, false).addStructureHint("item.GTPP.air_intake_hatch.name", 1).addInputBus("Side center line", 1).addInputHatch("Side center line", 1).addMaintenanceHatch("Any Block Touching Inconel Reinforced Casing", 1).addDynamoHatch("Top center line", 2).addMufflerHatch("Back Center", 3).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTELargeRocketEngine> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC"}, {"C~C", "SIS", "SIS", "SIS", "SIS", "SIS", "SIS", "SIS", "SIS", "CMC"}, {"CCC", "CSC", "CSC", "CSC", "CSC", "CSC", "CSC", "CSC", "CSC", "CCC"}})).addElement('C', StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())).addElement('I', StructureUtility.ofBlock((Block)this.getGearboxBlock(), (int)this.getGearboxMeta())).addElement('S', GTStructureUtility.buildHatchAdder(MTELargeRocketEngine.class).atLeast((Map<IHatchElement<MTELargeRocketEngine>, Number>)ImmutableMap.of((Object)GTPPMultiBlockBase.GTPPHatchElement.AirIntake, (Object)8, (Object)HatchElement.InputBus, (Object)1, (Object)HatchElement.InputHatch, (Object)3, (Object)HatchElement.Maintenance, (Object)1)).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())))).addElement('T', GTStructureUtility.buildHatchAdder(MTELargeRocketEngine.class).atLeast((Map<IHatchElement<MTELargeRocketEngine>, Number>)ImmutableMap.of((Object)GTPPMultiBlockBase.GTPPHatchElement.AirIntake, (Object)8, HatchElement.Dynamo.or(GTPPMultiBlockBase.GTPPHatchElement.TTDynamo), (Object)1, (Object)HatchElement.Maintenance, (Object)1)).casingIndex(this.getCasingTextureIndex()).dot(2).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())))).addElement('M', HatchElement.Muffler.newAny(this.getCasingTextureIndex(), 3)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mTecTechDynamoHatches.clear();
        this.mAllDynamoHatches.clear();
        this.mAirIntakes.clear();
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 16 && !this.mAirIntakes.isEmpty() && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCALargeRocketEngineActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCALargeRocketEngineActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCALargeRocketEngine;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCALargeRocketEngineGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_ID;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    public static void setAir() {
        if (sAirFluidStack == null) {
            sAirFluidStack = Materials.Air.getGas(1L);
        }
        if (sAirFluid == null && sAirFluidStack != null) {
            sAirFluid = sAirFluidStack.getFluid();
        }
    }

    public int getAir() {
        MTELargeRocketEngine.setAir();
        if (this.mAirIntakes.isEmpty() || this.mAirIntakes.size() <= 0) {
            return 0;
        }
        int totalAir = 0;
        for (MTEHatchAirIntake u : this.mAirIntakes) {
            FluidStack f;
            if (u == null || u.mFluid == null || !(f = u.mFluid).isFluidEqual(sAirFluidStack)) continue;
            totalAir += f.amount;
        }
        return totalAir;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.rocketFuels;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        int aSplitAmount;
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        this.clearRecipeMapForAllInputHatches();
        int aircount = this.getAir();
        int aAirToConsume = this.euProduction / 100;
        if (aircount < aAirToConsume) {
            this.stopMachine(ShutDownReasonRegistry.outOfFluid(new FluidStack(sAirFluid, aAirToConsume)));
            return SimpleCheckRecipeResult.ofFailure("no_air");
        }
        int aTotalAir = 0;
        for (MTEHatchAirIntake aAirHatch : this.mAirIntakes) {
            if (aAirHatch.mFluid == null) continue;
            aTotalAir += aAirHatch.getFluidAmount();
        }
        if (aTotalAir >= aAirToConsume && (aSplitAmount = aAirToConsume / this.mAirIntakes.size()) > 0) {
            for (MTEHatchAirIntake aAirHatch : this.mAirIntakes) {
                boolean hasIntakeAir = aAirHatch.drain(aSplitAmount, true) != null;
                if (hasIntakeAir) continue;
                this.freeFuelTicks = 0;
                return SimpleCheckRecipeResult.ofFailure("no_air");
            }
        }
        if (this.freeFuelTicks != 0 && this.mProgresstime == 0 && this.mEfficiency == 0) {
            this.freeFuelTicks = 0;
        }
        if (!tFluids.isEmpty() && this.getRecipeMap() != null) {
            if (this.mRuntime % 72 == 0 && !this.consumeCO2()) {
                this.freeFuelTicks = 0;
                return SimpleCheckRecipeResult.ofFailure("no_co2");
            }
            if (this.freeFuelTicks == 0) {
                this.boostEu = this.consumeLOH();
            }
            for (FluidStack hatchFluid1 : tFluids) {
                if (hatchFluid1.isFluidEqual(sAirFluidStack)) continue;
                if (this.freeFuelTicks == 0) {
                    for (GTRecipe aFuel : this.getRecipeMap().getAllRecipes()) {
                        FluidStack tLiquid = aFuel.mFluidInputs[0];
                        if (!hatchFluid1.isFluidEqual(tLiquid) || !this.consumeFuel(aFuel, hatchFluid1.amount)) continue;
                        this.fuelValue = aFuel.mSpecialValue * 3;
                        this.fuelRemaining = hatchFluid1.amount;
                        this.lEUt = this.mEfficiency < 2000 ? 0L : GTValues.V[5] << 1;
                        this.mProgresstime = 1;
                        this.mMaxProgresstime = 1;
                        this.mEfficiencyIncrease = this.euProduction / 2000;
                        return CheckRecipeResultRegistry.GENERATING;
                    }
                    continue;
                }
                this.mEfficiencyIncrease = this.euProduction / 2000;
                --this.freeFuelTicks;
                this.lEUt = this.mEfficiency < 1000 ? 0L : GTValues.V[5] << 1;
                this.mProgresstime = 1;
                this.mMaxProgresstime = 1;
                return CheckRecipeResultRegistry.GENERATING;
            }
        }
        this.lEUt = 0L;
        this.mEfficiency = 0;
        this.freeFuelTicks = 0;
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    public boolean consumeFuel(GTRecipe aFuel, int amount) {
        amount = (int)((double)amount * (this.boostEu ? 0.3 : 0.9));
        this.freeFuelTicks = 0;
        int value = aFuel.mSpecialValue * 3;
        int energy = value * amount;
        if (amount < 5) {
            return false;
        }
        FluidStack tLiquid = FluidUtils.getFluidStack(aFuel.mFluidInputs[0], this.boostEu ? amount * 3 : amount);
        if (!this.depleteInput(tLiquid)) {
            return false;
        }
        this.fuelConsumption = this.boostEu ? amount * 3 : amount;
        this.freeFuelTicks = 20;
        this.setEUProduction(energy);
        return true;
    }

    public void setEUProduction(int energy) {
        double energyEfficiency;
        double tDivideEnergy = Math.cbrt(energy /= 20);
        if (energy > 30000) {
            energyEfficiency = 31.072325 / tDivideEnergy;
            if (energy >= 80000) {
                energyEfficiency *= 43.0886938 / tDivideEnergy;
            }
            energyEfficiency *= (double)energy;
        } else {
            energyEfficiency = energy;
        }
        this.euProduction = (int)energyEfficiency;
        if (this.boostEu) {
            this.euProduction *= 3;
        }
    }

    public boolean consumeCO2() {
        return this.depleteInput(MaterialMisc.CARBON_DIOXIDE.getFluidStack(this.boostEu ? 3 : 1)) || this.depleteInput(FluidUtils.getFluidStack("carbondioxide", this.boostEu ? 3 : 1));
    }

    public boolean consumeLOH() {
        int LOHamount = 3 * this.euProduction / 1000;
        return this.depleteInput(new FluidStack(GTPPFluids.LiquidHydrogen, LOHamount));
    }

    @Override
    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (!this.mAllDynamoHatches.isEmpty()) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    @Override
    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        long aVoltage;
        int injected = 0;
        long totalOutput = 0L;
        long aFirstVoltageFound = -1L;
        boolean aFoundMixedDynamos = false;
        for (MTEHatch aDynamo : GTUtility.validMTEList(this.mAllDynamoHatches)) {
            aVoltage = aDynamo.maxEUOutput();
            long aTotal = aDynamo.maxAmperesOut() * aVoltage;
            if (aFirstVoltageFound == -1L) {
                aFirstVoltageFound = aVoltage;
            } else if (aFirstVoltageFound != aVoltage) {
                aFoundMixedDynamos = true;
            }
            totalOutput += aTotal;
        }
        if (totalOutput < aEU || aFoundMixedDynamos && !aAllowMixedVoltageDynamos) {
            this.explodeMultiblock();
            return false;
        }
        for (MTEHatch aDynamo : GTUtility.validMTEList(this.mAllDynamoHatches)) {
            long leftToInject = aEU - (long)injected;
            aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int i = 0;
            while ((long)i < Math.min(aDynamo.maxAmperesOut(), (long)(aAmpsToInject + 1))) {
                long powerGain = (long)i == Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject) ? (long)aRemainder : aVoltage;
                aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(powerGain, false);
                injected = (int)((long)injected + powerGain);
                ++i;
            }
        }
        return injected > 0;
    }

    @Override
    protected boolean requiresMuffler() {
        return true;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings4Misc;
    }

    public byte getCasingMeta() {
        return 11;
    }

    public Block getGearboxBlock() {
        return ModBlocks.blockCasings3Misc;
    }

    public byte getGearboxMeta() {
        return 1;
    }

    public byte getCasingTextureIndex() {
        return (byte)CASING_ID;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeRocketEngine(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("freeFuelTicks", this.freeFuelTicks);
        aNBT.func_74768_a("euProduction", this.euProduction);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.freeFuelTicks = aNBT.func_74762_e("freeFuelTicks");
        this.euProduction = aNBT.func_74762_e("euProduction");
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return this.euProduction;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 1500 * (this.euProduction / 10000);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"Rocket Engine", "Current Air: " + this.getAir(), "Time until next fuel consumption: " + this.freeFuelTicks, "Current Output: " + this.lEUt * (long)this.mEfficiency / 10000L + " EU/t", "Fuel Consumption: " + this.fuelConsumption + "L/s", "Fuel Value: " + this.fuelValue + " EU/L", "Fuel Remaining: " + this.fuelRemaining + " Litres", "Current Efficiency: " + this.mEfficiency / 100 + "%", this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance"};
    }

    @Override
    public String getMachineType() {
        return "Rocket Engine";
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }
}

