/*
 * Decompiled with CFR 0.152.
 */
package kubatech.loaders;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.api.event.MobNEIRegistrationEvent;
import com.kuba6000.mobsinfo.api.event.PostMobRegistrationEvent;
import com.kuba6000.mobsinfo.api.event.PreMobsRegistrationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTUtility;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import kubatech.config.Config;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeEntityCrusher;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobHandlerLoader {
    private static final Logger LOG = LogManager.getLogger((String)"kubatech[Mob Handler Loader]");
    private static MobHandlerLoader instance = null;
    public static Map<String, MobEECRecipe> recipeMap = new HashMap<String, MobEECRecipe>();

    public static void init() {
        instance = new MobHandlerLoader();
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SubscribeEvent
    public void onPreMobsRegistration(PreMobsRegistrationEvent event) {
        recipeMap.clear();
    }

    @SubscribeEvent
    public void onPostMobRegistration(PostMobRegistrationEvent event) {
        if (!event.drops.isEmpty() && event.recipe.isUsableInVial) {
            for (MobDrop drop : event.drops) {
                if (!drop.playerOnly) continue;
                drop.additionalInfo.add(StatCollector.func_74837_a((String)"kubatech.mobhandler.eec_chance", (Object[])new Object[]{(double)drop.chance / 100.0 * Config.MobHandler.playerOnlyDropsModifier}));
            }
            ArrayList drops = (ArrayList)event.drops.clone();
            if (!drops.isEmpty()) {
                recipeMap.put(event.currentMob, new MobEECRecipe(drops, event.recipe));
            }
        }
    }

    @SubscribeEvent
    public void onMobNEIRegistration(MobNEIRegistrationEvent event) {
        MobEECRecipe recipe = recipeMap.get(event.mobName);
        if (recipe != null) {
            List list = event.additionalInformation;
            String[] stringArray = new String[2];
            StringBuilder stringBuilder = new StringBuilder().append(GTUtility.trans("153", "Usage: "));
            Objects.requireNonNull(recipe);
            stringArray[0] = stringBuilder.append(GTUtility.formatNumbers(1920L)).append(" EU/t").toString();
            stringArray[1] = GTUtility.trans("158", "Time: ") + GTUtility.formatNumbers((double)recipe.mDuration / 20.0) + " secs";
            list.addAll(Arrays.asList(stringArray));
        }
    }

    public static class MobEECRecipe {
        public final List<MobDrop> mOutputs;
        public final MobRecipe recipe;
        public final int mEUt = 1920;
        public final int mDuration;
        public final EntityLiving entityCopy;

        public MobEECRecipe(List<MobDrop> transformedDrops, MobRecipe recipe) {
            this.mOutputs = transformedDrops;
            this.recipe = recipe;
            try {
                this.entityCopy = this.recipe.createEntityCopy();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            this.mDuration = this.getProgressTimeForAttackDamage(9.0);
        }

        public final int getProgressTimeForAttackDamage(double attackDamage) {
            return Math.max(55, (int)((double)this.recipe.maxEntityHealth / attackDamage * 10.0));
        }

        public ItemStack[] generateOutputs(Random rnd, MTEExtremeEntityCrusher MTE, double attackDamage, int lootinglevel, boolean preferInfernalDrops, boolean voidAllDamagedAndEnchantedItems) {
            MTE.lEUt = 1920L;
            MTE.mMaxProgresstime = this.getProgressTimeForAttackDamage(attackDamage);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.mOutputs.size());
            this.entityCopy.func_70107_b((double)MTE.getBaseMetaTileEntity().getXCoord(), (double)MTE.getBaseMetaTileEntity().getYCoord(), (double)MTE.getBaseMetaTileEntity().getZCoord());
            for (MobDrop o : this.mOutputs) {
                if (voidAllDamagedAndEnchantedItems && (o.damages != null || o.enchantable != null)) continue;
                int chance = o.chance;
                double dChance = (double)chance / 100.0;
                for (IChanceModifier chanceModifier : o.chanceModifiers) {
                    dChance = chanceModifier.apply(dChance, MTE.getBaseMetaTileEntity().getWorld(), stacks, (Entity)MTE.EECPlayer, this.entityCopy);
                }
                chance = (int)(dChance * 100.0);
                if (chance == 0) continue;
                if (o.playerOnly && (chance = (int)((double)chance * Config.MobHandler.playerOnlyDropsModifier)) < 1) {
                    chance = 1;
                }
                int amount = o.stack.field_77994_a;
                if (o.lootable && lootinglevel > 0 && (chance += lootinglevel * 5000) > 10000) {
                    int div = (int)Math.ceil((double)chance / 10000.0);
                    amount *= div;
                    chance /= div;
                }
                if (chance != 10000 && rnd.nextInt(10000) >= chance) continue;
                ItemStack s = o.stack.func_77946_l();
                s.field_77994_a = amount;
                if (o.enchantable != null) {
                    EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)s, (int)o.enchantable);
                }
                if (o.damages != null) {
                    int rChance = rnd.nextInt(this.recipe.mMaxDamageChance);
                    int cChance = 0;
                    for (Map.Entry damage : o.damages.entrySet()) {
                        if (rChance > (cChance += ((Integer)damage.getValue()).intValue())) continue;
                        s.func_77964_b(((Integer)damage.getKey()).intValue());
                        break;
                    }
                }
                stacks.add(s);
            }
            if (Mods.InfernalMobs.isModLoaded()) {
                InfernalMobsCore infernalMobsCore = InfernalMobsCore.instance();
                if (this.recipe.infernalityAllowed && 15360L <= MTE.getMaxInputEu() && !infernalMobsCore.getDimensionBlackList().contains(MTE.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
                    int p = 0;
                    int mods = 0;
                    if (this.recipe.alwaysinfernal || preferInfernalDrops && rnd.nextInt(infernalMobsCore.getEliteRarity()) == 0) {
                        p = 1;
                        if (rnd.nextInt(infernalMobsCore.getUltraRarity()) == 0) {
                            p = 2;
                            if (rnd.nextInt(infernalMobsCore.getInfernoRarity()) == 0) {
                                p = 3;
                            }
                        }
                    }
                    ArrayList infernalstacks = null;
                    if (p > 0) {
                        if (p == 1) {
                            infernalstacks = infernalMobsCore.getDropIdListElite();
                            mods = infernalMobsCore.getMinEliteModifiers();
                        } else if (p == 2) {
                            infernalstacks = infernalMobsCore.getDropIdListUltra();
                            mods = infernalMobsCore.getMinUltraModifiers();
                        } else {
                            infernalstacks = infernalMobsCore.getDropIdListInfernal();
                            mods = infernalMobsCore.getMinInfernoModifiers();
                        }
                    }
                    if (infernalstacks != null) {
                        ItemStack infernalstack = ((ItemStack)infernalstacks.get(rnd.nextInt(infernalstacks.size()))).func_77946_l();
                        EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)infernalstack, (int)infernalstack.func_77973_b().func_77619_b());
                        stacks.add(infernalstack);
                        MTE.lEUt *= 8L;
                        MTE.mMaxProgresstime = (int)((double)MTE.mMaxProgresstime * ((double)mods * InfernalMobsCore.instance().getMobModHealthFactor()));
                    }
                }
            }
            return stacks.toArray(new ItemStack[0]);
        }
    }
}

