/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;
import tectech.recipe.TecTechRecipeMaps;
import tectech.thing.metaTileEntity.multi.godforge.MTEBaseModule;

public class MTEMoltenModule
extends MTEBaseModule {
    private long EUt = 0L;
    private int currentParallel = 0;
    long wirelessEUt = 0L;

    public MTEMoltenModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMoltenModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMoltenModule(this.mName);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.mSpecialValue > MTEMoltenModule.this.getHeat()) {
                    return CheckRecipeResultRegistry.insufficientHeat(recipe.mSpecialValue);
                }
                if ((long)recipe.mEUt > MTEMoltenModule.this.getProcessingVoltage()) {
                    return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                }
                MTEMoltenModule.this.wirelessEUt = (long)recipe.mEUt * (long)MTEMoltenModule.this.getActualParallel();
                if (WirelessNetworkManager.getUserEU(MTEMoltenModule.this.userUUID).compareTo(BigInteger.valueOf(MTEMoltenModule.this.wirelessEUt * (long)recipe.mDuration)) < 0) {
                    return CheckRecipeResultRegistry.insufficientPower(MTEMoltenModule.this.wirelessEUt * (long)recipe.mDuration);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTEMoltenModule.this.getSafeProcessingVoltage()).setRecipeHeat(recipe.mSpecialValue).setHeatOC(true).setHeatDiscount(true).setMachineHeat(Math.max(recipe.mSpecialValue, MTEMoltenModule.this.getHeatForOC())).setHeatDiscountMultiplier(MTEMoltenModule.this.getHeatEnergyDiscount()).setDurationDecreasePerOC(MTEMoltenModule.this.getOverclockTimeFactor());
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GTRecipe recipe) {
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap(MTEMoltenModule.this.userUUID, -this.calculatedEut * (long)this.duration)) {
                    return CheckRecipeResultRegistry.insufficientPower(this.calculatedEut * (long)this.duration);
                }
                MTEMoltenModule.this.addToPowerTally(BigInteger.valueOf(this.calculatedEut).multiply(BigInteger.valueOf(this.duration)));
                MTEMoltenModule.this.addToRecipeTally(this.calculatedParallels);
                MTEMoltenModule.this.currentParallel = this.calculatedParallels;
                MTEMoltenModule.this.EUt = this.calculatedEut;
                this.overwriteCalculatedEut(0L);
                MTEMoltenModule.this.setCurrentRecipeHeat(recipe.mSpecialValue);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setUnlimitedTierSkips();
        logic.setMaxParallel(this.getActualParallel());
        logic.setSpeedBonus(this.getSpeedBonus());
        logic.setEuModifier(this.getEnergyDiscount());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.godforgeMoltenRecipes;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add(StatCollector.func_74837_a((String)"GT5U.infodata.progress", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET}));
        str.add(StatCollector.func_74837_a((String)"tt.infodata.multi.currently_using", (Object[])new Object[]{EnumChatFormatting.RED + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.EUt) : "0") + EnumChatFormatting.RESET}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.max_parallel", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getActualParallel())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"GT5U.infodata.parallel.current", (Object[])new Object[]{EnumChatFormatting.RESET + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.currentParallel) : "0")}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.capacity.heat", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getHeat())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.capacity.heat.effective", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getHeatForOC())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.multiplier.recipe_time", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getSpeedBonus())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.multiplier.energy", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getEnergyDiscount())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.divisor.recipe_time.non_perfect_oc", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getOverclockTimeFactor())}));
        return str.toArray(new String[0]);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Blast Smelter").addInfo("This is a module of the Godforge").addInfo("Must be part of a Godforge to function").addInfo("Used for high temperature material liquefaction").addSeparator(EnumChatFormatting.AQUA, 74).addInfo("The second module of the Godforge, this module melts materials directly into").addInfo("their liquid form. If an output material does not have a liquid form, it will be output").addInfo("as a regular solid instead").addInfo("This module is specialized towards parallel processing").beginStructureBlock(7, 7, 13, false).addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Singularity Reinforced Stellar Shielding Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Boundless Gravitationally Severed Structure Casing").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Harmonic Phonon Transmission Conduit").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Celestial Matter Guidance Casing").addStructureInfo(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Stellar Energy Siphon Casing").toolTipFinisher(EnumChatFormatting.AQUA, 74, new String[0]);
        return tt;
    }
}

