/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.enums.SoundResource;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;
import tectech.loader.ConfigHandler;
import tectech.recipe.TecTechRecipeMaps;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.godforge.MTEBaseModule;

public class MTEPlasmaModule
extends MTEBaseModule {
    private long EUt = 0L;
    private int currentParallel = 0;
    private int inputMaxParallel = 0;
    private static final int DEBUG_WINDOW_ID = 11;
    long wirelessEUt = 0L;

    public MTEPlasmaModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPlasmaModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPlasmaModule(this.mName);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                MTEPlasmaModule.this.wirelessEUt = (long)recipe.mEUt * (long)MTEPlasmaModule.this.getActualParallel();
                if (WirelessNetworkManager.getUserEU(MTEPlasmaModule.this.userUUID).compareTo(BigInteger.valueOf(MTEPlasmaModule.this.wirelessEUt * (long)recipe.mDuration)) < 0) {
                    return CheckRecipeResultRegistry.insufficientPower(MTEPlasmaModule.this.wirelessEUt * (long)recipe.mDuration);
                }
                if (recipe.getMetadataOrDefault(GTRecipeConstants.FOG_PLASMA_TIER, 0) > MTEPlasmaModule.this.getPlasmaTier() || recipe.getMetadataOrDefault(GTRecipeConstants.FOG_PLASMA_MULTISTEP, false).booleanValue() && !MTEPlasmaModule.this.isMultiStepPlasmaCapable) {
                    return SimpleCheckRecipeResult.ofFailure("missing_upgrades");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GTRecipe recipe) {
                MTEPlasmaModule.this.wirelessEUt = (long)recipe.mEUt * (long)this.maxParallel;
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap(MTEPlasmaModule.this.userUUID, -this.calculatedEut * (long)this.duration)) {
                    return CheckRecipeResultRegistry.insufficientPower(MTEPlasmaModule.this.wirelessEUt * (long)recipe.mDuration);
                }
                MTEPlasmaModule.this.addToPowerTally(BigInteger.valueOf(this.calculatedEut).multiply(BigInteger.valueOf(this.duration)));
                MTEPlasmaModule.this.addToRecipeTally(this.calculatedParallels);
                MTEPlasmaModule.this.currentParallel = this.calculatedParallels;
                MTEPlasmaModule.this.EUt = this.calculatedEut;
                this.overwriteCalculatedEut(0L);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTEPlasmaModule.this.getSafeProcessingVoltage()).setDurationDecreasePerOC(MTEPlasmaModule.this.getOverclockTimeFactor());
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setUnlimitedTierSkips();
        logic.setMaxParallel(this.getActualParallel());
        logic.setSpeedBonus(this.getSpeedBonus());
        logic.setEuModifier(this.getEnergyDiscount());
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(11, this::createDebugWindow);
        if (ConfigHandler.debug.DEBUG_MODE) {
            builder.widget((Widget)this.createDebugWindowButton());
        }
    }

    protected ButtonWidget createDebugWindowButton() {
        Widget button = new ButtonWidget().setOnClick((data, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(11);
            }
        }).setPlayClickSound(false).setBackground(new IDrawable[]{TecTechUITextures.BUTTON_CELESTIAL_32x32, TecTechUITextures.OVERLAY_BUTTON_LOAF_MODE}).addTooltip(StatCollector.func_74838_a((String)"tt.gui.tooltip.plasma_module.debug_window")).setTooltipShowUpDelay(5).setPos(174, 91).setSize(16, 16);
        return (ButtonWidget)button;
    }

    protected ModularWindow createDebugWindow(EntityPlayer player) {
        int WIDTH = 78;
        int HEIGHT = 60;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)78, (int)60);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(78, 60)).add(75, 0)));
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.isMultiStepPlasmaCapable = !this.isMultiStepPlasmaCapable;
        }).setPlayClickSoundResource(() -> this.isAllowedToWork() ? SoundResource.GUI_BUTTON_UP.resourceLocation : SoundResource.GUI_BUTTON_DOWN.resourceLocation).setBackground(() -> {
            if (this.isMultiStepPlasmaCapable) {
                return new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON};
            }
            return new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_OFF};
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isAllowedToWork, val -> {
            if (val.booleanValue()) {
                this.enableWorking();
            } else {
                this.disableWorking();
            }
        }), (IWidgetBuilder)builder).addTooltip(StatCollector.func_74838_a((String)"tt.gui.tooltip.plasma_module.debug_window.multi_step")).setTooltipShowUpDelay(5).setPos(4, 40).setSize(16, 16));
        builder.widget(new TextFieldWidget().setSetterInt(this::setPlasmaTier).setGetterInt(this::getPlasmaTier).setNumbers(0, 2).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setPos(3, 18).addTooltip(StatCollector.func_74838_a((String)"tt.gui.tooltip.plasma_module.debug_window.fusion_tier")).setTooltipShowUpDelay(5).setSize(16, 16).setPos(4, 20).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        builder.widget(new TextFieldWidget().setSetterInt(val -> {
            this.inputMaxParallel = val;
        }).setGetterInt(() -> this.inputMaxParallel).setNumbers(0, Integer.MAX_VALUE).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setPos(3, 18).addTooltip(StatCollector.func_74838_a((String)"tt.gui.tooltip.plasma_module.debug_window.parallel")).setTooltipShowUpDelay(5).setSize(70, 16).setPos(4, 4).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        return builder.build();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.godforgePlasmaRecipes;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add(StatCollector.func_74837_a((String)"GT5U.infodata.progress", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET}));
        str.add(StatCollector.func_74837_a((String)"tt.infodata.multi.currently_using", (Object[])new Object[]{EnumChatFormatting.RED + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.EUt) : "0") + EnumChatFormatting.RESET}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.max_parallel", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getActualParallel())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"GT5U.infodata.parallel.current", (Object[])new Object[]{EnumChatFormatting.RESET + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.currentParallel) : "0")}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.multiplier.recipe_time", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getSpeedBonus())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.multiplier.energy", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getEnergyDiscount())}));
        str.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tt.infodata.multi.divisor.recipe_time.non_perfect_oc", (Object[])new Object[]{EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getOverclockTimeFactor())}));
        return str.toArray(new String[0]);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Plasma Fabricator").addInfo("This is a module of the Godforge").addInfo("Must be part of a Godforge to function").addInfo("Used for extreme temperature matter ionization").addSeparator(EnumChatFormatting.AQUA, 74).addInfo("The third module of the Godforge, this module infuses materials with extreme amounts").addInfo("of heat, ionizing and turning them into plasma directly. Not all plasmas can be produced").addInfo("right away, some of them require certain upgrades to be unlocked").addInfo("This module is specialized towards energy and overclock efficiency").beginStructureBlock(7, 7, 13, false).addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Singularity Reinforced Stellar Shielding Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Boundless Gravitationally Severed Structure Casing").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Harmonic Phonon Transmission Conduit").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Celestial Matter Guidance Casing").addStructureInfo(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Stellar Energy Siphon Casing").toolTipFinisher(EnumChatFormatting.AQUA, 74, new String[0]);
        return tt;
    }
}

