/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.client.GrassColorizerAlternate;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class GrassSlab
extends BlockSlab {
    public static final String[] blockType = new String[]{"grass", "bluegrass", "autumngrass"};

    public GrassSlab(boolean isDoubleSlab) {
        super(isDoubleSlab, Material.field_151578_c);
        this.func_149711_c(0.6f);
        this.func_149672_a(Block.field_149779_h);
        this.field_149783_u = true;
        if (!isDoubleSlab) {
            this.func_149647_a((CreativeTabs)NaturaTab.tab);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("natura:grass_top");
    }

    public String func_150002_b(int meta) {
        if (meta < 0 || meta >= blockType.length) {
            meta = 0;
        }
        return "block.soil." + blockType[meta] + ".slab";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        if (this.field_150004_a) {
            return Item.func_150898_a((Block)NContent.grassSlab);
        }
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return Item.func_150898_a((Block)NContent.grassSlab);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerGrass.func_77480_a((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        double d0 = 0.5;
        double d1 = 1.0;
        switch (meta) {
            case 1: {
                return GrassColorizerAlternate.getBlueGrassColor(d0, 0.5);
            }
            case 2: {
                return GrassColorizerAlternate.getOrangeGrassColor(1.0, 1.0);
            }
        }
        return ColorizerGrass.func_77480_a((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int l = 0;
        int i1 = 0;
        int j1 = 0;
        int meta = world.func_72805_g(x, y, z);
        for (int k1 = -1; k1 <= 1; ++k1) {
            for (int l1 = -1; l1 <= 1; ++l1) {
                BiomeGenBase biome = world.func_72807_a(x + l1, z + k1);
                int grassColor = 0;
                double temp = 0.0;
                double rainfall = 0.0;
                switch (meta) {
                    case 1: {
                        temp = MathHelper.func_76131_a((float)biome.func_150564_a(x, y, z), (float)0.0f, (float)1.0f);
                        rainfall = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
                        grassColor = GrassColorizerAlternate.getBlueGrassColor(temp, rainfall);
                        break;
                    }
                    case 2: {
                        temp = MathHelper.func_76131_a((float)biome.func_150564_a(x, y, z), (float)0.0f, (float)1.0f);
                        rainfall = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
                        grassColor = GrassColorizerAlternate.getOrangeGrassColor(temp, rainfall);
                        break;
                    }
                    default: {
                        grassColor = biome.func_150558_b(x, y, z);
                    }
                }
                l += (grassColor & 0xFF0000) >> 16;
                i1 += (grassColor & 0xFF00) >> 8;
                j1 += grassColor & 0xFF;
            }
        }
        return (l / 9 & 0xFF) << 16 | (i1 / 9 & 0xFF) << 8 | j1 / 9 & 0xFF;
    }
}

