/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.tech;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NetherPistonBase
extends BlockPistonBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon iIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon tIcon;
    private boolean sticky;

    public NetherPistonBase(boolean sticky) {
        super(sticky);
        this.sticky = sticky;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_150073_e() {
        return this.tIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getBaseIcon(String par0Str) {
        return par0Str == "piston_side" ? NContent.piston.field_149761_L : (par0Str == "piston_top_normal" ? NContent.piston.tIcon : (par0Str == "piston_top_sticky" ? NContent.piston.tIcon : (par0Str == "piston_inner" ? NContent.piston.iIcon : null)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("natura:piston_side");
        this.tIcon = par1IconRegister.func_94245_a(this.sticky ? "natura:piston_top_sticky" : "natura:piston_top_normal");
        this.iIcon = par1IconRegister.func_94245_a("natura:piston_inner");
        this.bIcon = par1IconRegister.func_94245_a("natura:piston_bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int k = NetherPistonBase.getOrientation(meta);
        return k > 5 ? this.tIcon : (side == k ? (!NetherPistonBase.isExtended(meta) && this.field_149759_B <= 0.0 && this.field_149760_C <= 0.0 && this.field_149754_D <= 0.0 && this.field_149755_E >= 1.0 && this.field_149756_F >= 1.0 && this.field_149757_G >= 1.0 ? this.tIcon : this.iIcon) : (side == Facing.field_71588_a[k] ? this.bIcon : this.field_149761_L));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        return false;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = NetherPistonBase.determineOrientation(par1World, par2, par3, par4, par5EntityLivingBase);
        par1World.func_72921_c(par2, par3, par4, l, 2);
        if (!par1World.field_72995_K) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
        if (!par1World.field_72995_K) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        if (!par1World.field_72995_K && par1World.func_147438_o(par2, par3, par4) == null) {
            this.updatePistonState(par1World, par2, par3, par4);
        }
    }

    private void updatePistonState(World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72805_g(par2, par3, par4);
        int i1 = NetherPistonBase.getOrientation(l);
        if (i1 != 7) {
            boolean flag = this.isIndirectlyPowered(par1World, par2, par3, par4, i1);
            if (flag && !NetherPistonBase.isExtended(l)) {
                if (NetherPistonBase.canExtend(par1World, par2, par3, par4, i1)) {
                    par1World.func_147452_c(par2, par3, par4, (Block)this, 0, i1);
                }
            } else if (!flag && NetherPistonBase.isExtended(l)) {
                par1World.func_72921_c(par2, par3, par4, i1, 2);
                par1World.func_147452_c(par2, par3, par4, (Block)this, 1, i1);
            }
        }
    }

    private boolean isIndirectlyPowered(World par1World, int par2, int par3, int par4, int par5) {
        return par5 != 0 && par1World.func_94574_k(par2, par3 - 1, par4, 0) ? true : (par5 != 1 && par1World.func_94574_k(par2, par3 + 1, par4, 1) ? true : (par5 != 2 && par1World.func_94574_k(par2, par3, par4 - 1, 2) ? true : (par5 != 3 && par1World.func_94574_k(par2, par3, par4 + 1, 3) ? true : (par5 != 5 && par1World.func_94574_k(par2 + 1, par3, par4, 5) ? true : (par5 != 4 && par1World.func_94574_k(par2 - 1, par3, par4, 4) ? true : (par1World.func_94574_k(par2, par3, par4, 0) ? true : (par1World.func_94574_k(par2, par3 + 2, par4, 1) ? true : (par1World.func_94574_k(par2, par3 + 1, par4 - 1, 2) ? true : (par1World.func_94574_k(par2, par3 + 1, par4 + 1, 3) ? true : (par1World.func_94574_k(par2 - 1, par3 + 1, par4, 4) ? true : par1World.func_94574_k(par2 + 1, par3 + 1, par4, 5)))))))))));
    }

    public boolean func_149696_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        if (!par1World.field_72995_K) {
            boolean flag = this.isIndirectlyPowered(par1World, par2, par3, par4, par6);
            if (flag && par5 == 1) {
                par1World.func_72921_c(par2, par3, par4, par6 | 8, 2);
                return false;
            }
            if (!flag && par5 == 0) {
                return false;
            }
        }
        if (par5 == 0) {
            if (!this.tryExtend(par1World, par2, par3, par4, par6)) {
                return false;
            }
            par1World.func_72921_c(par2, par3, par4, par6 | 8, 2);
            par1World.func_72908_a((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "tile.piston.out", 0.5f, par1World.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (par5 == 1) {
            TileEntity tileentity = par1World.func_147438_o(par2 + Facing.field_71586_b[par6], par3 + Facing.field_71587_c[par6], par4 + Facing.field_71585_d[par6]);
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).func_145866_f();
            }
            par1World.func_147465_d(par2, par3, par4, (Block)Blocks.field_150331_J, par6, 3);
            par1World.func_147455_a(par2, par3, par4, BlockPistonMoving.func_149962_a((Block)this, (int)par6, (int)par6, (boolean)false, (boolean)true));
            if (this.sticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity1;
                int j1 = par2 + Facing.field_71586_b[par6] * 2;
                int k1 = par3 + Facing.field_71587_c[par6] * 2;
                int l1 = par4 + Facing.field_71585_d[par6] * 2;
                Block i2 = par1World.func_147439_a(j1, k1, l1);
                int j2 = par1World.func_72805_g(j1, k1, l1);
                boolean flag1 = false;
                if (i2 == Blocks.field_150331_J && (tileentity1 = par1World.func_147438_o(j1, k1, l1)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).func_145864_c() == par6 && tileentitypiston.func_145868_b()) {
                    tileentitypiston.func_145866_f();
                    i2 = tileentitypiston.func_145861_a();
                    j2 = tileentitypiston.func_145832_p();
                    flag1 = true;
                }
                if (!flag1 && i2 != null && NetherPistonBase.canPushBlock(i2, par1World, j1, k1, l1, false) && (i2.func_149656_h() == 0 || i2 == NContent.piston || i2 == NContent.pistonSticky)) {
                    par1World.func_147465_d(par2 += Facing.field_71586_b[par6], par3 += Facing.field_71587_c[par6], par4 += Facing.field_71585_d[par6], (Block)Blocks.field_150331_J, j2, 3);
                    par1World.func_147455_a(par2, par3, par4, BlockPistonMoving.func_149962_a((Block)i2, (int)j2, (int)par6, (boolean)false, (boolean)false));
                    par1World.func_147468_f(j1, k1, l1);
                } else if (!flag1) {
                    par1World.func_147468_f(par2 + Facing.field_71586_b[par6], par3 + Facing.field_71587_c[par6], par4 + Facing.field_71585_d[par6]);
                }
            } else {
                par1World.func_147468_f(par2 + Facing.field_71586_b[par6], par3 + Facing.field_71587_c[par6], par4 + Facing.field_71585_d[par6]);
            }
            par1World.func_72908_a((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "tile.piston.in", 0.5f, par1World.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int l = par1IBlockAccess.func_72805_g(par2, par3, par4);
        if (NetherPistonBase.isExtended(l)) {
            float f = 0.25f;
            switch (NetherPistonBase.getOrientation(l)) {
                case 0: {
                    this.func_149676_a(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.func_149676_a(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    public boolean func_149686_d() {
        return false;
    }

    public static int getOrientation(int par0) {
        return par0 & 7;
    }

    public static boolean isExtended(int par0) {
        return (par0 & 8) != 0;
    }

    public static int determineOrientation(World par0World, int par1, int par2, int par3, EntityLivingBase par4EntityLivingBase) {
        int l;
        if (MathHelper.func_76135_e((float)((float)par4EntityLivingBase.field_70165_t - (float)par1)) < 2.0f && MathHelper.func_76135_e((float)((float)par4EntityLivingBase.field_70161_v - (float)par3)) < 2.0f) {
            double d0 = par4EntityLivingBase.field_70163_u + 1.82 - (double)par4EntityLivingBase.field_70129_M;
            if (d0 - (double)par2 > 2.0) {
                return 1;
            }
            if ((double)par2 - d0 > 0.0) {
                return 0;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(par4EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : (l == 3 ? 4 : 0)));
    }

    private static boolean canPushBlock(Block par0, World par1World, int par2, int par3, int par4, boolean par5) {
        if (par0 == Blocks.field_150343_Z) {
            return false;
        }
        if (par0 != NContent.piston && par0 != NContent.pistonSticky) {
            if (par0.func_149712_f(par1World, par2, par3, par4) == -1.0f) {
                return false;
            }
            if (par0.func_149656_h() == 2) {
                return false;
            }
            if (par0.func_149656_h() == 1) {
                return par5;
            }
        } else if (NetherPistonBase.isExtended(par1World.func_72805_g(par2, par3, par4))) {
            return false;
        }
        return !par1World.func_147439_a(par2, par3, par4).hasTileEntity(0);
    }

    private static boolean canExtend(World par0World, int par1, int par2, int par3, int par4) {
        int i1 = par1 + Facing.field_71586_b[par4];
        int j1 = par2 + Facing.field_71587_c[par4];
        int k1 = par3 + Facing.field_71585_d[par4];
        for (int l1 = 0; l1 < 13; ++l1) {
            if (j1 <= 0 || j1 >= par0World.func_72800_K() - 1) {
                return false;
            }
            Block i2 = par0World.func_147439_a(i1, j1, k1);
            if (par0World.func_147437_c(i1, j1, k1)) break;
            if (!NetherPistonBase.canPushBlock(i2, par0World, i1, j1, k1, true)) {
                return false;
            }
            if (i2.func_149656_h() == 1) break;
            if (l1 == 12) {
                return false;
            }
            i1 += Facing.field_71586_b[par4];
            j1 += Facing.field_71587_c[par4];
            k1 += Facing.field_71585_d[par4];
        }
        return true;
    }

    private boolean tryExtend(World par1World, int par2, int par3, int par4, int par5) {
        int j3;
        int i3;
        int l2;
        Block i2;
        int l1;
        int newX = par2 + Facing.field_71586_b[par5];
        int newY = par3 + Facing.field_71587_c[par5];
        int newZ = par4 + Facing.field_71585_d[par5];
        for (l1 = 0; l1 < 13; ++l1) {
            if (newY <= 0 || newY >= par1World.func_72800_K() - 1) {
                return false;
            }
            i2 = par1World.func_147439_a(newX, newY, newZ);
            if (par1World.func_147437_c(newX, newY, newZ)) break;
            if (!NetherPistonBase.canPushBlock(i2, par1World, newX, newY, newZ, true)) {
                return false;
            }
            if (i2.func_149656_h() != 1) {
                if (l1 == 12) {
                    return false;
                }
                newX += Facing.field_71586_b[par5];
                newY += Facing.field_71587_c[par5];
                newZ += Facing.field_71585_d[par5];
                continue;
            }
            float chance = i2 instanceof BlockSnow ? -1.0f : 1.0f;
            i2.func_149690_a(par1World, newX, newY, newZ, par1World.func_72805_g(newX, newY, newZ), chance, 0);
            par1World.func_147468_f(newX, newY, newZ);
            break;
        }
        l1 = newX;
        i2 = par1World.func_147439_a(newX, newY, newZ);
        int j2 = newZ;
        int k2 = 0;
        Block[] aint = new Block[13];
        while (newX != par2 || newY != par3 || newZ != par4) {
            l2 = newX - Facing.field_71586_b[par5];
            i3 = newY - Facing.field_71587_c[par5];
            j3 = newZ - Facing.field_71585_d[par5];
            Block k3 = par1World.func_147439_a(l2, i3, j3);
            int l3 = par1World.func_72805_g(l2, i3, j3);
            if (k3 == this && l2 == par2 && i3 == par3 && j3 == par4) {
                par1World.func_147465_d(newX, newY, newZ, (Block)Blocks.field_150331_J, par5 | (this.sticky ? 8 : 0), 4);
                par1World.func_147455_a(newX, newY, newZ, BlockPistonMoving.func_149962_a((Block)NContent.pistonExtension, (int)(par5 | (this.sticky ? 8 : 0)), (int)par5, (boolean)true, (boolean)false));
            } else {
                par1World.func_147465_d(newX, newY, newZ, (Block)Blocks.field_150331_J, l3, 4);
                par1World.func_147455_a(newX, newY, newZ, BlockPistonMoving.func_149962_a((Block)k3, (int)l3, (int)par5, (boolean)true, (boolean)false));
            }
            aint[k2++] = k3;
            newX = l2;
            newY = i3;
            newZ = j3;
        }
        newX = l1;
        i2 = par1World.func_147439_a(newX, newY, newZ);
        newZ = j2;
        k2 = 0;
        while (newX != par2 || newY != par3 || newZ != par4) {
            l2 = newX - Facing.field_71586_b[par5];
            i3 = newY - Facing.field_71587_c[par5];
            j3 = newZ - Facing.field_71585_d[par5];
            par1World.func_147459_d(l2, i3, j3, aint[k2++]);
            newX = l2;
            newY = i3;
            newZ = j3;
        }
        return true;
    }
}

