/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.common.inventory.HandlerItemEssentiaCell;
import thaumicenergistics.common.storage.AspectStack;

public class HandlerItemEssentiaCellCreative
extends HandlerItemEssentiaCell {
    public HandlerItemEssentiaCellCreative(ItemStack storageStack, ISaveProvider saveProvider) {
        super(storageStack, saveProvider);
        this.partitionAspects.addAll(Aspect.aspects.values());
        this.totalBytes = 0L;
        this.totalEssentiaStorage = 0L;
    }

    @Override
    public boolean canAccept(IAEFluidStack input) {
        return false;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        Aspect requestAspect;
        if (request != null && request.getFluid() != null && request.getFluid() instanceof GaseousEssentia && (requestAspect = ((GaseousEssentia)request.getFluid()).getAspect()) != null && this.partitionAspects.contains(requestAspect)) {
            return request.copy();
        }
        return null;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> availableList, int iteration) {
        for (Aspect aspect : this.partitionAspects) {
            GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspect);
            availableList.add((IAEStack)EssentiaConversionHelper.INSTANCE.createAEFluidStackInEssentiaUnits(essentiaGas, 2000000000L));
        }
        return availableList;
    }

    @Override
    public long getFreeBytes() {
        return 0L;
    }

    @Override
    public List<IAspectStack> getStoredEssentia() {
        ArrayList<IAspectStack> storedList = new ArrayList<IAspectStack>(this.partitionAspects.size());
        for (Aspect aspect : this.partitionAspects) {
            storedList.add(new AspectStack(aspect, 1L));
        }
        return storedList;
    }

    @Override
    public long getUsedBytes() {
        return 0L;
    }

    @Override
    public long getUsedTypes() {
        return this.partitionAspects.size();
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        if (input == null) {
            return null;
        }
        return input.copy();
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    @Override
    public boolean isPartitioned() {
        return true;
    }

    @Override
    public boolean isPrioritized(IAEFluidStack input) {
        return false;
    }

    @Override
    public void partitionToCellContents() {
    }

    @Override
    public boolean validForPass(int pass) {
        return false;
    }
}

