/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockUnlitTorch
extends Block
implements IOxygenReliantBlock {
    public boolean lit;
    public Block litVersion;
    public Block unlitVersion;
    public Block fallback;

    protected BlockUnlitTorch(boolean lit, String assetName) {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.lit = lit;
        this.func_149715_a(lit ? 0.9375f : 0.2f);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public static void register(BlockUnlitTorch unlittorch, BlockUnlitTorch littorch, Block vanillatorch) {
        littorch.litVersion = littorch;
        littorch.unlitVersion = unlittorch;
        littorch.fallback = vanillatorch;
        unlittorch.litVersion = littorch;
        unlittorch.unlitVersion = unlittorch;
        unlittorch.fallback = vanillatorch;
        GalacticraftCore.handler.registerTorchType(littorch, vanillatorch);
    }

    public Block changeState() {
        if (this.lit) {
            return this.litVersion;
        }
        return this.unlitVersion;
    }

    private static boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection direction) {
        return world.func_147439_a(x, y, z).isSideSolid((IBlockAccess)world, x, y, z, direction);
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender(this);
    }

    private boolean canPlaceTorchOn(World par1World, int par2, int par3, int par4) {
        if (World.func_147466_a((IBlockAccess)par1World, (int)par2, (int)par3, (int)par4)) {
            return true;
        }
        Block var5 = par1World.func_147439_a(par2, par3, par4);
        return var5.canPlaceTorchOnTop(par1World, par2, par3, par4);
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 - 1, par3, par4, ForgeDirection.EAST) || BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 + 1, par3, par4, ForgeDirection.WEST) || BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 - 1, ForgeDirection.SOUTH) || BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 + 1, ForgeDirection.NORTH) || this.canPlaceTorchOn(par1World, par2, par3 - 1, par4);
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        int var10 = par9;
        if (par5 == 1 && this.canPlaceTorchOn(par1World, par2, par3 - 1, par4)) {
            var10 = 5;
        }
        if (par5 == 2 && BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 + 1, ForgeDirection.NORTH)) {
            var10 = 4;
        }
        if (par5 == 3 && BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 - 1, ForgeDirection.SOUTH)) {
            var10 = 3;
        }
        if (par5 == 4 && BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 + 1, par3, par4, ForgeDirection.WEST)) {
            var10 = 2;
        }
        if (par5 == 5 && BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 - 1, par3, par4, ForgeDirection.EAST)) {
            var10 = 1;
        }
        return var10;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par1World.func_72805_g(par2, par3, par4) == 0) {
            this.func_149726_b(par1World, par2, par3, par4);
        } else {
            this.checkOxygen(par1World, par2, par3, par4);
        }
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        if (par1World.func_72805_g(par2, par3, par4) == 0) {
            if (BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 - 1, par3, par4, ForgeDirection.EAST)) {
                par1World.func_72921_c(par2, par3, par4, 1, 2);
            } else if (BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 + 1, par3, par4, ForgeDirection.WEST)) {
                par1World.func_72921_c(par2, par3, par4, 2, 2);
            } else if (BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 - 1, ForgeDirection.SOUTH)) {
                par1World.func_72921_c(par2, par3, par4, 3, 2);
            } else if (BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 + 1, ForgeDirection.NORTH)) {
                par1World.func_72921_c(par2, par3, par4, 4, 2);
            } else if (this.canPlaceTorchOn(par1World, par2, par3 - 1, par4)) {
                par1World.func_72921_c(par2, par3, par4, 5, 2);
            }
        }
        if (this.dropTorchIfCantStay(par1World, par2, par3, par4)) {
            this.checkOxygen(par1World, par2, par3, par4);
        }
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        if (this.dropTorchIfCantStay(par1World, par2, par3, par4)) {
            int var6 = par1World.func_72805_g(par2, par3, par4);
            boolean var7 = false;
            if (!BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 - 1, par3, par4, ForgeDirection.EAST) && var6 == 1) {
                var7 = true;
            }
            if (!BlockUnlitTorch.isBlockSolidOnSide(par1World, par2 + 1, par3, par4, ForgeDirection.WEST) && var6 == 2) {
                var7 = true;
            }
            if (!BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 - 1, ForgeDirection.SOUTH) && var6 == 3) {
                var7 = true;
            }
            if (!BlockUnlitTorch.isBlockSolidOnSide(par1World, par2, par3, par4 + 1, ForgeDirection.NORTH) && var6 == 4) {
                var7 = true;
            }
            if (!this.canPlaceTorchOn(par1World, par2, par3 - 1, par4) && var6 == 5) {
                var7 = true;
            }
            if (var7) {
                this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
                par1World.func_147449_b(par2, par3, par4, Blocks.field_150350_a);
            } else {
                this.checkOxygen(par1World, par2, par3, par4);
            }
        }
    }

    private void checkOxygen(World world, int x, int y, int z) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            if (OxygenUtil.checkTorchHasOxygen(world, this, x, y, z)) {
                this.onOxygenAdded(world, x, y, z);
            } else {
                this.onOxygenRemoved(world, x, y, z);
            }
        } else {
            world.func_147465_d(x, y, z, this.fallback, world.func_72805_g(x, y, z), 2);
        }
    }

    private boolean dropTorchIfCantStay(World par1World, int par2, int par3, int par4) {
        if (this.func_149742_c(par1World, par2, par3, par4)) {
            return true;
        }
        if (par1World.func_147439_a(par2, par3, par4) == this) {
            this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
            par1World.func_147449_b(par2, par3, par4, Blocks.field_150350_a);
        }
        return false;
    }

    public MovingObjectPosition func_149731_a(World par1World, int par2, int par3, int par4, Vec3 par5Vec3, Vec3 par6Vec3) {
        int var7 = par1World.func_72805_g(par2, par3, par4) & 7;
        float var8 = 0.15f;
        switch (var7) {
            case 1: {
                this.func_149676_a(0.0f, 0.2f, 0.5f - var8, var8 * 2.0f, 0.8f, 0.5f + var8);
                break;
            }
            case 2: {
                this.func_149676_a(1.0f - var8 * 2.0f, 0.2f, 0.5f - var8, 1.0f, 0.8f, 0.5f + var8);
                break;
            }
            case 3: {
                this.func_149676_a(0.5f - var8, 0.2f, 0.0f, 0.5f + var8, 0.8f, var8 * 2.0f);
                break;
            }
            case 4: {
                this.func_149676_a(0.5f - var8, 0.2f, 1.0f - var8 * 2.0f, 0.5f + var8, 0.8f, 1.0f);
                break;
            }
            default: {
                var8 = 0.1f;
                this.func_149676_a(0.5f - var8, 0.0f, 0.5f - var8, 0.5f + var8, 0.6f, 0.5f + var8);
            }
        }
        return super.func_149731_a(par1World, par2, par3, par4, par5Vec3, par6Vec3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        boolean doSmoke;
        boolean bl = doSmoke = par5Random.nextInt(5) == 0;
        if (this.lit || doSmoke) {
            int var6 = par1World.func_72805_g(par2, par3, par4);
            double var7 = (float)par2 + 0.5f;
            double var9 = (float)par3 + 0.7f;
            double var11 = (float)par4 + 0.5f;
            double var13 = 0.22f;
            double var15 = 0.27f;
            switch (var6) {
                case 1: {
                    if (doSmoke) {
                        par1World.func_72869_a("smoke", var7 - (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
                    }
                    if (!this.lit) break;
                    par1World.func_72869_a("flame", var7 - (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    if (doSmoke) {
                        par1World.func_72869_a("smoke", var7 + (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
                    }
                    if (!this.lit) break;
                    par1World.func_72869_a("flame", var7 + (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    if (doSmoke) {
                        par1World.func_72869_a("smoke", var7, var9 + (double)0.22f, var11 - (double)0.27f, 0.0, 0.0, 0.0);
                    }
                    if (!this.lit) break;
                    par1World.func_72869_a("flame", var7, var9 + (double)0.22f, var11 - (double)0.27f, 0.0, 0.0, 0.0);
                    break;
                }
                case 4: {
                    if (doSmoke) {
                        par1World.func_72869_a("smoke", var7, var9 + (double)0.22f, var11 + (double)0.27f, 0.0, 0.0, 0.0);
                    }
                    if (!this.lit) break;
                    par1World.func_72869_a("flame", var7, var9 + (double)0.22f, var11 + (double)0.27f, 0.0, 0.0, 0.0);
                    break;
                }
                default: {
                    if (doSmoke) {
                        par1World.func_72869_a("smoke", var7, var9, var11, 0.0, 0.0, 0.0);
                    }
                    if (!this.lit) break;
                    par1World.func_72869_a("flame", var7, var9, var11, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void onOxygenRemoved(World world, int x, int y, int z) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            world.func_147465_d(x, y, z, this.unlitVersion, world.func_72805_g(x, y, z), 2);
        }
    }

    @Override
    public void onOxygenAdded(World world, int x, int y, int z) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            world.func_147465_d(x, y, z, this.litVersion, world.func_72805_g(x, y, z), 2);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(this.litVersion));
        return ret;
    }
}

