/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.lang.reflect.Constructor;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(modid="IC2API", iface="ic2.api.energy.tile.IEnergySink"), @Optional.Interface(modid="IC2API", iface="ic2.api.energy.tile.IEnergyEmitter"), @Optional.Interface(modid="CoFHAPI|energy", iface="cofh.api.energy.IEnergyHandler"), @Optional.Interface(modid="MekanismAPI|energy", iface="mekanism.api.energy.IStrictEnergyAcceptor")})
public abstract class TileBaseUniversalConductor
extends TileBaseConductor
implements IEnergySink,
IEnergyEmitter,
IEnergyHandler,
IStrictEnergyAcceptor {
    protected boolean isAddedToEnergyNet;
    protected Object powerHandlerBC;
    private float IC2surplusJoules = 0.0f;

    public TileBaseUniversalConductor() {
        this.initBC();
    }

    @Override
    public void onNetworkChanged() {
    }

    private void initBC() {
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        return EnergyUtil.getAdjacentPowerConnections(this);
    }

    @Override
    public boolean canUpdate() {
        return EnergyConfigHandler.isIndustrialCraft2Loaded();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.isAddedToEnergyNet) {
            if (!this.field_145850_b.field_72995_K) {
                this.initIC();
            }
            this.isAddedToEnergyNet = true;
        }
    }

    @Override
    public void func_145843_s() {
        this.IC2surplusJoules = 0.0f;
        this.unloadTileIC2();
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
            try {
                Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                Object o = constr.newInstance(this);
                if (o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K && EnergyConfigHandler.isIndustrialCraft2Loaded()) {
                try {
                    Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                    Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                    Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                    Object o = constr.newInstance(this);
                    if (o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    public double getDemandedEnergy() {
        if (this.getNetwork() == null) {
            return 0.0;
        }
        if (this.IC2surplusJoules < 0.001f) {
            this.IC2surplusJoules = 0.0f;
            return this.getNetwork().getRequest(this) / EnergyConfigHandler.IC2_RATIO;
        }
        this.IC2surplusJoules = this.getNetwork().produce(this.IC2surplusJoules, true, 1, this);
        if (this.IC2surplusJoules < 0.001f) {
            this.IC2surplusJoules = 0.0f;
            return this.getNetwork().getRequest(this) / EnergyConfigHandler.IC2_RATIO;
        }
        return 0.0;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        int tier;
        TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, directionFrom);
        int n = tier = (int)voltage > 120 ? 2 : 1;
        if (tile instanceof IEnergySource && ((IEnergySource)tile).getOfferedEnergy() >= 128.0) {
            tier = 2;
        }
        float convertedEnergy = (float)amount * EnergyConfigHandler.IC2_RATIO;
        float surplus = this.getNetwork().produce(convertedEnergy, true, tier, this, tile);
        this.IC2surplusJoules = surplus >= 0.001f ? surplus : 0.0f;
        return 0.0;
    }

    public int getSinkTier() {
        return 3;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (emitter instanceof IElectrical || emitter instanceof IConductor) {
            return false;
        }
        try {
            Class<?> conductorIC2 = Class.forName("ic2.api.energy.tile.IEnergyConductor");
            if (conductorIC2.isInstance(emitter)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (receiver instanceof IElectrical || receiver instanceof IConductor) {
            return false;
        }
        try {
            Class<?> conductorIC2 = Class.forName("ic2.api.energy.tile.IEnergyConductor");
            if (conductorIC2.isInstance(receiver)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getNetwork() == null) {
            return 0;
        }
        float receiveGC = (float)maxReceive * EnergyConfigHandler.RF_RATIO;
        float sentGC = receiveGC - this.getNetwork().produce(receiveGC, !simulate, 1, new TileEntity[0]);
        return MathHelper.func_76141_d((float)(sentGC / EnergyConfigHandler.RF_RATIO));
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, from);
        try {
            if (EnergyUtil.clazzEnderIOCable != null && EnergyUtil.clazzEnderIOCable.isInstance(tile)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.getNetwork() == null) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(this.getNetwork().getRequest(this) / EnergyConfigHandler.RF_RATIO));
    }

    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        return amount - (double)(this.getNetwork().produce((float)amount * EnergyConfigHandler.MEKANISM_RATIO, true, 1, this) / EnergyConfigHandler.MEKANISM_RATIO);
    }

    public boolean canReceiveEnergy(ForgeDirection side) {
        if (this.getNetwork() == null) {
            return false;
        }
        TileEntity te = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, side);
        try {
            if (Class.forName("codechicken.multipart.TileMultipart").isInstance(te)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public double getEnergy() {
        return 0.0;
    }

    public void setEnergy(double energy) {
    }

    public double getMaxEnergy() {
        if (this.getNetwork() == null) {
            return 0.0;
        }
        return this.getNetwork().getRequest(this) / EnergyConfigHandler.MEKANISM_RATIO;
    }
}

