/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.components.CheckBoxList;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public abstract class ComponentMenuRedstoneSides
extends ComponentMenu {
    protected static final int RADIO_BUTTON_X_LEFT = 5;
    protected static final int RADIO_BUTTON_X_RIGHT = 65;
    protected static final int RADIO_BUTTON_Y = 23;
    private static final int CHECKBOX_X = 5;
    private static final int CHECKBOX_Y = 35;
    private static final int CHECKBOX_SPACING_X = 70;
    private static final int CHECKBOX_SPACING_Y = 12;
    private static final int MENU_WIDTH = 120;
    private static final int TEXT_MARGIN_X = 5;
    private static final int TEXT_Y = 5;
    private CheckBoxList checkBoxList = new CheckBoxList();
    protected RadioButtonList radioButtonList;
    protected int selection = 63;
    private static final String NBT_ACTIVE = "Selection";
    private static final String NBT_ALL = "RequrieAll";

    public ComponentMenuRedstoneSides(FlowComponent parent) {
        super(parent);
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.checkBoxList.addCheckBox(new CheckBoxSide(i));
        }
        this.radioButtonList = new RadioButtonList(){

            @Override
            public void updateSelectedOption(int selectedOption) {
                ComponentMenuRedstoneSides.this.setFirstOption(selectedOption == 0);
                ComponentMenuRedstoneSides.this.sendServerData(true);
            }
        };
        this.radioButtonList.setSelectedOption(1);
        this.initRadioButtons();
    }

    protected abstract void initRadioButtons();

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        gui.drawSplitString(this.getMessage(), 5, 5, 115, 0.7f, 0x404040);
        this.checkBoxList.draw(gui, mX, mY);
        this.radioButtonList.draw(gui, mX, mY);
    }

    protected abstract String getMessage();

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.checkBoxList.onClick(mX, mY);
        this.radioButtonList.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeBoolean(this.useFirstOption());
        dw.writeData(this.selection, DataBitHelper.MENU_REDSTONE_SETTING);
    }

    @Override
    public void readData(DataReader dr) {
        this.setFirstOption(dr.readBoolean());
        this.selection = dr.readData(DataBitHelper.MENU_REDSTONE_SETTING);
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuRedstoneSides menuRedstone = (ComponentMenuRedstoneSides)menu;
        this.selection = menuRedstone.selection;
        this.setFirstOption(menuRedstone.useFirstOption());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuRedstoneSides newDataRedstone = (ComponentMenuRedstoneSides)newData;
        if (this.useFirstOption() != newDataRedstone.useFirstOption()) {
            this.setFirstOption(newDataRedstone.useFirstOption());
            this.sendClientData(container, true);
        }
        if (this.selection != newDataRedstone.selection) {
            this.selection = newDataRedstone.selection;
            this.sendClientData(container, false);
        }
    }

    private void sendClientData(ContainerManager container, boolean syncRequire) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, syncRequire);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    private void sendServerData(boolean syncRequire) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, syncRequire);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, boolean syncRequire) {
        dw.writeBoolean(syncRequire);
        if (syncRequire) {
            dw.writeBoolean(this.useFirstOption());
        } else {
            dw.writeData(this.selection, DataBitHelper.MENU_REDSTONE_SETTING);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        if (version >= 3) {
            this.selection = nbtTagCompound.func_74771_c(NBT_ACTIVE);
            this.setFirstOption(nbtTagCompound.func_74767_n(NBT_ALL));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_ACTIVE, (byte)this.selection);
        nbtTagCompound.func_74757_a(NBT_ALL, this.useFirstOption());
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        if (dr.readBoolean()) {
            this.setFirstOption(dr.readBoolean());
        } else {
            this.selection = dr.readData(DataBitHelper.MENU_REDSTONE_SETTING);
        }
    }

    protected boolean useFirstOption() {
        return this.radioButtonList.getSelectedOption() == 0;
    }

    protected void setFirstOption(boolean val) {
        this.radioButtonList.setSelectedOption(val ? 0 : 1);
    }

    public boolean isSideRequired(int i) {
        return (this.selection & 1 << i) != 0;
    }

    @Override
    public void addErrors(List<String> errors) {
        if (this.isVisible() && this.selection == 0) {
            errors.add(Localization.NO_REDSTONE_SIDES_ERROR.toString());
        }
    }

    private class CheckBoxSide
    extends CheckBox {
        private int id;

        public CheckBoxSide(int id) {
            super(Localization.getForgeDirectionLocalization(id), 5 + 70 * (id % 2), 35 + 12 * (id / 2));
            this.id = id;
        }

        @Override
        public void setValue(boolean val) {
            ComponentMenuRedstoneSides.this.selection = val ? (ComponentMenuRedstoneSides.this.selection |= 1 << this.id) : (ComponentMenuRedstoneSides.this.selection &= ~(1 << this.id));
        }

        @Override
        public boolean getValue() {
            return (ComponentMenuRedstoneSides.this.selection & 1 << this.id) != 0;
        }

        @Override
        public void onUpdate() {
            ComponentMenuRedstoneSides.this.sendServerData(false);
        }
    }
}

