/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleAddon;

public class ModuleColorRandomizer
extends ModuleAddon {
    private int[] button = new int[]{10, 26, 16, 16};
    private int cooldown;
    private boolean hover;
    private Random random = new Random();

    public ModuleColorRandomizer(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 100;
    }

    @Override
    public int guiHeight() {
        return 50;
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/color_randomizer.png");
        float[] color = this.getColor();
        GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        this.drawImage(gui, 50, 20, 0, 16, 28, 28);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.inRect(x, y, this.button)) {
            this.drawImage(gui, 10, 26, 32, 0, 16, 16);
        } else {
            this.drawImage(gui, 10, 26, 16, 0, 16, 16);
        }
        this.drawImage(gui, 10, 26, 0, 0, 16, 16);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        if (this.inRect(x, y, this.button)) {
            String randomizeString = Localization.MODULES.ADDONS.BUTTON_RANDOMIZE.translate(new String[0]);
            this.drawStringOnMouseOver(gui, randomizeString, x, y, this.button);
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.button)) {
            this.sendPacket(0);
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.cooldown == 0) {
            this.randomizeColor();
            this.cooldown = 5;
        }
    }

    @Override
    public void update() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    private void randomizeColor() {
        int red = this.random.nextInt(256);
        int green = this.random.nextInt(256);
        int blue = this.random.nextInt(256);
        this.setColorVal(0, (byte)red);
        this.setColorVal(1, (byte)green);
        this.setColorVal(2, (byte)blue);
    }

    @Override
    public int numberOfDataWatchers() {
        return 3;
    }

    @Override
    public void initDw() {
        this.addDw(0, 255);
        this.addDw(1, 255);
        this.addDw(2, 255);
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.randomizeColor();
        }
    }

    public int getColorVal(int i) {
        if (this.isPlaceholder()) {
            return 255;
        }
        int tempVal = this.getDw(i);
        if (tempVal < 0) {
            tempVal += 256;
        }
        return tempVal;
    }

    public void setColorVal(int id, int val) {
        this.updateDw(id, val);
    }

    private float getColorComponent(int i) {
        return (float)this.getColorVal(i) / 255.0f;
    }

    @Override
    public float[] getColor() {
        return new float[]{this.getColorComponent(0), this.getColorComponent(1), this.getColorComponent(2)};
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74774_a(this.generateNBTName("Red", id), (byte)this.getColorVal(0));
        tagCompound.func_74774_a(this.generateNBTName("Green", id), (byte)this.getColorVal(1));
        tagCompound.func_74774_a(this.generateNBTName("Blue", id), (byte)this.getColorVal(2));
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setColorVal(0, tagCompound.func_74771_c(this.generateNBTName("Red", id)));
        this.setColorVal(1, tagCompound.func_74771_c(this.generateNBTName("Green", id)));
        this.setColorVal(2, tagCompound.func_74771_c(this.generateNBTName("Blue", id)));
    }
}

