/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import com.google.common.collect.ImmutableList;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BlockComposter;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CompostingRegistry {
    private static final ItemStackMap<Integer> COMPOSTING_REGISTRY = new ItemStackMap();

    public static void init() {
        if (!ConfigFunctions.enableAutoAddComposter) {
            return;
        }
        CompostingRegistry.registerCompostable((List<Object>)ImmutableList.of((Object)new ItemStack((Block)Blocks.field_150329_H, 1, 1), (Object)new ItemStack((Block)Blocks.field_150362_t, 1, Short.MAX_VALUE), (Object)new ItemStack(Items.field_151081_bc), (Object)new ItemStack(Items.field_151080_bb), (Object)new ItemStack(Items.field_151014_N), (Object)"listAllSeeds", (Object)"treeSapling", (Object)"treeLeaves", (Object)ModItems.BEETROOT_SEEDS.newItemStack(), (Object)ModItems.SWEET_BERRIES.newItemStack(), (Object)ModBlocks.MOSS_CARPET.newItemStack(), (Object)ModBlocks.PINK_PETALS.newItemStack(), (Object[])new Object[]{ModBlocks.MANGROVE_ROOTS.newItemStack(), ModBlocks.AZALEA_LEAVES.newItemStack(1, 0)}), 30);
        CompostingRegistry.remove(ModBlocks.AZALEA.newItemStack(1, Short.MAX_VALUE));
        CompostingRegistry.remove(ModBlocks.AZALEA_LEAVES.newItemStack(1, Short.MAX_VALUE));
        CompostingRegistry.registerCompostable((List<Object>)ImmutableList.of((Object)new ItemStack(Blocks.field_150434_aF), (Object)new ItemStack(Items.field_151127_ba), (Object)new ItemStack(Items.field_151120_aE), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 2), (Object)new ItemStack(Blocks.field_150395_bd), (Object)ModBlocks.NETHER_ROOTS.newItemStack(1, Short.MAX_VALUE), (Object)ModBlocks.NETHER_SPROUTS.newItemStack(1, Short.MAX_VALUE), (Object)ModBlocks.TWISTING_VINES.newItemStack(), (Object)ModBlocks.WEEPING_VINES.newItemStack(), (Object)ModBlocks.AZALEA_LEAVES.newItemStack(1, 1)), 50);
        CompostingRegistry.registerCompostable((List<Object>)ImmutableList.of((Object)new ItemStack(Items.field_151034_e), (Object)new ItemStack(ModItems.BEETROOT.get()), (Object)"cropCarrot", (Object)new ItemStack(Items.field_151100_aR, 1, 3), (Object)new ItemStack((Block)Blocks.field_150329_H, 1, 2), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 0), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 1), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 3), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 4), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 5), (Object)new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE), (Object)new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE), (Object[])new Object[]{new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150440_ba), new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack(Items.field_151075_bm), new ItemStack(Blocks.field_150423_aK), "cropPotato", "cropWheat", ModBlocks.ROSE.newItemStack(), ModBlocks.CORNFLOWER.newItemStack(), ModBlocks.LILY_OF_THE_VALLEY.newItemStack(), ModBlocks.WITHER_ROSE.newItemStack(), ModBlocks.NETHER_FUNGUS.newItemStack(1, Short.MAX_VALUE), ModBlocks.SHROOMLIGHT.newItemStack(), ModBlocks.AZALEA.newItemStack(1, 0), ModBlocks.MOSS_BLOCK.newItemStack()}), 65);
        CompostingRegistry.registerCompostable((List<Object>)ImmutableList.of((Object)new ItemStack(Items.field_151168_bH), (Object)new ItemStack(Items.field_151025_P), (Object)new ItemStack(Items.field_151106_aX), (Object)new ItemStack(Blocks.field_150407_cf), (Object)new ItemStack(Blocks.field_150419_aX, 1, Short.MAX_VALUE), (Object)new ItemStack(Blocks.field_150420_aW, 1, Short.MAX_VALUE), (Object)ModBlocks.RED_MUSHROOM.newItemStack(1, Short.MAX_VALUE), (Object)ModBlocks.BROWN_MUSHROOM.newItemStack(1, Short.MAX_VALUE), (Object)ModBlocks.AZALEA.newItemStack(1, 1)), 85);
        CompostingRegistry.registerCompostable((List<Object>)ImmutableList.of((Object)new ItemStack(Blocks.field_150414_aQ), (Object)new ItemStack(Items.field_151105_aU), (Object)new ItemStack(Items.field_151158_bO)), 100);
    }

    public static void registerCompostable(Object itemObj, int percent) {
        if (percent <= 0 || percent > BlockComposter.FULL_META * 100) {
            throw new IllegalArgumentException("Tried to add a composter entry with percent value " + percent + " which is not allowed, should be above 0 and equal to or below" + BlockComposter.FULL_META * 100 + "!");
        }
        if (ModRecipes.validateItems(itemObj)) {
            if (itemObj instanceof ItemStack) {
                COMPOSTING_REGISTRY.put(((ItemStack)itemObj).func_77946_l(), percent);
            } else if (itemObj instanceof String) {
                for (ItemStack oreStack : OreDictionary.getOres((String)((String)itemObj))) {
                    COMPOSTING_REGISTRY.put(oreStack.func_77946_l(), percent);
                }
            } else if (itemObj instanceof Item) {
                COMPOSTING_REGISTRY.put(new ItemStack((Item)itemObj, 1, Short.MAX_VALUE), percent);
            } else if (itemObj instanceof Block && Item.func_150898_a((Block)((Block)itemObj)) != null) {
                COMPOSTING_REGISTRY.put(new ItemStack(Item.func_150898_a((Block)((Block)itemObj)), 1, Short.MAX_VALUE), percent);
            } else {
                throw new IllegalArgumentException("Tried to add " + itemObj + " as a compostable, which is not an Itemstack, item, block or string.");
            }
        }
    }

    public static void registerCompostable(List<Object> list, int percent) {
        list.forEach(o -> CompostingRegistry.registerCompostable(o, percent));
    }

    public static ItemStackMap<Integer> getComposts() {
        return COMPOSTING_REGISTRY;
    }

    public static void remove(String stackOreDict) {
        for (ItemStack stack : OreDictionary.getOres((String)stackOreDict)) {
            CompostingRegistry.remove(stack);
        }
    }

    public static void remove(ItemStack stack) {
        COMPOSTING_REGISTRY.remove(stack);
    }

    public static boolean isCompostable(String stackOreDict) {
        for (ItemStack stack : OreDictionary.getOres((String)stackOreDict)) {
            if (!CompostingRegistry.isCompostable(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompostable(ItemStack stack) {
        return CompostingRegistry.getCompostChance(stack) > 0;
    }

    public static int getCompostChance(ItemStack stack) {
        Integer percent = COMPOSTING_REGISTRY.get(stack);
        if (percent != null) {
            return percent;
        }
        return 0;
    }

    public void printCompostables() {
        CompostingRegistry.getComposts().forEach((key, value) -> Logger.info("Composter entry: " + Item.field_150901_e.func_148750_c((Object)key.func_77973_b()) + " Meta: " + (key.func_77960_j() == Short.MAX_VALUE ? "any" : Integer.valueOf(key.func_77960_j()))));
    }
}

