/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.blocks.ISubBlocksBlock;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseWall
extends BlockWall
implements ISubBlocksBlock {
    private IIcon[] icons;
    private final String[] types;
    private Block mapColorBase;
    private final Map<Integer, Float> hardnesses = Maps.newHashMap();
    private final Map<Integer, Float> resistances = Maps.newHashMap();

    public BaseWall(Material material, String ... names) {
        super(Blocks.field_150348_b);
        this.field_149764_J = material;
        this.types = names;
        this.setNames(names[0].replace("bricks", "brick").replace("tiles", "tile") + "_wall");
        this.func_149647_a(EtFuturum.creativeTabBlocks);
    }

    @Override
    public IIcon[] getIcons() {
        return this.icons;
    }

    protected void setIcons(IIcon[] icons) {
        this.icons = icons;
    }

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @Override
    public String getNameFor(ItemStack stack) {
        String type = this.getTypes()[Math.max(0, stack.func_77960_j() % this.getTypes().length)];
        String string = type = "".equals(type) ? this.func_149739_a().replace("tile.", "").replace(this.getNameDomain() + ".", "") : type;
        if (type.toLowerCase().endsWith("bricks") || type.toLowerCase().endsWith("tiles")) {
            type = type.substring(0, type.length() - 1);
        }
        return type + "_wall";
    }

    public int func_149692_a(int meta) {
        return meta % this.getTypes().length;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.getTypes().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getIcons()[meta % this.icons.length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.setIcons(new IIcon[this.getTypes().length]);
        for (int i = 0; i < this.getIcons().length; ++i) {
            this.getIcons()[i] = "".equals(this.getTypes()[i]) ? reg.func_94245_a(this.func_149641_N()) : reg.func_94245_a((this.getTextureDomain().isEmpty() ? "" : this.getTextureDomain() + ":") + (this.getTextureSubfolder().isEmpty() ? "" : this.getTextureSubfolder() + "/") + this.getTypes()[i]);
        }
    }

    public boolean func_150091_e(IBlockAccess p_150091_1_, int p_150091_2_, int p_150091_3_, int p_150091_4_) {
        Block block = p_150091_1_.func_147439_a(p_150091_2_, p_150091_3_, p_150091_4_);
        return block instanceof BlockFenceGate || block instanceof BaseWall || super.func_150091_e(p_150091_1_, p_150091_2_, p_150091_3_, p_150091_4_);
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public BaseWall setUnlocalizedNameWithPrefix(String name) {
        this.func_149663_c((this.getNameDomain().isEmpty() ? "" : this.getNameDomain() + ".") + name);
        return this;
    }

    public Block func_149658_d(String name) {
        return super.func_149658_d((this.getTextureDomain().isEmpty() ? "" : this.getTextureDomain() + ":") + (this.getTextureSubfolder().isEmpty() ? "" : this.getTextureSubfolder() + "/") + name);
    }

    public BaseWall setNames(String name) {
        this.setUnlocalizedNameWithPrefix(name);
        this.func_149658_d(name);
        return this;
    }

    public BaseWall setToolClass(String toolClass, int level) {
        this.setHarvestLevel(toolClass, level);
        return this;
    }

    public BaseWall setToolClass(String toolClass, int level, int meta) {
        this.setHarvestLevel(toolClass, level, meta);
        return this;
    }

    public BaseWall setBlockSound(Block.SoundType type) {
        Utils.setBlockSound((Block)this, type);
        return this;
    }

    public BaseWall setMapColorBaseBlock(Block block) {
        this.mapColorBase = block;
        return this;
    }

    public MapColor func_149728_f(int meta) {
        return this.mapColorBase == null ? super.func_149728_f(meta) : this.mapColorBase.func_149728_f(meta);
    }

    public float func_149712_f(World worldIn, int x, int y, int z) {
        return this.hardnesses.getOrDefault(worldIn.func_72805_g(x, y, z), Float.valueOf(super.func_149712_f(worldIn, x, y, z))).floatValue();
    }

    public BaseWall setHardnesses(float hardness, int ... metas) {
        if (metas.length == 0) {
            this.func_149711_c(hardness);
        } else {
            for (int meta : metas) {
                this.hardnesses.put(meta, Float.valueOf(hardness));
            }
        }
        return this;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        Float resistance = this.resistances.get(world.func_72805_g(x, y, z));
        if (resistance != null) {
            return resistance.floatValue() / 5.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public BaseWall setResistances(float resistance, int ... metas) {
        if (metas.length == 0) {
            this.func_149752_b(resistance);
        } else {
            for (int meta : metas) {
                this.resistances.put(meta, Float.valueOf(resistance));
            }
        }
        return this;
    }
}

