/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.structurenbt.EFRBlockStateConverter;
import ganymedes01.etfuturum.core.utils.structurenbt.NBTStructure;
import ganymedes01.etfuturum.world.generate.feature.WorldGenFossil;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenNetherFossil
extends WorldGenFossil {
    private final List<NBTStructure> fossils = Lists.newArrayList();

    public WorldGenNetherFossil() {
        for (int i = 1; i <= 14; ++i) {
            this.fossils.add(new NBTStructure("/data/structure/nether_fossils/fossil_" + i + ".nbt", EFRBlockStateConverter.INSTANCE));
        }
    }

    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        ForgeDirection dir;
        NBTStructure fossil = this.fossils.get(rand.nextInt(this.fossils.size()));
        if (!this.canFossilGenerateHere(world, x, y, z, fossil.getSize(dir = ForgeDirection.getOrientation((int)(rand.nextInt(4) + 2))))) {
            return false;
        }
        fossil.placeStructure(world, rand, x, y, z, dir);
        return true;
    }

    @Override
    protected boolean canFossilGenerateHere(World world, int x, int y, int z, BlockPos corners) {
        int air = 0;
        if (!this.validCorner(world, x, y, z)) {
            ++air;
        }
        if (!this.validCorner(world, x + corners.getX(), y, z)) {
            ++air;
        }
        if (!this.validCorner(world, x, y, z + corners.getZ())) {
            ++air;
        }
        if (!this.validCorner(world, x + corners.getX(), y, z + corners.getZ()) && air++ >= 3) {
            return false;
        }
        if (!this.validCorner(world, x + (corners.getX() >> 1), y, z + (corners.getZ() >> 1)) && air++ >= 3) {
            return false;
        }
        return air <= 3;
    }

    @Override
    protected boolean validCorner(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).func_149662_c() && world.func_147437_c(x, y, z);
    }
}

