/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.client.render.ICustomRenderer;
import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.client.texture.ArchitectureTexture;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.EnumWorldBlockLayer;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class ShapeRenderDispatch
implements ICustomRenderer {
    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
        TileShape te = TileShape.get(world, pos);
        if (te != null) {
            Trans3 t2 = t.t(te.localToGlobalRotation());
            boolean renderBase = te.baseBlockState != null && BlockCompatUtils.blockCanRenderInLayer(te.baseBlockState.getBlock(), layer);
            boolean renderSecondary = te.secondaryBlockState != null && BlockCompatUtils.blockCanRenderInLayer(te.secondaryBlockState.getBlock(), layer);
            this.renderShapeTE(te, target, t2, renderBase, renderSecondary);
        }
    }

    @Override
    public void renderItemStack(ItemStack stack, IRenderTarget target, Trans3 t) {
        TileShape te = new TileShape();
        te.readFromItemStack(stack);
        this.renderShapeTE(te, target, t.t(Trans3.sideTurn(0, 3)), te.baseBlockState != null, te.secondaryBlockState != null);
    }

    protected void renderShapeTE(TileShape te, IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
        IBlockState base;
        if (te.shape != null && (renderBase || renderSecondary) && (base = te.baseBlockState) != null) {
            IIcon icon = BlockCompatUtils.getSpriteForBlockState(base);
            IIcon icon2 = BlockCompatUtils.getSpriteForBlockState(te.secondaryBlockState);
            if (icon != null) {
                ITexture[] textures = new ITexture[4];
                if (renderBase) {
                    textures[0] = ArchitectureTexture.fromSpriteAndBlockPlusMeta(icon, base.getBlock(), BlockCompatUtils.getMetaFromBlockState(base));
                    textures[0] = ShapeRenderDispatch.checkBlendAndEmissive(base, textures[0]);
                    textures[1] = textures[0].projected();
                }
                if (renderSecondary) {
                    if (icon2 != null) {
                        textures[2] = ArchitectureTexture.fromSpriteAndBlockPlusMeta(icon2, te.secondaryBlockState.getBlock(), BlockCompatUtils.getMetaFromBlockState(te.secondaryBlockState));
                        textures[2] = ShapeRenderDispatch.checkBlendAndEmissive(te.secondaryBlockState, textures[2]);
                        textures[3] = textures[2].projected();
                    } else {
                        renderSecondary = false;
                    }
                }
                if (renderBase && te.shape.kind.secondaryDefaultsToBase() && (icon2 == null || te.secondaryBlockState != null && te.secondaryBlockState.getBlock().func_149701_w() != 0)) {
                    textures[2] = textures[0];
                    textures[3] = textures[1];
                    renderSecondary = renderBase;
                }
                te.shape.kind.renderShape(te, textures, target, t, renderBase, renderSecondary);
            }
        }
    }

    public static ITexture checkBlendAndEmissive(IBlockState blockState, ITexture texture) {
        boolean needsBlending;
        int meta;
        Block block = blockState.getBlock();
        int blendColor = block.func_149741_i(meta = BlockCompatUtils.getMetaFromBlockState(blockState));
        boolean bl = needsBlending = (blendColor & 0xFFFFFF) != 0xFFFFFF;
        if (needsBlending) {
            double r = (double)((blendColor & 0xFF0000) >> 16) / 255.0;
            double g = (double)((blendColor & 0xFF00) >> 8) / 255.0;
            double b = (double)(blendColor & 0xFF) / 255.0;
            texture = texture.colored(r, g, b);
        }
        if (ShapeRenderDispatch.blockAndMetaNeedsEmissive(block, meta)) {
            texture = texture.emissive();
        }
        return texture;
    }

    static boolean blockAndMetaNeedsEmissive(Block block, int meta) {
        return ArchitectureCraft.client.isBlockAndMetaEmissive(block, meta);
    }
}

